/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.cim.provider.pi;

import com.ibm.hsc.cim.provider.pi.PIClusterModifier;
import com.ibm.hsc.cim.provider.pi.PICommonUtilMethods;
import com.ibm.hsc.cim.provider.pi.PIMemoryComparator;
import com.ibm.hsc.cim.provider.pi.PIProcComparator;
import com.ibm.hsc.cim.provider.pi.PIVirProcComparator;
import com.ibm.hsc.cim.provider.pi.PIVirtualEthernetMACAddressUtils;
import com.ibm.hsc.cim.provider.rs6k.CimomWrapper;
import com.ibm.hsc.common.exceptions.PIHscCmdMgrException;
import com.ibm.hsc.common.exceptions.PIHscServerException;
import com.ibm.hsc.common.util.ByteUtilities;
import com.ibm.hsc.common.util.CmdExtendedError;
import com.ibm.hsc.common.util.CmdExtendedErrorList;
import com.ibm.hsc.common.util.HSCLogUtils;
import com.ibm.hsc.common.util.PIHmcAccessUtils;
import com.ibm.hsc.common.util.Trace;
import com.ibm.hsc.fsp.cmdhelpers.FspCmdHelper;
import com.ibm.hsc.fsp.cmdhelpers.FspISeriesPerfRanges;
import com.ibm.hsc.fsp.cmdhelpers.FspLparMemory;
import com.ibm.hsc.fsp.cmdhelpers.FspLparProcessingInfo;
import com.ibm.hsc.fsp.cmdhelpers.FspLparVioSlotStates;
import com.ibm.hsc.fsp.cmdhelpers.FspLparVirtualOptiConnect;
import com.ibm.hsc.fsp.cmdhelpers.FspRequiredMemoryInfo;
import com.ibm.hsc.fsp.cmdhelpers.FspTaggedIosForOs400;
import com.ibm.hsc.fsp.cmdhelpers.FspVioEtherConfig;
import com.ibm.hsc.fsp.cmdhelpers.FspVioScsiConfig;
import com.ibm.hsc.fsp.cmdhelpers.FspVioSmcaConfig;
import com.ibm.hsc.fsp.cmdhelpers.FspVspAttr;
import com.ibm.hsc.fsp.cmdhelpers.VioSlotState;
import com.ibm.hsc.objmgr.cec.OmCecActResourceUpdater;
import com.ibm.hsc.objmgr.cec.OmCecInstUpdater;
import com.ibm.hsc.objmgr.cec.OmCecMgr;
import com.ibm.hsc.objmgr.lpar.OmLparActResourceUpdater;
import com.ibm.hsc.objmgr.lpar.OmLparMgr;
import com.ibm.hsc.objmgr.lpar.OmLparVsmcaUpdater;
import com.ibm.hsc.rep.RException;
import com.ibm.hsc.rep.RObject;
import com.ibm.hsc.rep.RObjectId;
import com.ibm.hsc.rep.v50.R50ComputerSystem;
import com.ibm.hsc.rep.v50.R50Define;
import com.ibm.hsc.rep.v50.R50Partition;
import com.ibm.hsc.rep.v50.R50VirtualSCSI;
import com.ibm.hsc.rep.v50.R50VirtualSerial;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import java.util.Vector;
import org.snia.wbem.cim.CIMException;
import org.snia.wbem.cim.CIMInstance;
import org.snia.wbem.cim.CIMObjectPath;
import org.snia.wbem.cim.CIMValue;
import org.snia.wbem.cim.UnsignedInt16;
import org.snia.wbem.cim.UnsignedInt32;
import org.snia.wbem.cim.UnsignedInt8;
import org.snia.wbem.client.CIMOMHandle;
import org.snia.wbem.client.ProviderCIMOMHandle;

public class PIResourcesAllocationUtils {
    public static final int RPA_LPAR_BIT = 1;
    public static final int RPA_MEGAMOUTH_LPAR_BIT = 2;
    public static final int OS400_LPAR_BIT = 4;
    public static final int RPA_IOSERVER_LPAR_BIT = 8;
    public static final int ALL_LPAR_TYPES = 65535;
    public static final boolean NEED_VIRTUAL_PROCS = true;
    public static final boolean NEED_PROC_UNITS = false;
    public static final int LPAR_ACTIVATION = 1;
    public static final int DLPAR_ADD = 2;
    public static final int DLPAR_MOVE = 4;
    public static final int DLPAR_REMOVE = 8;
    public static final int DLPAR_CAPPED_TO_UNCAPPED = 16;

    public static void checkDedicatedProcSettings(FspLparProcessingInfo fspLparProcessingInfo, CIMInstance cIMInstance) throws PIHscServerException {
        Trace.trace("appahscT", "-> PIResourcesAllocationUtils.checkDedicatedProcSettings");
        Trace.trace("appahscF", "settings = " + fspLparProcessingInfo);
        Trace.trace("appahscF", "cecInst = " + cIMInstance);
        try {
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            try {
                n = fspLparProcessingInfo.getMinProcs().intValue();
                n2 = fspLparProcessingInfo.getAllocProcs().intValue();
                n3 = fspLparProcessingInfo.getMaxProcs().intValue();
            }
            catch (NullPointerException nullPointerException) {
                try {
                    HSCLogUtils.serverLog(nullPointerException, HSCLogUtils._LPARClassLogInfo);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                throw new PIHscServerException("07E2", null);
            }
            int n4 = 0;
            try {
                n4 = ((UnsignedInt16)cIMInstance.getProperty("ConfigurableProcUnits").getValue().getValue()).intValue();
            }
            catch (NullPointerException nullPointerException) {
                try {
                    HSCLogUtils.serverLog(nullPointerException, HSCLogUtils._LPARClassLogInfo);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                throw new PIHscServerException("2523", new String[]{"R50ComputerSystem.ConfigurableProc"}, nullPointerException);
            }
            if (n4 < n || n4 < n2 || n4 < n3) {
                System.out.println("ERROR: processor needed is greater than configurable proc available");
                throw new PIHscServerException("03F4", null);
            }
            if (n > n2 || n > n3) {
                System.out.println("ERROR: required CPU is greater than desired or max CPU");
                throw new PIHscServerException("07DD", null);
            }
            if (n2 > n3) {
                System.out.println("ERROR: desired CPU is greater than max CPU");
                throw new PIHscServerException("07DD", null);
            }
        }
        catch (Throwable throwable) {
            try {
                HSCLogUtils.serverLog(throwable, HSCLogUtils._LPARClassLogInfo);
            }
            catch (Throwable throwable2) {
                // empty catch block
            }
            throwable.printStackTrace();
            if (!(throwable instanceof PIHscServerException)) {
                throw new PIHscServerException("0621", null);
            }
            throw (PIHscServerException)throwable;
        }
        finally {
            Trace.trace("appahscT", "PIResourcesAllocationUtils.checkDedicatedProcSettings <-");
        }
    }

    public static long getAvailableMem(CIMInstance cIMInstance, CIMInstance cIMInstance2, ProviderCIMOMHandle providerCIMOMHandle, String string) throws PIHscServerException {
        return PIResourcesAllocationUtils.getAvailableMem(cIMInstance, cIMInstance2, providerCIMOMHandle, string, null);
    }

    public static long getAvailableMem(CIMInstance cIMInstance, CIMInstance cIMInstance2, ProviderCIMOMHandle providerCIMOMHandle, String string, Vector vector) throws PIHscServerException {
        String string2 = "";
        long l = 0L;
        long l2 = 0L;
        MemoryTable memoryTable = null;
        long l3 = 0L;
        int n = 0;
        String string3 = null;
        System.out.println("in getAvailableMem: -------------------- ");
        try {
            string2 = (String)cIMInstance2.getProperty("Name").getValue().getValue();
        }
        catch (Throwable throwable) {
            try {
                HSCLogUtils.serverLog(throwable, HSCLogUtils._LPARClassLogInfo);
            }
            catch (Throwable throwable2) {
                // empty catch block
            }
            throw new PIHscServerException("2523", new String[]{"R50ComputerSystem.Name"}, throwable);
        }
        try {
            string3 = (String)cIMInstance.getProperty("Name").getValue().getValue();
        }
        catch (Throwable throwable) {
            try {
                HSCLogUtils.serverLog(throwable, HSCLogUtils._LPARClassLogInfo);
            }
            catch (Throwable throwable3) {
                // empty catch block
            }
            throw new PIHscServerException("2523", new String[]{"R50Partition.Name"}, throwable);
        }
        n = Integer.parseInt(string3.substring(0, string3.indexOf(42)));
        try {
            l = ((UnsignedInt32)cIMInstance2.getProperty("PendAvailMem").getValue().getValue()).intValue();
        }
        catch (Throwable throwable) {
            try {
                HSCLogUtils.serverLog(throwable, HSCLogUtils._LPARClassLogInfo);
            }
            catch (Throwable throwable4) {
                // empty catch block
            }
            throw new PIHscServerException("2523", new String[]{"R50ComputerSystem.PendAvailMem"}, throwable);
        }
        System.out.println("in getAvailMem: MOF_HYP_CUR_AV_MEM = " + l);
        l2 = l;
        memoryTable = PIResourcesAllocationUtils.getLparMemInfo(n, string2, providerCIMOMHandle, string, 65535, vector);
        if (3 <= Trace.LEVEL) {
            Trace.trace("appahscD", "memTable " + memoryTable);
        }
        System.out.println("in getAvailMem: memTable = " + memoryTable);
        l3 = memoryTable.memForNotBootableLpar.longValue();
        System.out.println("in getAvailMem: accumMEM = " + l2);
        System.out.println("in getAvailMem: accumMEM with not bootable resources = " + (l2 += l3));
        LparMemValuePair[] lparMemValuePairArray = memoryTable.lparMemValPairs;
        System.out.println("in getAvailMem: lparMemPairList = " + lparMemValuePairArray);
        int n2 = lparMemValuePairArray.length;
        System.out.println(" size = " + n2);
        for (int i = 0; i < n2; ++i) {
            if (3 <= Trace.LEVEL) {
                Trace.trace("appahscD", "lparMemPairList[" + i + "] = " + lparMemValuePairArray[i]);
            }
            System.out.println("in getAvailMem: lpar mem amount = " + lparMemValuePairArray[i].memAmount);
            System.out.println("in getAvailMem: accumMEM = " + (l2 += lparMemValuePairArray[i].memAmount));
        }
        Trace.trace("appahscT", "PIResourcesAllocationUtils.getAvailableMem <-");
        return l2;
    }

    public static long getAvailProcessing(CIMInstance cIMInstance, CIMInstance cIMInstance2, short s, ProviderCIMOMHandle providerCIMOMHandle, String string) throws PIHscServerException {
        return PIResourcesAllocationUtils.getAvailProcessing(cIMInstance, cIMInstance2, s, providerCIMOMHandle, string, null);
    }

    public static long getAvailProcessing(CIMInstance cIMInstance, CIMInstance cIMInstance2, short s, ProviderCIMOMHandle providerCIMOMHandle, String string, Vector vector) throws PIHscServerException {
        Trace.trace("appahscT", "-> PIResourcesAllocationUtils.getAvailProcessing");
        Trace.trace("appahscF", "lparInstance = " + cIMInstance);
        Trace.trace("appahscF", "cecInstance = " + cIMInstance2);
        Trace.trace("appahscF", "curProcMode = " + s);
        Trace.trace("appahscF", "cimHandle = " + providerCIMOMHandle);
        Trace.trace("appahscF", "namespace = " + string);
        boolean bl = false;
        long l = 0L;
        long l2 = 0L;
        ProcessorTable processorTable = null;
        long l3 = 0L;
        int n = 0;
        String string2 = null;
        Object var16_13 = null;
        String string3 = "";
        System.out.println("in getAvailProcessing: -------------------- ");
        try {
            string3 = (String)cIMInstance2.getProperty("Name").getValue().getValue();
        }
        catch (Throwable throwable) {
            try {
                HSCLogUtils.serverLog(throwable, HSCLogUtils._LPARClassLogInfo);
            }
            catch (Throwable throwable2) {
                // empty catch block
            }
            throw new PIHscServerException("2523", new String[]{"R50ComputerSystem.Name"}, throwable);
        }
        int n2 = 0;
        try {
            n2 = ((UnsignedInt8)cIMInstance2.getProperty("MaxProcPools").getValue().getValue()).intValue();
        }
        catch (Throwable throwable) {
            try {
                HSCLogUtils.serverLog(throwable, HSCLogUtils._LPARClassLogInfo);
            }
            catch (Throwable throwable3) {
                // empty catch block
            }
            throw new PIHscServerException("2523", new String[]{"R50ComputerSystem.MaxProcPools"}, throwable);
        }
        try {
            string2 = (String)cIMInstance.getProperty("Name").getValue().getValue();
        }
        catch (Throwable throwable) {
            try {
                HSCLogUtils.serverLog(throwable, HSCLogUtils._LPARClassLogInfo);
            }
            catch (Throwable throwable4) {
                // empty catch block
            }
            throw new PIHscServerException("2523", new String[]{"R50Partition.Name"}, throwable);
        }
        n = Integer.parseInt(string2.substring(0, string2.indexOf(42)));
        try {
            l = ((UnsignedInt32)cIMInstance2.getProperty("PendAvailProcUnits").getValue().getValue()).intValue();
        }
        catch (Throwable throwable) {
            try {
                HSCLogUtils.serverLog(throwable, HSCLogUtils._LPARClassLogInfo);
            }
            catch (Throwable throwable5) {
                // empty catch block
            }
            throw new PIHscServerException("2523", new String[]{"R50ComputerSystem.PendAvailProcUnits"}, throwable);
        }
        System.out.println("in getAvailProcessing: MOF_HYP_CUR_AV_PROCS = " + l);
        l2 = l;
        processorTable = PIResourcesAllocationUtils.getLparProcInfo(n, string3, 255, providerCIMOMHandle, string, 65535, vector);
        if (3 <= Trace.LEVEL) {
            Trace.trace("appahscD", "procTable " + processorTable);
        }
        System.out.println("in getAvailProcessing: procTable = " + processorTable);
        l3 = processorTable.procUnitsForNotBootableLpar.longValue();
        System.out.println("in getAvailProcessing: accumCPU = " + l2);
        System.out.println("in getAvailProcessing: accumCPU with not bootable resources = " + (l2 += l3));
        LparProcValuePair[] lparProcValuePairArray = processorTable.lparProcValPairs;
        System.out.println("in getAvailProcessing: lparProcPairList = " + lparProcValuePairArray);
        int n3 = lparProcValuePairArray.length;
        System.out.println(" size = " + n3);
        for (int i = 0; i < n3; ++i) {
            if (3 <= Trace.LEVEL) {
                Trace.trace("appahscD", "lparProcPairList[" + i + "] = " + lparProcValuePairArray[i]);
            }
            System.out.println("in getAvailProcessing: lpar proc amount = " + lparProcValuePairArray[i].procAmount);
            System.out.println("in getAvailProcessing: accumCPU = " + (l2 += lparProcValuePairArray[i].procAmount));
        }
        Trace.trace("appahscT", "PIResourcesAllocationUtils.getAvailProcessing <-");
        return l2;
    }

    public static void checkSharedProcSettings(FspLparProcessingInfo fspLparProcessingInfo, CIMInstance cIMInstance) throws PIHscServerException {
        Trace.trace("appahscT", "-> PIResourcesAllocationUtils.checkSharedProcSettings");
        Trace.trace("appahscF", "settings = " + fspLparProcessingInfo);
        Trace.trace("appahscF", "cecInst = " + cIMInstance);
        try {
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            short s = 0;
            short s2 = 0;
            long l = 0L;
            long l2 = 0L;
            long l3 = 0L;
            int n4 = 0;
            try {
                n = fspLparProcessingInfo.getMinProcs().intValue();
                n2 = fspLparProcessingInfo.getAllocProcs().intValue();
                n3 = fspLparProcessingInfo.getMaxProcs().intValue();
                s = fspLparProcessingInfo.getProcType().shortValue();
                s2 = fspLparProcessingInfo.getSharingMode().shortValue();
                l = fspLparProcessingInfo.getMinProcUnits().longValue();
                l2 = fspLparProcessingInfo.getAllocProcUnits().longValue();
                l3 = fspLparProcessingInfo.getMaxProcUnits().longValue();
            }
            catch (NullPointerException nullPointerException) {
                try {
                    HSCLogUtils.serverLog(nullPointerException, HSCLogUtils._LPARClassLogInfo);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                throw new PIHscServerException("07E2", null);
            }
            if (0 != s2) {
                try {
                    n4 = fspLparProcessingInfo.getUncappedWeight().intValue();
                }
                catch (NullPointerException nullPointerException) {
                    throw new PIHscServerException("07E2", null);
                }
            }
            if (n > n2 || n > n3) {
                System.out.println("ERROR: required cpu is greater than desired or max cpu");
                throw new PIHscServerException("07DD", null);
            }
            if (n2 > n3) {
                System.out.println("ERROR: desiredCPU is greater than maximum cpu");
                throw new PIHscServerException("07DD", null);
            }
            if (l > l2 || l > l3) {
                System.out.println("ERROR: required proc unit is greater than desired or max proc unit");
                throw new PIHscServerException("07DD", null);
            }
            if (l2 > l3) {
                System.out.println("ERROR: desired proc unit is greater than max proc unit");
                throw new PIHscServerException("07DD", null);
            }
            if ((float)l / (float)n > 100.0f || (float)l2 / (float)n2 > 100.0f || (float)l3 / (float)n3 > 100.0f) {
                System.out.println("ERROR: virtual processor has more than 1 whole proc unit");
                throw new PIHscServerException("07DD", null);
            }
            int n5 = 0;
            try {
                n5 = ((UnsignedInt16)cIMInstance.getProperty("MinProcUnit").getValue().getValue()).intValue();
            }
            catch (Throwable throwable) {
                try {
                    HSCLogUtils.serverLog(throwable, HSCLogUtils._LPARClassLogInfo);
                }
                catch (Throwable throwable2) {
                    // empty catch block
                }
                throw new PIHscServerException("2523", new String[]{"R50ComputerSystem.MinProcUnits"}, throwable);
            }
            if (l / (long)n < (long)n5 || l2 / (long)n2 < (long)n5 || l3 / (long)n3 < (long)n5) {
                System.out.println("ERROR: processing unit per virtual processor is less than min processing unit supported");
                throw new PIHscServerException("07DD", null);
            }
            short s3 = s;
            int n6 = 0;
            try {
                n6 = ((UnsignedInt8)cIMInstance.getProperty("MaxProcPools").getValue().getValue()).intValue();
            }
            catch (Throwable throwable) {
                try {
                    HSCLogUtils.serverLog(throwable, HSCLogUtils._LPARClassLogInfo);
                }
                catch (Throwable throwable3) {
                    // empty catch block
                }
                throw new PIHscServerException("2523", new String[]{"R50ComputerSystem.MaxProcPools"}, throwable);
            }
            if (s3 >= n6) {
                System.out.println("ERROR: poolID is greater max pools supported");
                throw new PIHscServerException("07DD", null);
            }
        }
        catch (Throwable throwable) {
            try {
                HSCLogUtils.serverLog(throwable, HSCLogUtils._LPARClassLogInfo);
            }
            catch (Throwable throwable4) {
                // empty catch block
            }
            throwable.printStackTrace();
            if (!(throwable instanceof PIHscServerException)) {
                throw new PIHscServerException("0622", null);
            }
            throw (PIHscServerException)throwable;
        }
        finally {
            Trace.trace("appahscT", "PIResourcesAllocationUtils.checkSharedProcSettings <-");
        }
    }

    public static AllocProcAndLparInfo checkProcForAllocation(FspLparProcessingInfo fspLparProcessingInfo, CIMObjectPath cIMObjectPath, String string, ProviderCIMOMHandle providerCIMOMHandle) throws PIHscServerException {
        return PIResourcesAllocationUtils.checkProcForAllocation(fspLparProcessingInfo, cIMObjectPath, string, providerCIMOMHandle, null);
    }

    public static AllocProcAndLparInfo checkProcForAllocation(FspLparProcessingInfo fspLparProcessingInfo, CIMObjectPath cIMObjectPath, String string, ProviderCIMOMHandle providerCIMOMHandle, Vector vector) throws PIHscServerException {
        Trace.trace("appahscT", "-> PIResourcesAllocationUtils.checkProcForAllocation");
        Trace.trace("appahscF", "procSettings = " + fspLparProcessingInfo);
        Trace.trace("appahscF", "lparPath = " + cIMObjectPath);
        Trace.trace("appahscF", "cecName = " + string);
        Trace.trace("appahscF", "cimHandle = " + providerCIMOMHandle);
        System.out.println("checkProcForAllocation ->");
        CIMObjectPath cIMObjectPath2 = null;
        CIMInstance cIMInstance = null;
        CIMInstance cIMInstance2 = null;
        AllocProcAndLparInfo allocProcAndLparInfo = null;
        String string2 = "";
        int n = -1;
        UnsignedInt16 unsignedInt16 = null;
        int n2 = 0;
        int n3 = 0;
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        boolean bl = false;
        short s = 0;
        boolean bl2 = false;
        boolean bl3 = false;
        short s2 = 0;
        String string3 = cIMObjectPath.getNameSpace();
        AllocProcAndLparInfo allocProcAndLparInfo2 = new AllocProcAndLparInfo();
        try {
            block51: {
                cIMObjectPath2 = PIResourcesAllocationUtils.constructCecPath(string, string3);
                cIMInstance = CimomWrapper.getInstance((CIMOMHandle)providerCIMOMHandle, cIMObjectPath2, providerCIMOMHandle.getClass(cIMObjectPath2, false), false);
                if (3 <= Trace.LEVEL) {
                    Trace.trace("appahscD", "cecInstance =" + cIMInstance);
                }
                System.out.println("checkProcForAllocation -> cecInstance = " + cIMInstance);
                cIMInstance2 = CimomWrapper.getInstance((CIMOMHandle)providerCIMOMHandle, cIMObjectPath, providerCIMOMHandle.getClass(cIMObjectPath, false), false);
                if (3 <= Trace.LEVEL) {
                    Trace.trace("appahscD", "lparInstance =" + cIMInstance2);
                }
                System.out.println("checkProcForAllocation -> lparInstance = " + cIMInstance2);
                try {
                    string2 = (String)cIMInstance2.getProperty("Name").getValue().getValue();
                }
                catch (Throwable throwable) {
                    try {
                        HSCLogUtils.serverLog(throwable, HSCLogUtils._LPARClassLogInfo);
                    }
                    catch (Throwable throwable2) {
                        // empty catch block
                    }
                    throw new PIHscServerException("2523", new String[]{"R50Partition.Name"}, throwable);
                }
                n = Integer.parseInt(string2.substring(0, string2.indexOf(42)));
                unsignedInt16 = new UnsignedInt16(n);
                try {
                    n2 = fspLparProcessingInfo.getMinProcs().intValue();
                    n3 = fspLparProcessingInfo.getAllocProcs().intValue();
                    s = fspLparProcessingInfo.getProcType().shortValue();
                    s2 = fspLparProcessingInfo.getSharingMode().shortValue();
                }
                catch (NullPointerException nullPointerException) {
                    try {
                        HSCLogUtils.serverLog(nullPointerException, HSCLogUtils._LPARClassLogInfo);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    throw new PIHscServerException("07E2", null);
                }
                int n4 = 0;
                try {
                    ((UnsignedInt8)cIMInstance2.getProperty("DefinitionState").getValue().getValue()).intValue();
                }
                catch (Throwable throwable) {
                    try {
                        HSCLogUtils.serverLog(throwable, HSCLogUtils._LPARClassLogInfo);
                    }
                    catch (Throwable throwable3) {
                        // empty catch block
                    }
                    throw new PIHscServerException("2523", new String[]{"R50Partition.DefinitionState"}, throwable);
                }
                int n5 = 1;
                boolean bl4 = false;
                if (s == 255) {
                    block50: {
                        System.out.println("checkProcForAllocation -> checkDedicatedProcForAlloc");
                        try {
                            allocProcAndLparInfo = PIResourcesAllocationUtils.checkProcsForAlloc(cIMInstance2, s, cIMInstance, n4, (long)n3 * 100L, providerCIMOMHandle, string3, s2, (long)n2 * 100L, n3, n2, n5, bl4, vector);
                        }
                        catch (Throwable throwable) {
                            try {
                                HSCLogUtils.serverLog(throwable, HSCLogUtils._LPARClassLogInfo);
                            }
                            catch (Throwable throwable4) {
                                // empty catch block
                            }
                            throwable.printStackTrace();
                            HSCLogUtils.serverLog(throwable, HSCLogUtils._PartActClassLogInfo);
                            if (!(throwable instanceof PIHscServerException)) break block50;
                            throw (PIHscServerException)throwable;
                        }
                    }
                    if (null == allocProcAndLparInfo) {
                        System.out.println("ERROR: Insufficient processor to activate");
                        throw new PIHscServerException("03EA", new String[]{"0", Integer.toString(n2)}, null);
                    }
                    if (3 <= Trace.LEVEL) {
                        Trace.trace("appahscD", "allocatedCPUInfo = " + allocProcAndLparInfo);
                    }
                    int n6 = allocProcAndLparInfo.allocatedProc.intValue();
                    System.out.println("WLM: obtained and required: " + n6 + " ; " + n2);
                    if (n6 < n2) {
                        System.out.println("ERROR: Insufficient processors to activate");
                        throw new PIHscServerException("03EA", new String[]{Integer.toString(n6), Integer.toString(n2)}, null);
                    }
                    AllocProcAndLparInfo allocProcAndLparInfo3 = allocProcAndLparInfo;
                    return allocProcAndLparInfo3;
                }
                try {
                    l = fspLparProcessingInfo.getMinProcUnits().longValue();
                    l2 = fspLparProcessingInfo.getAllocProcUnits().longValue();
                    l3 = fspLparProcessingInfo.getMaxProcUnits().longValue();
                }
                catch (NullPointerException nullPointerException) {
                    try {
                        HSCLogUtils.serverLog(nullPointerException, HSCLogUtils._LPARClassLogInfo);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    throw new PIHscServerException("07E2", null);
                }
                try {
                    allocProcAndLparInfo = PIResourcesAllocationUtils.checkProcsForAlloc(cIMInstance2, s, cIMInstance, n4, l2, providerCIMOMHandle, string3, s2, l, n3, n2, n5, bl4, vector);
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                    HSCLogUtils.serverLog(throwable, HSCLogUtils._PartActClassLogInfo);
                    if (!(throwable instanceof PIHscServerException)) break block51;
                    throw (PIHscServerException)throwable;
                }
            }
            if (null == allocProcAndLparInfo) {
                System.out.println("ERROR: Insufficient processing units for activation");
                throw new PIHscServerException("03F5", new String[]{Integer.toString(0), Integer.toString(0), Integer.toString(n2), Double.toString((double)l / 100.0)}, null);
            }
            if (3 <= Trace.LEVEL) {
                Trace.trace("appahscD", "allocatedCPUInfo =" + allocProcAndLparInfo);
            }
            long l4 = allocProcAndLparInfo.allocatedProcUnits.longValue();
            System.out.println("accumProcUnits = " + l4);
            if (l4 < l) {
                System.out.println("ERROR: not enough processing units to satisfy minimum configuration");
                throw new PIHscServerException("03F5", new String[]{Integer.toString(n2), Double.toString((double)l4 / 100.0), Integer.toString(n2), Double.toString((double)l / 100.0)}, null);
            }
            int n7 = 0;
            try {
                n7 = ((UnsignedInt16)cIMInstance.getProperty("MinProcUnit").getValue().getValue()).intValue();
            }
            catch (Throwable throwable) {
                try {
                    HSCLogUtils.serverLog(throwable, HSCLogUtils._LPARClassLogInfo);
                }
                catch (Throwable throwable5) {
                    // empty catch block
                }
                throw new PIHscServerException("2523", new String[]{"R50ComputerSystem.MinProcUnits"}, throwable);
            }
            if (l4 / (long)n3 < (long)n7) {
                long l5 = l4 / 100L;
                if (l4 % 100L != 0L) {
                    ++l5;
                }
                long l6 = l4 / (long)n7;
                if (l5 < (long)n2) {
                    l5 = n2;
                }
                if (l6 < (long)n2) {
                    System.out.println("ERROR: cannot find a correct virtual processor boundry");
                    throw new PIHscServerException("03F5", new String[]{Long.toString(l6), Double.toString((double)l4 / 100.0), Integer.toString(n2), Double.toString((double)l / 100.0)}, null);
                }
                allocProcAndLparInfo.allocatedProc = new UnsignedInt16((int)l6);
                AllocProcAndLparInfo allocProcAndLparInfo4 = allocProcAndLparInfo;
                return allocProcAndLparInfo4;
            }
            AllocProcAndLparInfo allocProcAndLparInfo5 = allocProcAndLparInfo;
            return allocProcAndLparInfo5;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            try {
                HSCLogUtils.serverLog(throwable, HSCLogUtils._LPARClassLogInfo);
            }
            catch (Throwable throwable6) {
                // empty catch block
            }
            if (!(throwable instanceof PIHscServerException)) {
                throw new PIHscServerException("03F4", null);
            }
            throw (PIHscServerException)throwable;
        }
        finally {
            if (1 <= Trace.LEVEL) {
                Trace.trace("appahscT", "<- checkProcForAllocation");
            }
        }
    }

    public static ProcessorTable getLparProcInfo(int n, String string, int n2, ProviderCIMOMHandle providerCIMOMHandle, int n3) throws PIHscServerException {
        return PIResourcesAllocationUtils.getLparProcInfo(n, string, n2, providerCIMOMHandle, "root/ibmhscS1_0", n3);
    }

    public static ProcessorTable getLparProcInfo(int n, String string, int n2, ProviderCIMOMHandle providerCIMOMHandle, String string2, int n3) throws PIHscServerException {
        return PIResourcesAllocationUtils.getLparProcInfo(n, string, n2, providerCIMOMHandle, string2, n3, null);
    }

    public static ProcessorTable getLparProcInfo(int n, String string, int n2, ProviderCIMOMHandle providerCIMOMHandle, String string2, int n3, Vector vector) throws PIHscServerException {
        return PIResourcesAllocationUtils.getLparProcInfo(n, string, n2, providerCIMOMHandle, string2, n3, 65535, false, vector);
    }

    public static ProcessorTable getLparProcInfo(int n, String string, int n2, ProviderCIMOMHandle providerCIMOMHandle, String string2, int n3, int n4, boolean bl, Vector vector) throws PIHscServerException {
        Trace.trace("appahscT", "-> PIResourcesAllocationUtils.getLparProcInfo");
        Trace.trace("appahscF", "actLparID = " + n);
        Trace.trace("appahscF", "cecName = " + string);
        Trace.trace("appahscF", "procMode = " + n2);
        Trace.trace("appahscF", "cimHandle = " + providerCIMOMHandle);
        Trace.trace("appahscF", "namespace = " + string2);
        ProcessorTable processorTable = new ProcessorTable();
        long l = 0L;
        Vector vector2 = new Vector();
        Vector<LparProcValuePair> vector3 = new Vector<LparProcValuePair>();
        Object var14_13 = null;
        CIMObjectPath cIMObjectPath = PIResourcesAllocationUtils.constructCecPath(string, string2);
        Vector vector4 = null;
        try {
            vector4 = PIHmcAccessUtils.getLparObjWithAuthFromCec(cIMObjectPath, "ActivateLparProfile", providerCIMOMHandle, false);
        }
        catch (Throwable throwable) {
            try {
                HSCLogUtils.serverLog(throwable, HSCLogUtils._LPARClassLogInfo);
            }
            catch (Throwable throwable2) {
                // empty catch block
            }
            vector4 = null;
        }
        if (null != vector4 && vector4.size() != 0) {
            if (3 <= Trace.LEVEL) {
                Trace.trace("appahscD", "lpars =" + vector4);
            }
            Enumeration enumeration = vector4.elements();
            processorTable.lparProcTypes = new Hashtable();
            while (enumeration.hasMoreElements()) {
                Object object;
                CIMInstance cIMInstance = (CIMInstance)enumeration.nextElement();
                int[] nArray = null;
                try {
                    object = new CIMObjectPath("IBMHSC_Partition", string2);
                    object.setKeys(cIMInstance.getKeyValuePairs());
                    nArray = PIClusterModifier.getLparClusterInfo((CIMOMHandle)providerCIMOMHandle, (CIMObjectPath)object);
                    System.out.println("wlmInfo = " + nArray);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                if (nArray == null && PIClusterModifier.isUserDefinedCluster(n3) || !PIClusterModifier.inSameCluster((int)nArray[0], n3)) continue;
                object = "";
                try {
                    object = (String)cIMInstance.getProperty("Name").getValue().getValue();
                }
                catch (Throwable throwable) {
                    try {
                        HSCLogUtils.serverLog(throwable, HSCLogUtils._LPARClassLogInfo);
                    }
                    catch (Throwable throwable3) {
                        // empty catch block
                    }
                    throw new PIHscServerException("2523", new String[]{"R50Partition.Name"}, throwable);
                }
                int n5 = Integer.parseInt(((String)object).substring(0, ((String)object).indexOf("*")));
                if (n5 == n) continue;
                int n6 = 0;
                try {
                    n6 = ((UnsignedInt8)cIMInstance.getProperty("DefinitionState").getValue().getValue()).intValue();
                }
                catch (Throwable throwable) {
                    try {
                        HSCLogUtils.serverLog(throwable, HSCLogUtils._LPARClassLogInfo);
                    }
                    catch (Throwable throwable4) {
                        // empty catch block
                    }
                    throw new PIHscServerException("2523", new String[]{"R50Partition.DefinitionState"}, throwable);
                }
                if ((n6 == 1 || n6 == 2) && (n4 & 1) == 0 || (n6 == 65 || n6 == 66) && (n4 & 2) == 0 || (n6 == 129 || n6 == 130) && (n4 & 4) == 0 || (n6 == 3 || n6 == 4) && (n4 & 8) == 0) continue;
                CIMValue cIMValue = cIMInstance.getProperty("PendProcMode").getValue();
                boolean bl2 = false;
                int n7 = 0;
                if (null == cIMValue) {
                    bl2 = true;
                } else {
                    n7 = ((UnsignedInt8)cIMValue.getValue()).intValue();
                }
                if (bl2) continue;
                processorTable.lparProcTypes.put(new UnsignedInt16(n5), cIMValue.getValue());
                if (vector != null && vector.size() > 0 && vector.contains(new UnsignedInt16(n5))) continue;
                int n8 = 0;
                try {
                    n8 = ((UnsignedInt8)cIMInstance.getProperty("PartitionState").getValue().getValue()).intValue();
                }
                catch (Throwable throwable) {
                    try {
                        HSCLogUtils.serverLog(throwable, HSCLogUtils._LPARClassLogInfo);
                    }
                    catch (Throwable throwable5) {
                        // empty catch block
                    }
                    throw new PIHscServerException("2523", new String[]{"R50Partition.PartitionState"}, throwable);
                }
                if (0 != n8) continue;
                LparProcValuePair lparProcValuePair = new LparProcValuePair();
                lparProcValuePair.lparID = n5;
                if (255 == n7) {
                    try {
                        long l2 = 0L;
                        try {
                            l2 = ((UnsignedInt16)cIMInstance.getProperty("CurAllocProcs").getValue().getValue()).intValue() * 100;
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        lparProcValuePair.procAmount = ((UnsignedInt16)cIMInstance.getProperty("PendAllocProcs").getValue().getValue()).intValue() * 100;
                        try {
                            lparProcValuePair.minProcAmount = ((UnsignedInt16)cIMInstance.getProperty("PendMinProcs").getValue().getValue()).intValue() * 100;
                        }
                        catch (Throwable throwable) {
                            lparProcValuePair.minProcAmount = 0L;
                        }
                    }
                    catch (Throwable throwable) {
                        throw new PIHscServerException("2523", new String[]{"R50Partition.PendAllocProcs"}, throwable);
                    }
                } else if (bl && (n6 == 129 || n6 == 130)) {
                    short s = 0;
                    try {
                        CIMValue cIMValue2 = cIMInstance.getProperty("PendSharingMode").getValue();
                        s = ((UnsignedInt8)cIMValue2.getValue()).shortValue();
                    }
                    catch (Throwable throwable) {
                        try {
                            HSCLogUtils.serverLog(throwable, HSCLogUtils._LPARClassLogInfo);
                        }
                        catch (Throwable throwable6) {
                            // empty catch block
                        }
                        throw new PIHscServerException("2523", new String[]{"R50Partition.PendSharingMode"}, throwable);
                    }
                    if (s == 1) {
                        try {
                            lparProcValuePair.procAmount = ((UnsignedInt16)cIMInstance.getProperty("PendAllocProcs").getValue().getValue()).intValue() * 100;
                            try {
                                lparProcValuePair.minProcAmount = ((UnsignedInt16)cIMInstance.getProperty("PendMinProcs").getValue().getValue()).intValue() * 100;
                            }
                            catch (Throwable throwable) {
                                lparProcValuePair.minProcAmount = 0L;
                            }
                        }
                        catch (Throwable throwable) {
                            throw new PIHscServerException("2523", new String[]{"R50Partition.PendAllocProcs"}, throwable);
                        }
                    } else {
                        try {
                            lparProcValuePair.procAmount = ((UnsignedInt32)cIMInstance.getProperty("PendAllocProcUnits").getValue().getValue()).longValue();
                            try {
                                lparProcValuePair.minProcAmount = ((UnsignedInt32)cIMInstance.getProperty("PendMinProcUnits").getValue().getValue()).longValue();
                            }
                            catch (Throwable throwable) {
                                lparProcValuePair.minProcAmount = 0L;
                            }
                        }
                        catch (Throwable throwable) {
                            throw new PIHscServerException("2523", new String[]{"R50Partition.PendAllocProcUnits"}, throwable);
                        }
                    }
                } else {
                    try {
                        long l3 = 0L;
                        try {
                            l3 = ((UnsignedInt32)cIMInstance.getProperty("CurAllocProcUnits").getValue().getValue()).longValue();
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        lparProcValuePair.procAmount = ((UnsignedInt32)cIMInstance.getProperty("PendAllocProcUnits").getValue().getValue()).longValue();
                        try {
                            lparProcValuePair.minProcAmount = ((UnsignedInt32)cIMInstance.getProperty("PendMinProcUnits").getValue().getValue()).longValue();
                        }
                        catch (Throwable throwable) {
                            lparProcValuePair.minProcAmount = 0L;
                        }
                    }
                    catch (Throwable throwable) {
                        throw new PIHscServerException("2523", new String[]{"R50Partition.PendAllocProcUnits"}, throwable);
                    }
                }
                vector3.add(lparProcValuePair);
            }
        }
        processorTable.procUnitsForNotBootableLpar = new UnsignedInt32(l);
        if (vector2 != null) {
            if (3 <= Trace.LEVEL) {
                Trace.trace("appahscD", "notBootableLpars =" + vector2);
            }
            processorTable.notBootableLpars = vector2.toArray(new UnsignedInt16[vector2.size()]);
        }
        if (vector3 != null) {
            if (3 <= Trace.LEVEL) {
                Trace.trace("appahscD", "lparProcValPairs =" + vector3);
            }
            processorTable.lparProcValPairs = vector3.toArray(new LparProcValuePair[vector3.size()]);
        }
        Trace.trace("appahscT", "PIResourcesAllocationUtils. getLparProcInfo <-");
        return processorTable;
    }

    public static ProcessorTable getI5OSLparProcInfo(boolean bl, int n, String string, int n2, ProviderCIMOMHandle providerCIMOMHandle, String string2) throws PIHscServerException {
        Trace.trace("appahscT", "-> PIResourcesAllocationUtils.getI5OSLparProcInfo");
        Trace.trace("appahscF", "running = " + bl);
        Trace.trace("appahscF", "actLparID = " + n);
        Trace.trace("appahscF", "cecName = " + string);
        Trace.trace("appahscF", "procMode = " + n2);
        Trace.trace("appahscF", "cimHandle = " + providerCIMOMHandle);
        Trace.trace("appahscF", "namespace = " + string2);
        ProcessorTable processorTable = new ProcessorTable();
        Vector<LparProcValuePair> vector = new Vector<LparProcValuePair>();
        CIMObjectPath cIMObjectPath = PIResourcesAllocationUtils.constructCecPath(string, string2);
        Vector vector2 = null;
        if (bl) {
            try {
                vector2 = CimomWrapper.associators((CIMOMHandle)providerCIMOMHandle, new CIMObjectPath("IBMHSC_CompSysPartition", string2), cIMObjectPath, "IBMHSC_Partition", "GroupComponent", "PartComponent", false, false, null);
            }
            catch (Throwable throwable) {
                try {
                    HSCLogUtils.serverLog(throwable, HSCLogUtils._LPARClassLogInfo);
                }
                catch (Throwable throwable2) {
                    // empty catch block
                }
                vector2 = null;
            }
        } else {
            try {
                vector2 = PIHmcAccessUtils.getLparObjWithAuthFromCec(cIMObjectPath, "ActivateLparProfile", providerCIMOMHandle, false);
            }
            catch (Throwable throwable) {
                try {
                    HSCLogUtils.serverLog(throwable, HSCLogUtils._LPARClassLogInfo);
                }
                catch (Throwable throwable3) {
                    // empty catch block
                }
                vector2 = null;
            }
        }
        if (null != vector2 && vector2.size() != 0) {
            if (3 <= Trace.LEVEL) {
                Trace.trace("appahscD", "lpars =" + vector2);
            }
            Enumeration enumeration = vector2.elements();
            processorTable.lparProcTypes = new Hashtable();
            while (enumeration.hasMoreElements()) {
                CIMInstance cIMInstance = (CIMInstance)enumeration.nextElement();
                String string3 = "";
                try {
                    string3 = (String)cIMInstance.getProperty("Name").getValue().getValue();
                }
                catch (Throwable throwable) {
                    try {
                        HSCLogUtils.serverLog(throwable, HSCLogUtils._LPARClassLogInfo);
                    }
                    catch (Throwable throwable4) {
                        // empty catch block
                    }
                    throw new PIHscServerException("2523", new String[]{"R50Partition.Name"}, throwable);
                }
                int n3 = Integer.parseInt(string3.substring(0, string3.indexOf("*")));
                if (n3 == n) continue;
                int n4 = 0;
                try {
                    n4 = ((UnsignedInt8)cIMInstance.getProperty("DefinitionState").getValue().getValue()).intValue();
                }
                catch (Throwable throwable) {
                    try {
                        HSCLogUtils.serverLog(throwable, HSCLogUtils._LPARClassLogInfo);
                    }
                    catch (Throwable throwable5) {
                        // empty catch block
                    }
                    throw new PIHscServerException("2523", new String[]{"R50Partition.DefinitionState"}, throwable);
                }
                if (n4 != 130 && n4 != 129) continue;
                int n5 = 0;
                CIMValue cIMValue = null;
                try {
                    cIMValue = cIMInstance.getProperty("PendProcMode").getValue();
                    n5 = ((UnsignedInt8)cIMValue.getValue()).intValue();
                }
                catch (Throwable throwable) {
                    try {
                        HSCLogUtils.serverLog(throwable, HSCLogUtils._LPARClassLogInfo);
                    }
                    catch (Throwable throwable6) {
                        // empty catch block
                    }
                    throw new PIHscServerException("2523", new String[]{"R50Partition.PendProcMode"}, throwable);
                }
                processorTable.lparProcTypes.put(new UnsignedInt16(n3), cIMValue.getValue());
                int n6 = 0;
                try {
                    n6 = ((UnsignedInt8)cIMInstance.getProperty("PartitionState").getValue().getValue()).intValue();
                }
                catch (Throwable throwable) {
                    try {
                        HSCLogUtils.serverLog(throwable, HSCLogUtils._LPARClassLogInfo);
                    }
                    catch (Throwable throwable7) {
                        // empty catch block
                    }
                    throw new PIHscServerException("2523", new String[]{"R50Partition.PartitionState"}, throwable);
                }
                if (bl ? 0 == n6 : 0 != n6) continue;
                LparProcValuePair lparProcValuePair = new LparProcValuePair();
                lparProcValuePair.lparID = n3;
                lparProcValuePair.ignoreVirProc = false;
                if (255 == n5) {
                    try {
                        lparProcValuePair.procAmount = ((UnsignedInt16)cIMInstance.getProperty("PendAllocProcs").getValue().getValue()).intValue() * 100;
                        try {
                            lparProcValuePair.minProcAmount = ((UnsignedInt16)cIMInstance.getProperty("PendMinProcs").getValue().getValue()).intValue() * 100;
                        }
                        catch (Throwable throwable) {
                            lparProcValuePair.minProcAmount = 0L;
                        }
                    }
                    catch (Throwable throwable) {
                        throw new PIHscServerException("2523", new String[]{"R50Partition.PendAllocProcs"}, throwable);
                    }
                } else {
                    short s = 0;
                    try {
                        CIMValue cIMValue2 = cIMInstance.getProperty("PendSharingMode").getValue();
                        s = ((UnsignedInt8)cIMValue2.getValue()).shortValue();
                    }
                    catch (Throwable throwable) {
                        try {
                            HSCLogUtils.serverLog(throwable, HSCLogUtils._LPARClassLogInfo);
                        }
                        catch (Throwable throwable8) {
                            // empty catch block
                        }
                        throw new PIHscServerException("2523", new String[]{"R50Partition.PendSharingMode"}, throwable);
                    }
                    if (s == 1) {
                        try {
                            lparProcValuePair.procAmount = ((UnsignedInt16)cIMInstance.getProperty("PendAllocProcs").getValue().getValue()).intValue() * 100;
                            try {
                                lparProcValuePair.minProcAmount = ((UnsignedInt16)cIMInstance.getProperty("PendMinProcs").getValue().getValue()).intValue() * 100;
                            }
                            catch (Throwable throwable) {
                                lparProcValuePair.minProcAmount = 0L;
                            }
                        }
                        catch (Throwable throwable) {
                            throw new PIHscServerException("2523", new String[]{"R50Partition.PendAllocProcs"}, throwable);
                        }
                    } else {
                        try {
                            lparProcValuePair.procAmount = ((UnsignedInt32)cIMInstance.getProperty("PendAllocProcUnits").getValue().getValue()).longValue();
                            try {
                                lparProcValuePair.minProcAmount = ((UnsignedInt32)cIMInstance.getProperty("PendMinProcUnits").getValue().getValue()).longValue();
                            }
                            catch (Throwable throwable) {
                                lparProcValuePair.minProcAmount = 0L;
                            }
                        }
                        catch (Throwable throwable) {
                            throw new PIHscServerException("2523", new String[]{"R50Partition.PendAllocProcUnits"}, throwable);
                        }
                    }
                }
                vector.add(lparProcValuePair);
            }
        }
        if (vector != null) {
            if (3 <= Trace.LEVEL) {
                Trace.trace("appahscD", "lparProcValPairs =" + vector);
            }
            processorTable.lparProcValPairs = vector.toArray(new LparProcValuePair[vector.size()]);
        }
        Trace.trace("appahscT", "PIResourcesAllocationUtils. getRunningI5OSLparProcInfo <-");
        return processorTable;
    }

    public static AllocProcAndLparInfo checkProcsForAlloc(CIMInstance cIMInstance, int n, CIMInstance cIMInstance2, int n2, long l, ProviderCIMOMHandle providerCIMOMHandle, String string) throws PIHscServerException {
        return PIResourcesAllocationUtils.checkProcsForAlloc(cIMInstance, n, cIMInstance2, n2, l, providerCIMOMHandle, string, null);
    }

    public static AllocProcAndLparInfo checkProcsForAlloc(CIMInstance cIMInstance, int n, CIMInstance cIMInstance2, int n2, long l, ProviderCIMOMHandle providerCIMOMHandle, String string, Vector vector) throws PIHscServerException {
        return PIResourcesAllocationUtils.checkProcsForAlloc(cIMInstance, n, cIMInstance2, n2, l, providerCIMOMHandle, string, 0, 0L, 0, 0, 0, false, vector);
    }

    public static AllocProcAndLparInfo checkI5OSProcsForAlloc(CIMInstance cIMInstance, CIMObjectPath cIMObjectPath, int n, int n2, boolean bl, CIMInstance cIMInstance2, int n3, int n4, int n5, long l, long l2, long l3, ProviderCIMOMHandle providerCIMOMHandle, String string, int n6) throws PIHscServerException {
        return PIResourcesAllocationUtils.checkI5OSProcsForAlloc(cIMInstance, cIMObjectPath, n, n2, bl, cIMInstance2, n3, n4, n5, l, l2, l3, providerCIMOMHandle, string, n6, null);
    }

    public static AllocProcAndLparInfo checkI5OSProcsForAlloc(CIMInstance cIMInstance, CIMObjectPath cIMObjectPath, int n, int n2, boolean bl, CIMInstance cIMInstance2, int n3, int n4, int n5, long l, long l2, long l3, ProviderCIMOMHandle providerCIMOMHandle, String string, int n6, Vector vector) throws PIHscServerException {
        CIMValue cIMValue;
        AllocProcAndLparInfo allocProcAndLparInfo = new AllocProcAndLparInfo();
        AllocProcAndLparInfo allocProcAndLparInfo2 = new AllocProcAndLparInfo();
        ProcessorTable processorTable = PIResourcesAllocationUtils.getI5OSCPUInfo(bl, cIMInstance, n, cIMInstance2, providerCIMOMHandle, string, vector);
        System.out.println("i5OSProcInfo = " + processorTable);
        System.out.println("numVirProcsDesired = " + n4);
        System.out.println("numVirProcsRequired = " + n5);
        System.out.println("numProcUnitsDesired = " + l);
        System.out.println("numProcUnitsRequired = " + l2);
        int n7 = 0;
        long l4 = 0L;
        long l5 = 0L;
        int n8 = 0;
        long l6 = 0L;
        int n9 = 0;
        long l7 = l2;
        long l8 = l;
        int n10 = n5;
        int n11 = n4;
        String string2 = "";
        int n12 = 0;
        long l9 = 0L;
        int n13 = 255;
        int n14 = 0;
        try {
            l9 = ((UnsignedInt32)cIMInstance2.getProperty("PendAvailProcUnits").getValue().getValue()).longValue();
        }
        catch (Throwable throwable) {
            throw new PIHscServerException("2523", new String[]{"R50ComputerSystem.PendAvailProcUnits"}, throwable);
        }
        try {
            string2 = (String)cIMInstance.getProperty("Name").getValue().getValue();
        }
        catch (Throwable throwable) {
            try {
                HSCLogUtils.serverLog(throwable, HSCLogUtils._LPARClassLogInfo);
            }
            catch (Throwable throwable2) {
                // empty catch block
            }
            throw new PIHscServerException("2523", new String[]{"R50Partition.Name"}, throwable);
        }
        try {
            n13 = ((UnsignedInt8)cIMInstance.getProperty("PendProcMode").getValue().getValue()).intValue();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        try {
            n14 = ((UnsignedInt8)cIMInstance.getProperty("PendSharingMode").getValue().getValue()).intValue();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        OmCecMgr omCecMgr = null;
        omCecMgr = OmCecMgr.getCecMgr(string2.substring(string2.indexOf(42) + 1));
        n12 = Integer.parseInt(string2.substring(0, string2.indexOf(42)));
        int n15 = 65535;
        Object var45_41 = null;
        try {
            PIClusterModifier.getLparClusterInfo((CIMOMHandle)providerCIMOMHandle, cIMObjectPath);
        }
        catch (Throwable throwable) {
            var45_41 = null;
        }
        n15 = var45_41 == null || !PIClusterModifier.isUserDefinedCluster((int)var45_41[0]) ? 65535 : var45_41[0];
        int n16 = 0;
        long l10 = 0L;
        long l11 = 0L;
        if (processorTable != null) {
            if (processorTable.unavailI5OSVirProcs != null) {
                n16 = processorTable.unavailI5OSVirProcs.intValue();
            }
            if (processorTable.unavailI5OSProcUnits != null) {
                l10 = processorTable.unavailI5OSProcUnits.longValue();
            }
            if (processorTable.uncappedUnavailI5OSProcUnits != null) {
                l11 = processorTable.uncappedUnavailI5OSProcUnits.longValue();
            }
        }
        long l12 = 0L;
        if (255 == n13) {
            cIMValue = cIMInstance.getProperty("PendAllocProcs").getValue();
            if (cIMValue != null) {
                l12 = ((UnsignedInt16)cIMValue.getValue()).intValue() * 100;
            }
        } else {
            cIMValue = cIMInstance.getProperty("PendAllocProcUnits").getValue();
            if (cIMValue != null) {
                l12 = ((UnsignedInt32)cIMValue.getValue()).longValue();
            }
        }
        int n17 = (int)l3 / 100 - n16;
        System.out.println("totalAvailableI5OSVirProcs = " + n17);
        if (n17 <= 0) {
            n17 = 0;
        }
        allocProcAndLparInfo.updatedDesiredProcUnits = l;
        long l13 = l3 - (l10 + (long)(n16 * 100) - l11);
        System.out.println("totalAvailableI5OSProcUnits  = " + l13);
        if (l13 < 0L) {
            l13 = 0L;
        } else if (l13 < l && l13 >= l2) {
            allocProcAndLparInfo.updatedDesiredProcUnits = l = l13;
        }
        if (l2 > l13 || n != 255 && n2 == 1 && n5 > n17) {
            System.out.println("ERROR: Insufficient i5/OS processors to activate");
            if ((n6 & 2) != 0 || (n6 & 4) != 0 || (n6 & 8) != 0 || (n6 & 0x10) != 0) {
                allocProcAndLparInfo2 = new AllocProcAndLparInfo();
                allocProcAndLparInfo2.i5OSCapacityCheckingFailed = true;
                allocProcAndLparInfo2.updatedDesiredProcUnits = l;
                allocProcAndLparInfo2.allocatedProc = n == 255 ? new UnsignedInt16(n4) : (n != 255 && n2 == 0 ? new UnsignedInt16(n4) : new UnsignedInt16(n17));
                allocProcAndLparInfo2.allocatedProcUnits = new UnsignedInt32(l13);
                return allocProcAndLparInfo2;
            }
            if (255 == n) {
                throw new PIHscServerException("0403", new String[]{Integer.toString((int)l13 / 100), Integer.toString((int)l2 / 100)}, null);
            }
            if (n2 == 1) {
                long l14;
                int n18 = n4;
                if (n18 > n17) {
                    n18 = n17;
                }
                if ((l14 = l) > l13) {
                    l14 = l13;
                }
                throw new PIHscServerException("0404", new String[]{Integer.toString(n18), Integer.toString(n5), Double.toString((double)l14 / 100.0), Double.toString((double)l2 / 100.0)}, null);
            }
            throw new PIHscServerException("0404", new String[]{Integer.toString(n5), Integer.toString(n5), Double.toString((double)l13 / 100.0), Double.toString((double)l2 / 100.0)}, null);
        }
        int n19 = 0;
        long l15 = 0L;
        long l16 = 0L;
        if (processorTable != null) {
            if (processorTable.allocI5OSVirProcs != null) {
                n19 = processorTable.allocI5OSVirProcs.intValue();
            }
            if (processorTable.allocI5OSProcUnits != null) {
                l15 = processorTable.allocI5OSProcUnits.longValue();
            }
            if (processorTable.allocI5OSProcUnits != null) {
                l16 = processorTable.uncappedAllocI5OSProcUnits.longValue();
            }
        }
        if (l13 < l && l13 >= l2) {
            l = l13;
        }
        if (n17 < n4 && n17 >= n5 && n != 255 && n2 == 1) {
            n4 = n17;
        }
        long l17 = l13 - l15;
        int n20 = n17 - n19;
        if (n == 255) {
            n8 = n20 > (int)(l / 100L) ? (int)l / 100 : n20;
        } else if (n2 == 0) {
            int n21 = (int)(l / 100L);
            int n22 = (int)(l % 100L);
            if (n22 != 0) {
                ++n21;
            }
            n8 = n20 > n21 ? n21 : n20;
        } else {
            n8 = n20 > n4 ? n4 : n20;
        }
        long l18 = l17 - l12;
        System.out.println("possibleFreeI5OSProcUnits = " + l18);
        boolean bl2 = false;
        if (l9 < l18) {
            l5 = l9;
            bl2 = true;
        } else {
            l5 = l18;
        }
        if (l5 > l) {
            l5 = l;
        }
        System.out.println("accumI5OSProcUnits = " + l5);
        l6 = l - l5 - l12;
        if (n == 255 || n != 255 && n2 == 0) {
            n9 = (int)(l / 100L);
            long l19 = l % 100L;
            if (l19 != 0L) {
                ++n9;
            }
            n9 -= n20;
        } else {
            n9 = n4 - n20;
        }
        System.out.println("Ann-> in checkProcsForAlloc method -> pSeries i5/OS lpar path -> notAvailableI5OSVirProcs = " + n16);
        System.out.println("Ann-> in checkProcsForAlloc method -> pSeries i5/OS lpar path -> notAvailableI5OSProcUnits = " + l10);
        System.out.println("Ann-> in checkProcsForAlloc method -> pSeries i5/OS lpar path -> totalAvailableI5OSVirProcs = " + n17);
        System.out.println("Ann-> in checkProcsForAlloc method -> pSeries i5/OS lpar path -> totalAvailableI5OSProcUnits = " + l13);
        System.out.println("Ann-> in checkProcsForAlloc method -> pSeries i5/OS lpar path -> allocatedI5OSVirProcs = " + n19);
        System.out.println("Ann-> in checkProcsForAlloc method -> pSeries i5/OS lpar path -> allocatedI5OSProcUnits = " + l15);
        System.out.println("Ann-> in checkProcsForAlloc method -> pSeries i5/OS lpar path -> availableI5OSVirProcsWithoutSteal = " + n20);
        System.out.println("Ann-> in checkProcsForAlloc method -> pSeries i5/OS lpar path -> availableI5OSProcUnitsWithoutSteal = " + l17);
        System.out.println("Ann-> in checkProcsForAlloc method -> pSeries i5/OS lpar path -> missingI5OSVirProcs = " + n9);
        System.out.println("Ann-> in checkProcsForAlloc method -> pSeries i5/OS lpar path -> missingI5OSProcUnits = " + l6);
        System.out.println("Ann-> in checkProcsForAlloc method -> pSeries i5/OS lpar path -> accumI5OSProcUnits = " + l5);
        System.out.println("Ann-> in checkProcsForAlloc method -> pSeries i5/OS lpar path -> accumI5OSVirProcs = " + n8);
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        long l20 = 0L;
        boolean bl6 = false;
        long l21 = 0L;
        if (n != 255 && n2 == 1 && l5 < (long)(n4 * 100)) {
            bl6 = true;
            l21 = n4 * 100;
            System.out.println("procUnitsNeededForUncapped = " + (l21 -= l17));
        }
        if (n9 > 0) {
            int n23 = 0;
            long l22 = 0L;
            try {
                n23 = processorTable.virProcsForNotBootableLpar.intValue();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                l22 = processorTable.procUnitsForNotBootableLpar.longValue();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            System.out.println("Ann-> in checkProcsForAlloc method -> virProcsForNotBootableI5OSLpars = " + n23);
            if (n23 > 0) {
                n8 += n23;
                System.out.println("checkProcsForAlloc -> Finished checking not bootable lpars -> missingI5OSVirProcs = " + (n9 -= n23));
                l6 -= l22;
                l5 += l22;
                l21 -= (long)(n23 * 100);
                bl3 = true;
                if (processorTable != null) {
                    allocProcAndLparInfo.lparIDs = processorTable.notBootableLpars;
                    allocProcAndLparInfo.lparProcTypes = processorTable.lparProcTypes;
                }
            }
            if (n9 > 0) {
                int n24;
                System.out.println("checkProcsForAlloc -> checkProcsToSteal (i5/OS, 1st round)");
                if (3 <= Trace.LEVEL) {
                    Trace.trace("appahscD", "accumI5OSVirProcs =" + n8);
                }
                AllocProcAndLparInfo allocProcAndLparInfo3 = null;
                allocProcAndLparInfo3 = PIResourcesAllocationUtils.checkVirProcsToSteal(n12, n9, n, processorTable.uncappedI5OSLparProcValPairsWithNoCluster, providerCIMOMHandle, false);
                if (null != allocProcAndLparInfo3) {
                    allocProcAndLparInfo3.lparProcTypes = processorTable.lparProcTypes;
                    n24 = 0;
                    long l23 = 0L;
                    try {
                        n24 = allocProcAndLparInfo3.allocatedProc.intValue();
                    }
                    catch (Throwable throwable) {
                        n24 = 0;
                    }
                    try {
                        l23 = allocProcAndLparInfo3.allocatedProcUnits.longValue();
                    }
                    catch (Throwable throwable) {
                        l23 = 0L;
                    }
                    n8 += n24;
                    n9 -= n24;
                    l5 += l23;
                    l6 -= l23;
                    l20 += l23;
                    l21 -= (long)(n24 * 100);
                }
                if (3 <= Trace.LEVEL) {
                    Trace.trace("appahscD", "invalidateI5OSLparVirProcs =" + allocProcAndLparInfo3);
                }
                System.out.println("After 1st round of stealing for I5OS procs ... missingI5OSVirProcs = " + n9);
                if (n9 > 0) {
                    n24 = PIClusterModifier.isUserDefinedCluster(n15) ? 1 : 0;
                    if (n24 != 0) {
                        AllocProcAndLparInfo allocProcAndLparInfo4 = null;
                        if (processorTable.uncappedI5OSLparProcValPairsWithSameCluster != null && processorTable.uncappedI5OSLparProcValPairsWithSameCluster.length > 0) {
                            allocProcAndLparInfo4 = PIResourcesAllocationUtils.checkVirProcsToSteal(n12, n9, n, processorTable.uncappedI5OSLparProcValPairsWithSameCluster, providerCIMOMHandle, false);
                        }
                        if (null != allocProcAndLparInfo4) {
                            int n25 = 0;
                            long l24 = 0L;
                            try {
                                n25 = allocProcAndLparInfo4.allocatedProc.intValue();
                            }
                            catch (Throwable throwable) {
                                n25 = 0;
                            }
                            try {
                                l24 = allocProcAndLparInfo4.allocatedProcUnits.longValue();
                            }
                            catch (Throwable throwable) {
                                l24 = 0L;
                            }
                            n8 += n25;
                            n9 -= n25;
                            l5 += l24;
                            l6 -= l24;
                            l20 += l24;
                            l21 -= (long)(n25 * 100);
                        }
                        if (allocProcAndLparInfo4 != null && allocProcAndLparInfo3 != null) {
                            allocProcAndLparInfo3.mergeLparProcInfo(allocProcAndLparInfo4);
                        } else if (allocProcAndLparInfo3 == null) {
                            allocProcAndLparInfo3 = allocProcAndLparInfo4;
                            allocProcAndLparInfo3.lparProcTypes = processorTable.lparProcTypes;
                        }
                        if (3 <= Trace.LEVEL) {
                            Trace.trace("appahscD", "invalidateI5OSLparVirProcs =" + allocProcAndLparInfo3);
                        }
                        System.out.println("After 1st round of stealing for I5OS procs ... missingI5OSVirProcs = " + n9);
                    }
                    if (n9 > 0) {
                        if (n8 < n5) {
                            bl4 = true;
                        }
                        n7 = n8;
                        l4 = l5;
                    } else {
                        n7 = n8;
                        l4 = l5;
                    }
                    allocProcAndLparInfo.allocatedProc = new UnsignedInt16(n8);
                    allocProcAndLparInfo.allocatedProcUnits = new UnsignedInt32(l5);
                } else {
                    n7 = n8;
                    l4 = l5;
                    allocProcAndLparInfo.allocatedProc = new UnsignedInt16(n8);
                    allocProcAndLparInfo.allocatedProcUnits = new UnsignedInt32(l5);
                }
                if (allocProcAndLparInfo3 != null) {
                    allocProcAndLparInfo.mergeLparProcInfo(allocProcAndLparInfo3);
                }
                allocProcAndLparInfo.allocatedProc = new UnsignedInt16(n8);
                allocProcAndLparInfo.allocatedProcUnits = new UnsignedInt32(l5);
            } else {
                n7 = n8;
                l4 = l5;
                if (processorTable != null) {
                    allocProcAndLparInfo.lparProcTypes = processorTable.lparProcTypes;
                }
                allocProcAndLparInfo.allocatedProc = new UnsignedInt16(n8);
                allocProcAndLparInfo.allocatedProcUnits = new UnsignedInt32(l5);
            }
        } else {
            allocProcAndLparInfo.allocatedProc = new UnsignedInt16(n8);
        }
        if (l6 > 0L || l21 > 0L) {
            if (!bl3) {
                long l25 = 0L;
                try {
                    l25 = processorTable.procUnitsForNotBootableLpar.longValue();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                System.out.println("Ann-> in checkProcsForAlloc method -> procUnitsForNotBootableI5OSLpars = " + l25);
                if (l25 > 0L) {
                    l5 += l25;
                    System.out.println("checkProcsForAlloc -> Finished checking not bootable lpars -> missingI5OSProcUnits = " + (l6 -= l25));
                    System.out.println(" procUnitsNeededForUncapped = " + (l21 -= l25));
                    int n26 = 0;
                    if (null != processorTable.notBootableLpars) {
                        n26 = processorTable.notBootableLpars.length;
                    }
                    int n27 = 0;
                    if (null != allocProcAndLparInfo && null != allocProcAndLparInfo.lparIDs) {
                        n27 = allocProcAndLparInfo.lparIDs.length;
                    }
                    UnsignedInt16[] unsignedInt16Array = new UnsignedInt16[n27 + n26];
                    if (n26 > 0) {
                        System.arraycopy(processorTable.notBootableLpars, 0, unsignedInt16Array, 0, n26);
                    }
                    if (n27 != 0) {
                        System.arraycopy(allocProcAndLparInfo.lparIDs, 0, unsignedInt16Array, n26, n27);
                    }
                    allocProcAndLparInfo.lparIDs = unsignedInt16Array;
                }
            }
            if (l6 > 0L || l21 > 0L) {
                System.out.println("procUnitsNeededForUncapped = " + l21);
                System.out.println("checkProcsForAlloc -> checkProcsToSteal (i5/OS, 1st round)");
                System.out.println("accumI5OSProcUnits = " + l5);
                if (3 <= Trace.LEVEL) {
                    Trace.trace("appahscD", "accumI5OSProcUnits =" + l5);
                }
                AllocProcAndLparInfo allocProcAndLparInfo5 = null;
                allocProcAndLparInfo5 = l21 > 0L ? PIResourcesAllocationUtils.checkProcsToSteal(n12, l21, n, processorTable.i5OSLparProcValPairsWithNoCluster, providerCIMOMHandle, false, true, omCecMgr) : PIResourcesAllocationUtils.checkProcsToSteal(n12, l6, n, processorTable.i5OSLparProcValPairsWithNoCluster, providerCIMOMHandle, false, true, omCecMgr);
                System.out.println("invalidateI5OSLparProcUnits = " + allocProcAndLparInfo5);
                if (null != allocProcAndLparInfo5) {
                    allocProcAndLparInfo5.lparProcTypes = processorTable.lparProcTypes;
                    boolean bl7 = false;
                    long l26 = 0L;
                    try {
                        l26 = allocProcAndLparInfo5.allocatedProcUnits.longValue();
                    }
                    catch (Throwable throwable) {
                        l26 = 0L;
                    }
                    l5 += l26;
                    l6 -= l26;
                    l21 -= l26;
                }
                if (3 <= Trace.LEVEL) {
                    Trace.trace("appahscD", "invalidateI5OSLparProcUnits =" + allocProcAndLparInfo5);
                }
                System.out.println("After 1st round of stealing for I5OS procs ... missingI5OSProcUnits = " + l6);
                System.out.println("procUnitsNeededForUncapped = " + l21);
                if (l6 > 0L || l21 > 0L) {
                    System.out.println("procUnitsNeededForUncapped = " + l21);
                    boolean bl8 = PIClusterModifier.isUserDefinedCluster(n15);
                    if (bl8) {
                        AllocProcAndLparInfo allocProcAndLparInfo6 = null;
                        long l27 = 0L;
                        if (l21 > 0L) {
                            System.out.println("procUnitsNeededForUncapped = " + l21);
                            l27 = l21;
                        } else {
                            l27 = l6;
                        }
                        if (processorTable.i5OSLparProcValPairsWithSameCluster != null && processorTable.i5OSLparProcValPairsWithSameCluster.length > 0) {
                            allocProcAndLparInfo6 = PIResourcesAllocationUtils.checkProcsToSteal(n12, l27, n, processorTable.i5OSLparProcValPairsWithSameCluster, providerCIMOMHandle, true, true, omCecMgr);
                        }
                        if (null != allocProcAndLparInfo6) {
                            long l28 = 0L;
                            try {
                                l28 = allocProcAndLparInfo6.allocatedProcUnits.longValue();
                            }
                            catch (Throwable throwable) {
                                l28 = 0L;
                            }
                            l5 += l28;
                            l6 -= l28;
                        }
                        if (allocProcAndLparInfo6 != null && allocProcAndLparInfo5 != null) {
                            allocProcAndLparInfo5.mergeLparProcInfo(allocProcAndLparInfo6);
                        } else if (allocProcAndLparInfo5 == null) {
                            allocProcAndLparInfo5 = allocProcAndLparInfo6;
                            allocProcAndLparInfo5.lparProcTypes = processorTable.lparProcTypes;
                        }
                        if (3 <= Trace.LEVEL) {
                            Trace.trace("appahscD", "invalidateI5OSLparProcUnits =" + allocProcAndLparInfo5);
                        }
                        System.out.println("After 1st round of stealing for I5OS procs ... missingI5OSProcUnits = " + l6);
                    }
                    if (l6 > 0L || l21 > 0L) {
                        System.out.println("procUnitsNeededForUncapped = " + l21);
                        if (l5 + l12 < l2 || (long)(n4 * 100) - l21 < l2) {
                            System.out.println("accumI5OSProcUnits = " + l5);
                            bl5 = true;
                        }
                        if (l21 > 0L) {
                            System.out.println("adjust missing vir proc and accum vir proc");
                            long l29 = (long)(n4 * 100) - l21;
                            n7 = n8 = (int)(l29 / 100L);
                            allocProcAndLparInfo.allocatedProc = new UnsignedInt16(n7);
                            System.out.println("adjusted accumI5OSVirProcs = " + n8);
                            if (n7 < n5 && !bl2) {
                                bl4 = true;
                            }
                        }
                        l4 = l5;
                        allocProcAndLparInfo.allocatedProcUnits = new UnsignedInt32(l5);
                    } else {
                        l4 = l5;
                        allocProcAndLparInfo.allocatedProcUnits = new UnsignedInt32(l5);
                    }
                } else {
                    l4 = l5;
                    allocProcAndLparInfo.allocatedProcUnits = new UnsignedInt32(l5);
                }
                if (allocProcAndLparInfo5 != null) {
                    allocProcAndLparInfo.mergeLparProcInfo(allocProcAndLparInfo5);
                    allocProcAndLparInfo.allocatedProcUnits = new UnsignedInt32(l5);
                }
            } else {
                l4 = l5;
                allocProcAndLparInfo.allocatedProcUnits = new UnsignedInt32(l5);
            }
        } else {
            allocProcAndLparInfo.allocatedProcUnits = new UnsignedInt32(l5);
        }
        System.out.println("insufficientVirProcs = " + bl4);
        System.out.println("insufficientProcUnits = " + bl5);
        if (bl4 || bl5 && !bl2) {
            long l30;
            long l31 = l5 + l12;
            if (bl4 && (n == 255 || n != 255 && n2 == 0) && l31 > (l30 = (long)(n8 * 100))) {
                l31 = l30;
            }
            if (255 != n && n2 != 1) {
                n8 = n5;
            }
            if ((n6 & 2) != 0 || (n6 & 4) != 0 || (n6 & 8) != 0 || (n6 & 0x10) != 0) {
                int n28;
                allocProcAndLparInfo2 = new AllocProcAndLparInfo();
                allocProcAndLparInfo2.i5OSCapacityCheckingFailed = true;
                if (l21 > 0L && n8 > (n28 = (int)(((long)(n4 * 100) - l21) / 100L))) {
                    n8 = n28;
                }
                allocProcAndLparInfo2.allocatedProc = new UnsignedInt16(n8);
                allocProcAndLparInfo2.allocatedProcUnits = new UnsignedInt32(l31);
                return allocProcAndLparInfo2;
            }
            if (255 == n) {
                System.out.println("ERROR: Insufficient i5/OS processors to activate");
                throw new PIHscServerException("0403", new String[]{Integer.toString((int)l31 / 100), Integer.toString(n5)}, null);
            }
            if (n2 == 1) {
                int n29;
                System.out.println("ERROR: Insufficient i5/OS processors to activate");
                System.out.println("procUnitsNeededForUncapped = " + l21);
                if (l21 > 0L && n8 > (n29 = (int)(((long)(n4 * 100) - l21) / 100L))) {
                    n8 = n29;
                }
                throw new PIHscServerException("0404", new String[]{Integer.toString(new Double(n8).intValue()), Integer.toString(n5), Double.toString((double)l31 / 100.0), Double.toString((double)l7 / 100.0)}, null);
            }
            throw new PIHscServerException("0404", new String[]{Integer.toString(n8), Integer.toString(n5), Double.toString((double)l31 / 100.0), Double.toString((double)l2 / 100.0)}, null);
        }
        if (n == 255 || n != 255 && n2 == 0) {
            allocProcAndLparInfo.allocatedProc = new UnsignedInt16(n4);
        }
        return allocProcAndLparInfo;
    }

    public static AllocProcAndLparInfo checkProcsForAlloc(CIMInstance cIMInstance, int n, CIMInstance cIMInstance2, int n2, long l, ProviderCIMOMHandle providerCIMOMHandle, String string, int n3, long l2, int n4, int n5, int n6, boolean bl) throws PIHscServerException {
        return PIResourcesAllocationUtils.checkProcsForAlloc(cIMInstance, n, cIMInstance2, n2, l, providerCIMOMHandle, string, n3, l2, n4, n5, n6, bl, null);
    }

    public static AllocProcAndLparInfo checkProcsForAlloc(CIMInstance cIMInstance, int n, CIMInstance cIMInstance2, int n2, long l, ProviderCIMOMHandle providerCIMOMHandle, String string, int n3, long l2, int n4, int n5, int n6, boolean bl, Vector vector) throws PIHscServerException {
        int[] nArray;
        Trace.trace("appahscT", "-> PIResourcesAllocationUtils.checkProcsForAlloc");
        Trace.trace("appahscF", "lparInstance = " + cIMInstance);
        Trace.trace("appahscF", "procMode = " + n);
        Trace.trace("appahscF", "cecInstance = " + cIMInstance2);
        Trace.trace("appahscF", "defState = " + n2);
        Trace.trace("appahscF", "numProcsDesired = " + l);
        Trace.trace("appahscF", "cimHandle = " + providerCIMOMHandle);
        Trace.trace("appahscF", "namespace = " + string);
        Trace.trace("appahscF", "sharingMode = " + n3);
        Trace.trace("appahscF", "numProcsRequired = " + l2);
        Trace.trace("appahscF", "numVirtualProcsDesired = " + n4);
        Trace.trace("appahscF", "numVirtualProcsRequired = " + n5);
        System.out.println("numVirtualProcsDesired = " + n4);
        System.out.println("numVirtualProcsRequired = " + n5);
        int n7 = 0;
        long l3 = 0L;
        int n8 = 0;
        long l4 = 0L;
        long l5 = 0L;
        ProcessorTable processorTable = null;
        long l6 = 0L;
        long l7 = 0L;
        long l8 = 0L;
        int n9 = 0;
        String string2 = null;
        AllocProcAndLparInfo allocProcAndLparInfo = new AllocProcAndLparInfo();
        CIMObjectPath cIMObjectPath = null;
        String string3 = "";
        try {
            string3 = (String)cIMInstance2.getProperty("Name").getValue().getValue();
        }
        catch (Throwable throwable) {
            try {
                HSCLogUtils.serverLog(throwable, HSCLogUtils._LPARClassLogInfo);
            }
            catch (Throwable throwable2) {
                // empty catch block
            }
            throw new PIHscServerException("2523", new String[]{"R50ComputerSystem.Name"}, throwable);
        }
        cIMObjectPath = new CIMObjectPath("IBMHSC_Partition", string);
        cIMObjectPath.setKeys(cIMInstance.getKeyValuePairs());
        OmCecMgr omCecMgr = OmCecMgr.getCecMgr(string3);
        try {
            string2 = (String)cIMInstance.getProperty("Name").getValue().getValue();
        }
        catch (Throwable throwable) {
            try {
                HSCLogUtils.serverLog(throwable, HSCLogUtils._LPARClassLogInfo);
            }
            catch (Throwable throwable3) {
                // empty catch block
            }
            throw new PIHscServerException("2523", new String[]{"R50Partition.Name"}, throwable);
        }
        n9 = Integer.parseInt(string2.substring(0, string2.indexOf(42)));
        CIMValue cIMValue = cIMInstance.getProperty("PendProcMode").getValue();
        System.out.println("checkProcsForAlloc -> curProcModeVal = " + cIMValue);
        boolean bl2 = false;
        if (null != cIMValue) {
            n7 = ((UnsignedInt8)cIMValue.getValue()).shortValue();
        } else {
            bl2 = true;
            n7 = 255;
        }
        boolean bl3 = PIResourcesAllocationUtils.totalPendingOverConfigured(omCecMgr, true);
        OmLparMgr omLparMgr = null;
        try {
            omLparMgr = omCecMgr.getLparMgr(string2);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        if (bl3) {
            PIResourcesAllocationUtils.syncPendProcToCur(omCecMgr, omLparMgr);
            PIResourcesAllocationUtils.syncAllAccessiblePendResToCur(omCecMgr, omLparMgr, providerCIMOMHandle, true);
        }
        try {
            cIMInstance = CimomWrapper.getInstance((CIMOMHandle)providerCIMOMHandle, cIMObjectPath, providerCIMOMHandle.getClass(cIMObjectPath, false), false);
        }
        catch (CIMException cIMException) {
            try {
                HSCLogUtils.serverLog(cIMException, HSCLogUtils._LPARClassLogInfo);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            cIMInstance = null;
        }
        if (cIMInstance == null) {
            throw new PIHscServerException("2916", null);
        }
        if (3 <= Trace.LEVEL) {
            Trace.trace("appahscD", "lparInstance =" + cIMInstance);
        }
        if (!bl2) {
            CIMValue cIMValue2;
            if (255 == n7) {
                cIMValue2 = cIMInstance.getProperty("PendAllocProcs").getValue();
                if (cIMValue2 != null) {
                    l3 = ((UnsignedInt16)cIMValue2.getValue()).intValue() * 100;
                    n8 = ((UnsignedInt16)cIMValue2.getValue()).intValue();
                }
            } else {
                cIMValue2 = cIMInstance.getProperty("PendAllocProcUnits").getValue();
                if (cIMValue2 != null) {
                    l3 = ((UnsignedInt32)cIMValue2.getValue()).longValue();
                }
                if ((cIMValue2 = cIMInstance.getProperty("PendAllocProcs").getValue()) != null) {
                    n8 = ((UnsignedInt16)cIMValue2.getValue()).intValue();
                }
            }
        }
        if (3 <= Trace.LEVEL) {
            Trace.trace("appahscD", "ownCPU =" + l3);
        }
        System.out.println("checkProcsForAlloc -> ownCPU = " + l3);
        try {
            l4 = ((UnsignedInt32)cIMInstance2.getProperty("PendAvailProcUnits").getValue().getValue()).longValue();
        }
        catch (Throwable throwable) {
            throw new PIHscServerException("2523", new String[]{"R50ComputerSystem.PendAvailProcUnits"}, throwable);
        }
        System.out.println("checkProcsForAlloc -> availableCPU = " + l4);
        long l9 = 0L;
        try {
            l9 = ((UnsignedInt16)cIMInstance2.getProperty("MaxI5OSProcUnits").getValue().getValue()).longValue();
        }
        catch (Throwable throwable) {
            l9 = 0L;
        }
        n2 = 0;
        try {
            n2 = ((UnsignedInt8)cIMInstance.getProperty("DefinitionState").getValue().getValue()).intValue();
        }
        catch (Throwable throwable) {
            try {
                HSCLogUtils.serverLog(throwable, HSCLogUtils._LPARClassLogInfo);
            }
            catch (Throwable throwable4) {
                // empty catch block
            }
            throw new PIHscServerException("2523", new String[]{"R50Partition.DefinitionState"}, throwable);
        }
        if (130 == n2) {
            System.out.println("Ann-> defState is OS400_LPAR_VALID");
        }
        if (129 == n2) {
            System.out.println("Ann-> defState is OS400_LPAR_NOT_BOOTABLE");
        }
        System.out.println("Ann->i5OS: in checkProcsForAlloc method ... maxI5OSCPU = " + l9);
        System.out.println("Ann->i5OS: in checkProcsForAlloc method ... defState = " + n2);
        if ((130 == n2 || 129 == n2) && l9 > 0L) {
            int[] nArray2;
            allocProcAndLparInfo.pI5OS = true;
            long l10 = 0L;
            long l11 = 0L;
            l10 = l;
            l11 = l2;
            AllocProcAndLparInfo allocProcAndLparInfo2 = new AllocProcAndLparInfo();
            System.out.println("Ann-> sharingMode is " + n3);
            if (255 != n && n3 == 1) {
                System.out.println("Ann-> sharingMode is uncapped");
            }
            long l12 = 0L;
            long l13 = 0L;
            long l14 = 0L;
            boolean bl4 = false;
            long l15 = 0L;
            long l16 = 0L;
            long l17 = 0L;
            long l18 = 0L;
            boolean bl5 = true;
            if (n != 255 && n3 == 1) {
                bl5 = false;
            }
            allocProcAndLparInfo2 = PIResourcesAllocationUtils.checkI5OSProcsForAlloc(cIMInstance, cIMObjectPath, n, n3, bl5, cIMInstance2, n2, n4, n5, l, l2, l9, providerCIMOMHandle, string, n6, vector);
            boolean bl6 = false;
            if (allocProcAndLparInfo2 != null) {
                System.out.println("i5OSLparInfo = " + allocProcAndLparInfo2);
                l = allocProcAndLparInfo2.updatedDesiredProcUnits;
                System.out.println("numProcDesired = " + l);
                allocProcAndLparInfo.i5OSCapacityCheckingFailed = allocProcAndLparInfo2.i5OSCapacityCheckingFailed;
                bl6 = allocProcAndLparInfo2.i5OSCapacityCheckingFailed;
                System.out.println("i5OSCapacityCheckingFailed = " + allocProcAndLparInfo2.i5OSCapacityCheckingFailed);
            }
            if (bl || bl6) {
                allocProcAndLparInfo2.pI5OS = true;
                System.out.println("%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%");
                if (255 == n) {
                    allocProcAndLparInfo2.allocatedProc = new UnsignedInt16(n4);
                } else if (n3 == 0) {
                    allocProcAndLparInfo2.allocatedProc = new UnsignedInt16(n4);
                }
                return allocProcAndLparInfo2;
            }
            int n10 = 0;
            if (allocProcAndLparInfo2 == null) {
                allocProcAndLparInfo2 = new AllocProcAndLparInfo();
            } else {
                if (allocProcAndLparInfo2.allocatedProc != null) {
                    n10 = allocProcAndLparInfo2.allocatedProc.intValue();
                }
                if (allocProcAndLparInfo2.allocatedProcUnits != null) {
                    l18 = allocProcAndLparInfo2.allocatedProcUnits.longValue();
                }
            }
            long l19 = n10 * 100;
            l5 = l3 + l18;
            System.out.println("maxProcUnitsPossible = " + l19);
            System.out.println("ownCPU = " + l3);
            System.out.println("foundI5OSCPU = " + l18);
            System.out.println("accumCPU = " + l5);
            if (l5 >= l || l5 > l19) {
                allocProcAndLparInfo = allocProcAndLparInfo2;
                if (255 == n) {
                    if (l19 < l) {
                        allocProcAndLparInfo.allocatedProcUnits = new UnsignedInt32(l19);
                        allocProcAndLparInfo.allocatedProc = new UnsignedInt16((int)(l19 / 100L));
                    } else {
                        allocProcAndLparInfo.allocatedProcUnits = new UnsignedInt32(l);
                        allocProcAndLparInfo.allocatedProc = new UnsignedInt16((int)l / 100);
                    }
                } else if (l19 < l) {
                    allocProcAndLparInfo.allocatedProcUnits = new UnsignedInt32(l19);
                    allocProcAndLparInfo.allocatedProc = new UnsignedInt16(n10);
                } else {
                    allocProcAndLparInfo.allocatedProcUnits = new UnsignedInt32(l);
                    allocProcAndLparInfo.allocatedProc = new UnsignedInt16(n10);
                }
                return allocProcAndLparInfo;
            }
            int n11 = 11;
            ProcessorTable processorTable2 = PIResourcesAllocationUtils.getLparProcInfo(n9, string3, n, providerCIMOMHandle, string, 65535, n11, false, vector);
            if (3 <= Trace.LEVEL) {
                Trace.trace("appahscD", "nonI5OSProcTable =" + processorTable2);
            }
            System.out.println("checkProcsForAlloc -> nonI5OSProcTable = " + processorTable2);
            l8 = processorTable2.procUnitsForNotBootableLpar.longValue();
            System.out.println("procUnitsForNotBootableNonI5OSLpars = " + l8);
            if (l8 + l5 >= l) {
                if (255 == n) {
                    allocProcAndLparInfo.allocatedProc = new UnsignedInt16((int)l / 100);
                } else {
                    allocProcAndLparInfo.allocatedProcUnits = new UnsignedInt32(l);
                }
                allocProcAndLparInfo.lparIDs = processorTable2.notBootableLpars;
                allocProcAndLparInfo.lparProcTypes = processorTable2.lparProcTypes;
                allocProcAndLparInfo.mergeLparProcInfo(allocProcAndLparInfo2);
                return allocProcAndLparInfo;
            }
            l5 += l7;
            System.out.println("checkProcsForAlloc -> checkProcsToSteal");
            if (3 <= Trace.LEVEL) {
                Trace.trace("appahscD", "accumCPU =" + l5);
            }
            AllocProcAndLparInfo allocProcAndLparInfo3 = PIResourcesAllocationUtils.checkProcsToSteal(n9, l - l5, n, processorTable2.lparProcValPairs, providerCIMOMHandle, false);
            allocProcAndLparInfo3.lparProcTypes = processorTable2.lparProcTypes;
            System.out.println("invalidateNonI5OSLparCPU = " + allocProcAndLparInfo3);
            if (null != allocProcAndLparInfo3) {
                l5 += allocProcAndLparInfo3.allocatedProcUnits.longValue();
            }
            if (3 <= Trace.LEVEL) {
                Trace.trace("appahscD", "invalidateLparCPU =" + allocProcAndLparInfo3);
            }
            long l20 = l - l5;
            System.out.println("lackingNonI5OSCPU = " + l20);
            ProcessorTable processorTable3 = null;
            AllocProcAndLparInfo allocProcAndLparInfo4 = null;
            if (l20 > 0L && (nArray2 = PIClusterModifier.getLparClusterInfo((CIMOMHandle)providerCIMOMHandle, cIMObjectPath))[0] <= Short.MAX_VALUE) {
                System.out.println("wlmData[0] = " + nArray2[0]);
                processorTable3 = PIResourcesAllocationUtils.getLparProcInfo(n9, string3, n, providerCIMOMHandle, string, nArray2[0], n11, false, vector);
                System.out.println("inWlmNonI5OSTable = " + processorTable3);
                if (processorTable3 != null || processorTable3.lparProcValPairs != null) {
                    allocProcAndLparInfo4 = PIResourcesAllocationUtils.checkProcsToSteal(n9, l20, n, processorTable3.lparProcValPairs, providerCIMOMHandle, true);
                    if (3 <= Trace.LEVEL) {
                        Trace.trace("appahscD", "inWlmNonI5OSLparProc =" + allocProcAndLparInfo4);
                    }
                    if (allocProcAndLparInfo4 != null && allocProcAndLparInfo4.allocatedProcUnits != null) {
                        l5 += allocProcAndLparInfo4.allocatedProcUnits.longValue();
                        allocProcAndLparInfo4.lparProcTypes = processorTable3.lparProcTypes;
                        allocProcAndLparInfo3.mergeLparProcInfo(allocProcAndLparInfo4);
                    }
                }
            }
            System.out.println("accumCPU = " + l5);
            allocProcAndLparInfo.lparProcSettings = allocProcAndLparInfo3.lparProcSettings;
            int n12 = 0;
            int n13 = 0;
            if (null != processorTable2.notBootableLpars) {
                n12 = processorTable2.notBootableLpars.length;
            }
            if (null != allocProcAndLparInfo3.lparIDs) {
                n13 = allocProcAndLparInfo3.lparIDs.length;
            }
            allocProcAndLparInfo.lparIDs = new UnsignedInt16[n12 + n13];
            if (n12 != 0) {
                System.arraycopy(processorTable2.notBootableLpars, 0, allocProcAndLparInfo.lparIDs, 0, n12);
            }
            if (n13 != 0) {
                System.arraycopy(allocProcAndLparInfo3.lparIDs, 0, allocProcAndLparInfo.lparIDs, n12, n13);
            }
            allocProcAndLparInfo.lparProcTypes = allocProcAndLparInfo3.lparProcTypes;
            Trace.trace("appahscT", "PIResourcesAllocationUtils.checkProcsForAlloc  <-");
            System.out.println("WLM checkProcsForAlloc: " + allocProcAndLparInfo);
            System.out.println("i5OSLparInfo = " + allocProcAndLparInfo2);
            allocProcAndLparInfo.mergeLparProcInfo(allocProcAndLparInfo2);
            System.out.println("^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^");
            if (255 == n) {
                allocProcAndLparInfo.allocatedProc = new UnsignedInt16((int)l5 / 100);
            } else if (n3 == 0) {
                allocProcAndLparInfo.allocatedProc = new UnsignedInt16(n4);
            } else {
                int n14 = n10 + n8;
                if (n14 > n4) {
                    n14 = n4;
                }
                allocProcAndLparInfo.allocatedProc = new UnsignedInt16(n14);
            }
            allocProcAndLparInfo.allocatedProcUnits = new UnsignedInt32(l5);
            System.out.println("retVal = " + allocProcAndLparInfo);
            return allocProcAndLparInfo;
        }
        if (l3 + l4 >= l) {
            if (255 == n) {
                allocProcAndLparInfo.allocatedProc = new UnsignedInt16((int)l / 100);
            } else {
                allocProcAndLparInfo.allocatedProcUnits = new UnsignedInt32(l);
            }
            System.out.println("retVal = " + allocProcAndLparInfo);
            return allocProcAndLparInfo;
        }
        l5 = l3 + l4;
        processorTable = PIResourcesAllocationUtils.getLparProcInfo(n9, string3, n, providerCIMOMHandle, string, 65535, vector);
        if (3 <= Trace.LEVEL) {
            Trace.trace("appahscD", "procTable =" + processorTable);
        }
        System.out.println("allocateDedicateProc -> procTable = " + processorTable);
        l6 = processorTable.procUnitsForNotBootableLpar.longValue();
        if (l6 + l5 >= l) {
            if (255 == n) {
                allocProcAndLparInfo.allocatedProc = new UnsignedInt16((int)l / 100);
            } else {
                allocProcAndLparInfo.allocatedProcUnits = new UnsignedInt32(l);
            }
            allocProcAndLparInfo.lparIDs = processorTable.notBootableLpars;
            allocProcAndLparInfo.lparProcTypes = processorTable.lparProcTypes;
            System.out.println("retVal = " + allocProcAndLparInfo);
            return allocProcAndLparInfo;
        }
        l5 += l6;
        System.out.println("allocateDedicateProc -> checkProcsToSteal");
        if (3 <= Trace.LEVEL) {
            Trace.trace("appahscD", "accumCPU =" + l5);
        }
        AllocProcAndLparInfo allocProcAndLparInfo5 = PIResourcesAllocationUtils.checkProcsToSteal(n9, l - l5, n, processorTable.lparProcValPairs, providerCIMOMHandle, false);
        allocProcAndLparInfo5.lparProcTypes = processorTable.lparProcTypes;
        if (null != allocProcAndLparInfo5) {
            l5 += allocProcAndLparInfo5.allocatedProcUnits.longValue();
        }
        if (3 <= Trace.LEVEL) {
            Trace.trace("appahscD", "invalidateLparCPU =" + allocProcAndLparInfo5);
        }
        long l21 = l - l5;
        System.out.println("lackedCPU = " + l21);
        ProcessorTable processorTable4 = null;
        AllocProcAndLparInfo allocProcAndLparInfo6 = null;
        if (l21 > 0L && (nArray = PIClusterModifier.getLparClusterInfo((CIMOMHandle)providerCIMOMHandle, cIMObjectPath))[0] <= Short.MAX_VALUE) {
            System.out.println("wlmData[0] = " + nArray[0]);
            processorTable4 = PIResourcesAllocationUtils.getLparProcInfo(n9, string3, n, providerCIMOMHandle, string, nArray[0], vector);
            System.out.println("inWlmTable = " + processorTable4);
            if (processorTable4 != null || processorTable4.lparProcValPairs != null) {
                allocProcAndLparInfo6 = PIResourcesAllocationUtils.checkProcsToSteal(n9, l21, n, processorTable4.lparProcValPairs, providerCIMOMHandle, true);
                if (3 <= Trace.LEVEL) {
                    Trace.trace("appahscD", "inWlmLparProc =" + allocProcAndLparInfo6);
                }
                if (allocProcAndLparInfo6 != null && allocProcAndLparInfo6.allocatedProcUnits != null) {
                    l5 += allocProcAndLparInfo6.allocatedProcUnits.longValue();
                    allocProcAndLparInfo6.lparProcTypes = processorTable4.lparProcTypes;
                    allocProcAndLparInfo5.mergeLparProcInfo(allocProcAndLparInfo6);
                }
            }
        }
        if (255 == n) {
            allocProcAndLparInfo.allocatedProc = new UnsignedInt16((int)(l5 / 100L));
        } else {
            allocProcAndLparInfo.allocatedProcUnits = new UnsignedInt32(l5);
        }
        allocProcAndLparInfo.lparProcSettings = allocProcAndLparInfo5.lparProcSettings;
        int n15 = 0;
        int n16 = 0;
        if (null != processorTable.notBootableLpars) {
            n15 = processorTable.notBootableLpars.length;
        }
        if (null != allocProcAndLparInfo5.lparIDs) {
            n16 = allocProcAndLparInfo5.lparIDs.length;
        }
        allocProcAndLparInfo.lparIDs = new UnsignedInt16[n15 + n16];
        if (n15 != 0) {
            System.arraycopy(processorTable.notBootableLpars, 0, allocProcAndLparInfo.lparIDs, 0, n15);
        }
        if (n16 != 0) {
            System.arraycopy(allocProcAndLparInfo5.lparIDs, 0, allocProcAndLparInfo.lparIDs, n15, n16);
        }
        allocProcAndLparInfo.lparProcTypes = allocProcAndLparInfo5.lparProcTypes;
        Trace.trace("appahscT", "PIResourcesAllocationUtils.checkProcsForAlloc  <-");
        System.err.println("WLM checkProcsForAlloc: " + allocProcAndLparInfo);
        return allocProcAndLparInfo;
    }

    public static long getI5OSCPU(boolean bl, CIMInstance cIMInstance, int n, CIMInstance cIMInstance2, ProviderCIMOMHandle providerCIMOMHandle, String string) throws PIHscServerException {
        Trace.trace("appahscT", "-> PIResourcesAllocationUtils.getI5OSCPU");
        Trace.trace("appahscF", "inRunning = " + bl);
        Trace.trace("appahscF", "lparInstance = " + cIMInstance);
        Trace.trace("appahscF", "procMode = " + n);
        Trace.trace("appahscF", "cecInstance = " + cIMInstance2);
        Trace.trace("appahscF", "cimHandle = " + providerCIMOMHandle);
        Trace.trace("appahscF", "namespace = " + string);
        long l = 0L;
        ProcessorTable processorTable = null;
        int n2 = 0;
        String string2 = null;
        CIMObjectPath cIMObjectPath = null;
        String string3 = "";
        try {
            string3 = (String)cIMInstance2.getProperty("Name").getValue().getValue();
        }
        catch (Throwable throwable) {
            try {
                HSCLogUtils.serverLog(throwable, HSCLogUtils._LPARClassLogInfo);
            }
            catch (Throwable throwable2) {
                // empty catch block
            }
            throw new PIHscServerException("2523", new String[]{"R50ComputerSystem.Name"}, throwable);
        }
        cIMObjectPath = new CIMObjectPath("IBMHSC_Partition", string);
        cIMObjectPath.setKeys(cIMInstance.getKeyValuePairs());
        try {
            string2 = (String)cIMInstance.getProperty("Name").getValue().getValue();
        }
        catch (Throwable throwable) {
            try {
                HSCLogUtils.serverLog(throwable, HSCLogUtils._LPARClassLogInfo);
            }
            catch (Throwable throwable3) {
                // empty catch block
            }
            throw new PIHscServerException("2523", new String[]{"R50Partition.Name"}, throwable);
        }
        n2 = Integer.parseInt(string2.substring(0, string2.indexOf(42)));
        processorTable = PIResourcesAllocationUtils.getI5OSLparProcInfo(bl, n2, string3, n, providerCIMOMHandle, string);
        LparProcValuePair[] lparProcValuePairArray = processorTable.lparProcValPairs;
        System.out.println("in getI5OSCPU --> lparProcPairList = " + lparProcValuePairArray);
        int n3 = lparProcValuePairArray.length;
        System.out.println("in getI5OSCPU --> size of lparProcPairList = " + n3);
        for (int i = 0; i < n3; ++i) {
            if (3 <= Trace.LEVEL) {
                Trace.trace("appahscD", "lparProcPairList[" + i + "] = " + lparProcValuePairArray[i]);
            }
            System.out.println("in getI5OSCPU: collecting Running lpars? = " + bl);
            System.out.println("in getI5OSCPU: lpar proc amount = " + lparProcValuePairArray[i].procAmount);
            System.out.println("in getI5OSCPU: i5OSCPUInLparGroup = " + (l += lparProcValuePairArray[i].procAmount));
        }
        return l;
    }

    public static ProcessorTable getI5OSCPUInfo(boolean bl, CIMInstance cIMInstance, int n, CIMInstance cIMInstance2, ProviderCIMOMHandle providerCIMOMHandle, String string) throws PIHscServerException {
        return PIResourcesAllocationUtils.getI5OSCPUInfo(bl, cIMInstance, n, cIMInstance2, providerCIMOMHandle, string, null);
    }

    public static ProcessorTable getI5OSCPUInfo(boolean bl, CIMInstance cIMInstance, int n, CIMInstance cIMInstance2, ProviderCIMOMHandle providerCIMOMHandle, String string, Vector vector) throws PIHscServerException {
        CIMValue cIMValue;
        int n2;
        int n3;
        Object object;
        CIMInstance cIMInstance3;
        Enumeration enumeration;
        Trace.trace("appahscT", "-> PIResourcesAllocationUtils.getI5OSCPU");
        Trace.trace("appahscF", "lparCapped = " + bl);
        Trace.trace("appahscF", "actLparInstance = " + cIMInstance);
        Trace.trace("appahscF", "procMode = " + n);
        Trace.trace("appahscF", "cecInstance = " + cIMInstance2);
        Trace.trace("appahscF", "cimHandle = " + providerCIMOMHandle);
        Trace.trace("appahscF", "namespace = " + string);
        int n4 = 0;
        String string2 = null;
        CIMObjectPath cIMObjectPath = null;
        ProcessorTable processorTable = new ProcessorTable();
        String string3 = "";
        try {
            string3 = (String)cIMInstance2.getProperty("Name").getValue().getValue();
        }
        catch (Throwable throwable) {
            try {
                HSCLogUtils.serverLog(throwable, HSCLogUtils._LPARClassLogInfo);
            }
            catch (Throwable throwable2) {
                // empty catch block
            }
            throw new PIHscServerException("2523", new String[]{"R50ComputerSystem.Name"}, throwable);
        }
        cIMObjectPath = new CIMObjectPath("IBMHSC_Partition", string);
        cIMObjectPath.setKeys(cIMInstance.getKeyValuePairs());
        try {
            string2 = (String)cIMInstance.getProperty("Name").getValue().getValue();
        }
        catch (Throwable throwable) {
            try {
                HSCLogUtils.serverLog(throwable, HSCLogUtils._LPARClassLogInfo);
            }
            catch (Throwable throwable3) {
                // empty catch block
            }
            throw new PIHscServerException("2523", new String[]{"R50Partition.Name"}, throwable);
        }
        n4 = Integer.parseInt(string2.substring(0, string2.indexOf(42)));
        int n5 = 65535;
        Object var13_17 = null;
        try {
            PIClusterModifier.getLparClusterInfo((CIMOMHandle)providerCIMOMHandle, cIMObjectPath);
        }
        catch (Throwable throwable) {
            var13_17 = null;
        }
        n5 = var13_17 == null || !PIClusterModifier.isUserDefinedCluster((int)var13_17[0]) ? 65535 : var13_17[0];
        CIMObjectPath cIMObjectPath2 = PIResourcesAllocationUtils.constructCecPath(string3, string);
        Vector vector2 = null;
        Vector vector3 = null;
        try {
            vector2 = CimomWrapper.associators((CIMOMHandle)providerCIMOMHandle, new CIMObjectPath("IBMHSC_CompSysPartition", string), cIMObjectPath2, "IBMHSC_Partition", "GroupComponent", "PartComponent", false, false, null);
        }
        catch (Throwable throwable) {
            try {
                HSCLogUtils.serverLog(throwable, HSCLogUtils._LPARClassLogInfo);
            }
            catch (Throwable throwable4) {
                // empty catch block
            }
            vector2 = null;
        }
        try {
            vector3 = PIHmcAccessUtils.getLparObjWithAuthFromCec(cIMObjectPath2, "ActivateLparProfile", providerCIMOMHandle, false);
        }
        catch (Throwable throwable) {
            try {
                HSCLogUtils.serverLog(throwable, HSCLogUtils._LPARClassLogInfo);
            }
            catch (Throwable throwable5) {
                // empty catch block
            }
            vector3 = null;
        }
        Vector<UnsignedInt16> vector4 = new Vector<UnsignedInt16>();
        if (vector3 != null && vector3.size() > 0) {
            Enumeration enumeration2 = vector3.elements();
            while (enumeration2.hasMoreElements()) {
                CIMInstance cIMInstance4 = (CIMInstance)enumeration2.nextElement();
                String string4 = "";
                try {
                    string4 = (String)cIMInstance4.getProperty("Name").getValue().getValue();
                }
                catch (Throwable throwable) {
                    try {
                        HSCLogUtils.serverLog(throwable, HSCLogUtils._LPARClassLogInfo);
                    }
                    catch (Throwable throwable6) {
                        // empty catch block
                    }
                    throw new PIHscServerException("2523", new String[]{"R50Partition.Name"}, throwable);
                }
                int n6 = Integer.parseInt(string4.substring(0, string4.indexOf("*")));
                vector4.add(new UnsignedInt16(n6));
            }
        }
        int n7 = 0;
        long l = 0L;
        long l2 = 0L;
        int n8 = 0;
        long l3 = 0L;
        long l4 = 0L;
        Vector<LparProcValuePair> vector5 = new Vector<LparProcValuePair>();
        Vector<LparProcValuePair> vector6 = new Vector<LparProcValuePair>();
        Vector<LparProcValuePair> vector7 = new Vector<LparProcValuePair>();
        Vector<LparProcValuePair> vector8 = new Vector<LparProcValuePair>();
        boolean bl2 = true;
        if (null != vector2 && vector2.size() != 0) {
            if (3 <= Trace.LEVEL) {
                Trace.trace("appahscD", "allLpars =" + vector2);
            }
            enumeration = vector2.elements();
            while (enumeration.hasMoreElements()) {
                cIMInstance3 = (CIMInstance)enumeration.nextElement();
                object = "";
                try {
                    object = (String)cIMInstance3.getProperty("Name").getValue().getValue();
                }
                catch (Throwable throwable) {
                    try {
                        HSCLogUtils.serverLog(throwable, HSCLogUtils._LPARClassLogInfo);
                    }
                    catch (Throwable throwable7) {
                        // empty catch block
                    }
                    throw new PIHscServerException("2523", new String[]{"R50Partition.Name"}, throwable);
                }
                int n9 = Integer.parseInt(((String)object).substring(0, ((String)object).indexOf("*")));
                if (n9 == n4) continue;
                int n10 = 0;
                try {
                    n10 = ((UnsignedInt8)cIMInstance3.getProperty("DefinitionState").getValue().getValue()).intValue();
                }
                catch (Throwable throwable) {
                    try {
                        HSCLogUtils.serverLog(throwable, HSCLogUtils._LPARClassLogInfo);
                    }
                    catch (Throwable throwable8) {
                        // empty catch block
                    }
                    throw new PIHscServerException("2523", new String[]{"R50Partition.DefinitionState"}, throwable);
                }
                if (n10 != 130 && n10 != 129) continue;
                n3 = 0;
                CIMValue cIMValue2 = null;
                try {
                    cIMValue2 = cIMInstance3.getProperty("PendProcMode").getValue();
                    n3 = ((UnsignedInt8)cIMValue2.getValue()).intValue();
                }
                catch (Throwable throwable) {
                    try {
                        HSCLogUtils.serverLog(throwable, HSCLogUtils._LPARClassLogInfo);
                    }
                    catch (Throwable throwable9) {
                        // empty catch block
                    }
                    throw new PIHscServerException("2523", new String[]{"R50Partition.PendProcMode"}, throwable);
                }
                if (255 == n3) {
                    bl2 = true;
                    break;
                }
                n2 = 0;
                try {
                    cIMValue = cIMInstance3.getProperty("PendSharingMode").getValue();
                    n2 = ((UnsignedInt8)cIMValue.getValue()).shortValue();
                }
                catch (Throwable throwable) {
                    try {
                        HSCLogUtils.serverLog(throwable, HSCLogUtils._LPARClassLogInfo);
                    }
                    catch (Throwable throwable10) {
                        // empty catch block
                    }
                    throw new PIHscServerException("2523", new String[]{"R50Partition.PendSharingMode"}, throwable);
                }
                if (n2 != 1) continue;
                bl2 = true;
                break;
            }
        }
        if (null != vector2 && vector2.size() != 0) {
            if (3 <= Trace.LEVEL) {
                Trace.trace("appahscD", "allLpars =" + vector2);
            }
            enumeration = vector2.elements();
            processorTable.lparProcTypes = new Hashtable();
            while (enumeration.hasMoreElements()) {
                int n11;
                CIMInstance cIMInstance5 = (CIMInstance)enumeration.nextElement();
                String string5 = "";
                try {
                    string5 = (String)cIMInstance5.getProperty("Name").getValue().getValue();
                }
                catch (Throwable throwable) {
                    try {
                        HSCLogUtils.serverLog(throwable, HSCLogUtils._LPARClassLogInfo);
                    }
                    catch (Throwable throwable11) {
                        // empty catch block
                    }
                    throw new PIHscServerException("2523", new String[]{"R50Partition.Name"}, throwable);
                }
                n3 = Integer.parseInt(string5.substring(0, string5.indexOf("*")));
                if (n3 == n4) continue;
                int n12 = 0;
                try {
                    n12 = ((UnsignedInt8)cIMInstance5.getProperty("DefinitionState").getValue().getValue()).intValue();
                }
                catch (Throwable throwable) {
                    try {
                        HSCLogUtils.serverLog(throwable, HSCLogUtils._LPARClassLogInfo);
                    }
                    catch (Throwable throwable12) {
                        // empty catch block
                    }
                    throw new PIHscServerException("2523", new String[]{"R50Partition.DefinitionState"}, throwable);
                }
                if (n12 != 130 && n12 != 129) continue;
                n2 = 0;
                cIMValue = null;
                try {
                    cIMValue = cIMInstance5.getProperty("PendProcMode").getValue();
                    n2 = ((UnsignedInt8)cIMValue.getValue()).intValue();
                }
                catch (Throwable throwable) {
                    try {
                        HSCLogUtils.serverLog(throwable, HSCLogUtils._LPARClassLogInfo);
                    }
                    catch (Throwable throwable13) {
                        // empty catch block
                    }
                    throw new PIHscServerException("2523", new String[]{"R50Partition.PendProcMode"}, throwable);
                }
                processorTable.lparProcTypes.put(new UnsignedInt16(n3), cIMValue.getValue());
                int n13 = 0;
                try {
                    n13 = ((UnsignedInt8)cIMInstance5.getProperty("PartitionState").getValue().getValue()).intValue();
                }
                catch (Throwable throwable) {
                    try {
                        HSCLogUtils.serverLog(throwable, HSCLogUtils._LPARClassLogInfo);
                    }
                    catch (Throwable throwable14) {
                        // empty catch block
                    }
                    throw new PIHscServerException("2523", new String[]{"R50Partition.PartitionState"}, throwable);
                }
                LparProcValuePair lparProcValuePair = new LparProcValuePair();
                lparProcValuePair.lparID = n3;
                lparProcValuePair.ignoreVirProc = true;
                boolean bl3 = false;
                cIMInstance3 = new CIMObjectPath("IBMHSC_Partition", string);
                cIMInstance3.setKeys(cIMInstance5.getKeyValuePairs());
                object = PIClusterModifier.getLparClusterInfo((CIMOMHandle)providerCIMOMHandle, (CIMObjectPath)cIMInstance3);
                boolean bl4 = true;
                boolean bl5 = false;
                if (object != null) {
                    System.out.println("lparWlmInfo[0] = " + (int)object[0]);
                }
                if (object != null && PIClusterModifier.isUserDefinedCluster((int)object[0])) {
                    bl4 = false;
                }
                if (object != null && PIClusterModifier.isUserDefinedCluster(n5) && PIClusterModifier.inSameCluster((int)object[0], n5)) {
                    bl5 = true;
                    bl4 = false;
                }
                System.out.println("lparState = " + n13);
                System.out.println("accessibleLpars = " + vector3);
                System.out.println("noCluster = " + bl4);
                System.out.println("sameCluster = " + bl5);
                if (n13 != 0 || !vector4.contains(new UnsignedInt16(n3)) || !bl4 && !bl5) {
                    bl3 = true;
                }
                if (vector != null && vector.size() > 0 && vector.contains(new UnsignedInt16(n3))) {
                    bl3 = true;
                }
                System.out.println("unavailableLpar = " + bl3);
                if (255 == n2) {
                    try {
                        n11 = ((UnsignedInt16)cIMInstance5.getProperty("PendAllocProcs").getValue().getValue()).intValue();
                        lparProcValuePair.procAmount = n11 * 100;
                        if (bl3) {
                            l += lparProcValuePair.procAmount;
                            continue;
                        }
                        l3 += lparProcValuePair.procAmount;
                        try {
                            int n14 = ((UnsignedInt16)cIMInstance5.getProperty("PendMinProcs").getValue().getValue()).intValue();
                            lparProcValuePair.minProcAmount = n14 * 100;
                        }
                        catch (Throwable throwable) {
                            lparProcValuePair.minProcAmount = 0L;
                        }
                    }
                    catch (Throwable throwable) {
                        throw new PIHscServerException("2523", new String[]{"R50Partition.PendAllocProcs"}, throwable);
                    }
                } else {
                    n11 = 0;
                    try {
                        CIMValue cIMValue3 = cIMInstance5.getProperty("PendSharingMode").getValue();
                        n11 = ((UnsignedInt8)cIMValue3.getValue()).shortValue();
                    }
                    catch (Throwable throwable) {
                        try {
                            HSCLogUtils.serverLog(throwable, HSCLogUtils._LPARClassLogInfo);
                        }
                        catch (Throwable throwable15) {
                            // empty catch block
                        }
                        throw new PIHscServerException("2523", new String[]{"R50Partition.PendSharingMode"}, throwable);
                    }
                    if (n11 == 1) {
                        try {
                            lparProcValuePair.virProcAmount = ((UnsignedInt16)cIMInstance5.getProperty("PendAllocProcs").getValue().getValue()).intValue();
                            lparProcValuePair.procAmount = ((UnsignedInt32)cIMInstance5.getProperty("PendAllocProcUnits").getValue().getValue()).longValue();
                            if (bl3) {
                                n7 += lparProcValuePair.virProcAmount;
                                l += lparProcValuePair.procAmount;
                                l2 += lparProcValuePair.procAmount;
                                continue;
                            }
                            n8 += lparProcValuePair.virProcAmount;
                            l3 += lparProcValuePair.procAmount;
                            l4 += lparProcValuePair.procAmount;
                            try {
                                lparProcValuePair.minVirProcAmount = ((UnsignedInt16)cIMInstance5.getProperty("PendMinProcs").getValue().getValue()).intValue();
                                lparProcValuePair.minProcAmount = ((UnsignedInt32)cIMInstance5.getProperty("PendMinProcs").getValue().getValue()).longValue();
                            }
                            catch (Throwable throwable) {
                                lparProcValuePair.minProcAmount = 0L;
                                lparProcValuePair.minVirProcAmount = 0;
                            }
                        }
                        catch (Throwable throwable) {
                            throw new PIHscServerException("2523", new String[]{"R50Partition.PendAllocProcs"}, throwable);
                        }
                        if (bl4) {
                            vector7.add(lparProcValuePair);
                        } else if (bl5) {
                            vector8.add(lparProcValuePair);
                        }
                    } else {
                        try {
                            lparProcValuePair.procAmount = ((UnsignedInt32)cIMInstance5.getProperty("PendAllocProcUnits").getValue().getValue()).longValue();
                            if (bl3) {
                                l += lparProcValuePair.procAmount;
                                continue;
                            }
                            l3 += lparProcValuePair.procAmount;
                            try {
                                lparProcValuePair.minProcAmount = ((UnsignedInt32)cIMInstance5.getProperty("PendMinProcUnits").getValue().getValue()).longValue();
                                lparProcValuePair.minVirProcAmount = ((UnsignedInt16)cIMInstance5.getProperty("PendMinProcs").getValue().getValue()).intValue();
                            }
                            catch (Throwable throwable) {
                                lparProcValuePair.minProcAmount = 0L;
                                lparProcValuePair.minVirProcAmount = 0;
                            }
                        }
                        catch (Throwable throwable) {
                            throw new PIHscServerException("2523", new String[]{"R50Partition.PendAllocProcUnits"}, throwable);
                        }
                    }
                }
                if (bl4) {
                    vector5.add(lparProcValuePair);
                    continue;
                }
                if (!bl5) continue;
                vector6.add(lparProcValuePair);
            }
        }
        if (vector5 != null) {
            if (3 <= Trace.LEVEL) {
                Trace.trace("appahscD", "allIOOSLparsWithNoCluster =" + vector5);
            }
            processorTable.i5OSLparProcValPairsWithNoCluster = vector5.toArray(new LparProcValuePair[vector5.size()]);
        }
        if (vector6 != null) {
            if (3 <= Trace.LEVEL) {
                Trace.trace("appahscD", "allIOOSLparsWithSameCluster =" + vector6);
            }
            processorTable.i5OSLparProcValPairsWithSameCluster = vector6.toArray(new LparProcValuePair[vector6.size()]);
        }
        if (vector7 != null) {
            if (3 <= Trace.LEVEL) {
                Trace.trace("appahscD", "uncappedIOOSLparsWithNoCluster =" + vector7);
            }
            processorTable.uncappedI5OSLparProcValPairsWithNoCluster = vector7.toArray(new LparProcValuePair[vector7.size()]);
        }
        if (vector8 != null) {
            if (3 <= Trace.LEVEL) {
                Trace.trace("appahscD", "uncappedIOOSLparsWithSameCluster =" + vector8);
            }
            processorTable.uncappedI5OSLparProcValPairsWithSameCluster = vector8.toArray(new LparProcValuePair[vector8.size()]);
        }
        processorTable.unavailI5OSProcUnits = new UnsignedInt32(l);
        processorTable.uncappedUnavailI5OSProcUnits = new UnsignedInt32(l2);
        processorTable.unavailI5OSVirProcs = new UnsignedInt16(n7);
        processorTable.allocI5OSProcUnits = new UnsignedInt32(l3);
        processorTable.uncappedAllocI5OSProcUnits = new UnsignedInt32(l4);
        processorTable.allocI5OSVirProcs = new UnsignedInt16(n8);
        Trace.trace("appahscT", "PIResourcesAllocationUtils.getI5OSCPU <-");
        return processorTable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AllocProcAndLparInfo checkVirProcsToSteal(int n, int n2, int n3, LparProcValuePair[] lparProcValuePairArray, ProviderCIMOMHandle providerCIMOMHandle, boolean bl) throws PIHscServerException {
        Trace.trace("appahscT", "-> PIResourcesAllocationUtils.checkProcsToSteal");
        Trace.trace("appahscF", "lparID = " + n);
        Trace.trace("appahscF", "amountNeeded = " + n2);
        Trace.trace("appahscF", "procMode = " + n3);
        Trace.trace("appahscF", "lparProcPairList = " + lparProcValuePairArray);
        Trace.trace("appahscF", "cimHandle = " + providerCIMOMHandle);
        System.out.println("checkProcsToSteal ->");
        try {
            Arrays.sort(lparProcValuePairArray, new PIVirProcComparator());
            System.out.println("checkProcsToSteal -> lparProcPairList = " + lparProcValuePairArray);
            LparProcValuePair[] lparProcValuePairArray2 = new LparProcValuePair[lparProcValuePairArray.length];
            int n4 = 0;
            int n5 = lparProcValuePairArray.length;
            int n6 = 0;
            int n7 = 0;
            HashSet<UnsignedInt16> hashSet = new HashSet<UnsignedInt16>();
            AllocProcAndLparInfo allocProcAndLparInfo = new AllocProcAndLparInfo();
            allocProcAndLparInfo.lparProcSettings = new Hashtable();
            boolean bl2 = false;
            boolean bl3 = true;
            while (n5 > 0 && !bl2) {
                for (n4 = 0; n4 < n5; ++n4) {
                    if (bl3) {
                        lparProcValuePairArray2[n4] = new LparProcValuePair();
                        lparProcValuePairArray2[n4].ignoreVirProc = true;
                        lparProcValuePairArray2[n4].virProcAmount = lparProcValuePairArray[n4].minVirProcAmount;
                        lparProcValuePairArray2[n4].lparID = lparProcValuePairArray[n4].lparID;
                    }
                    n7 = n6 + (lparProcValuePairArray[n4].virProcAmount - lparProcValuePairArray[n4].minVirProcAmount);
                    if (2 <= Trace.LEVEL) {
                        Trace.trace("appahscF", "tempProcAdder = " + String.valueOf(n7));
                    }
                    if (n7 < n2) continue;
                    hashSet.add(new UnsignedInt16(lparProcValuePairArray[n4].lparID));
                    allocProcAndLparInfo.lparProcSettings.put(new UnsignedInt16(lparProcValuePairArray[n4].lparID), new UnsignedInt32((long)(lparProcValuePairArray[n4].minVirProcAmount + (n7 - n2))));
                    n6 = n2;
                    bl2 = true;
                    break;
                }
                bl3 = false;
                if (bl2) continue;
                n6 = n7;
                hashSet.add(new UnsignedInt16(lparProcValuePairArray[--n4].lparID));
                allocProcAndLparInfo.lparProcSettings.put(new UnsignedInt16(lparProcValuePairArray[n4].lparID), new UnsignedInt32((long)lparProcValuePairArray[n4].minVirProcAmount));
                System.out.println("checkProcsToSteal -> still not enough. size = " + --n5);
            }
            if (bl2 || bl) {
                allocProcAndLparInfo.allocatedProc = new UnsignedInt16(n6);
                if (hashSet != null) {
                    if (3 <= Trace.LEVEL) {
                        Trace.trace("appahscD", "invalidLpars =" + hashSet);
                    }
                    allocProcAndLparInfo.lparIDs = hashSet.toArray(new UnsignedInt16[hashSet.size()]);
                }
                System.out.println("checkProcsToSteal -> retVal = " + allocProcAndLparInfo);
                AllocProcAndLparInfo allocProcAndLparInfo2 = allocProcAndLparInfo;
                return allocProcAndLparInfo2;
            }
            Arrays.sort(lparProcValuePairArray2, new PIVirProcComparator());
            System.out.println("checkProcsToSteal -> lparProcPairList = " + lparProcValuePairArray2);
            n4 = 0;
            n5 = lparProcValuePairArray2.length;
            while (n5 > 0 && !bl2) {
                for (n4 = 0; n4 < n5; ++n4) {
                    n7 = n6 + lparProcValuePairArray2[n4].virProcAmount;
                    if (2 <= Trace.LEVEL) {
                        Trace.trace("appahscF", "tempProcAdder = " + String.valueOf(n7));
                    }
                    if (n7 < n2) continue;
                    hashSet.add(new UnsignedInt16(lparProcValuePairArray2[n4].lparID));
                    allocProcAndLparInfo.lparProcSettings.put(new UnsignedInt16(lparProcValuePairArray2[n4].lparID), new UnsignedInt32(0L));
                    n6 = n2;
                    bl2 = true;
                    break;
                }
                if (bl2) continue;
                n6 = n7;
                hashSet.add(new UnsignedInt16(lparProcValuePairArray2[--n4].lparID));
                allocProcAndLparInfo.lparProcSettings.put(new UnsignedInt16(lparProcValuePairArray2[n4].lparID), new UnsignedInt32(0L));
                System.out.println("checkProcsToSteal -> still not enough. size = " + --n5);
            }
            allocProcAndLparInfo.allocatedProc = new UnsignedInt16(n6);
            if (hashSet != null) {
                if (3 <= Trace.LEVEL) {
                    Trace.trace("appahscD", "invalidLpars =" + hashSet);
                }
                allocProcAndLparInfo.lparIDs = hashSet.toArray(new UnsignedInt16[hashSet.size()]);
            }
            System.out.println("checkProcsToSteal -> retVal = " + allocProcAndLparInfo);
            AllocProcAndLparInfo allocProcAndLparInfo3 = allocProcAndLparInfo;
            return allocProcAndLparInfo3;
        }
        finally {
            if (1 <= Trace.LEVEL) {
                Trace.trace("appahscT", "<- checkProcsToSteal");
            }
        }
    }

    public static AllocProcAndLparInfo checkProcsToSteal(int n, long l, int n2, LparProcValuePair[] lparProcValuePairArray, ProviderCIMOMHandle providerCIMOMHandle, boolean bl) throws PIHscServerException {
        return PIResourcesAllocationUtils.checkProcsToSteal(n, l, n2, lparProcValuePairArray, providerCIMOMHandle, bl, false, null);
    }

    public static boolean isI5OSUncapped(int n, OmCecMgr omCecMgr) {
        OmLparMgr omLparMgr = null;
        try {
            omLparMgr = omCecMgr.getLparMgr(n + "*" + omCecMgr.getCecName());
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        RObject rObject = null;
        try {
            rObject = omLparMgr.getObject();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        if (rObject == null) {
            return false;
        }
        int n2 = 255;
        int n3 = 0;
        int n4 = 0;
        try {
            n4 = ((UnsignedInt8)rObject.getProperty("DefinitionState")).intValue();
            n2 = ((UnsignedInt8)rObject.getProperty("PendProcMode")).intValue();
            n3 = ((UnsignedInt8)rObject.getProperty("PendSharingMode")).intValue();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        System.out.println("defState = " + n4);
        System.out.println("procMode = " + n2);
        System.out.println("sharingMode = " + n3);
        return (n4 == 130 || n4 == 129) && n2 != 255 && n3 == 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AllocProcAndLparInfo checkProcsToSteal(int n, long l, int n2, LparProcValuePair[] lparProcValuePairArray, ProviderCIMOMHandle providerCIMOMHandle, boolean bl, boolean bl2, OmCecMgr omCecMgr) throws PIHscServerException {
        Trace.trace("appahscT", "-> PIResourcesAllocationUtils.checkProcsToSteal");
        Trace.trace("appahscF", "lparID = " + n);
        Trace.trace("appahscF", "amountNeeded = " + l);
        Trace.trace("appahscF", "procMode = " + n2);
        Trace.trace("appahscF", "lparProcPairList = " + lparProcValuePairArray);
        Trace.trace("appahscF", "cimHandle = " + providerCIMOMHandle);
        System.out.println("checkProcsToSteal ->");
        try {
            Arrays.sort(lparProcValuePairArray, new PIProcComparator());
            System.out.println("checkProcsToSteal -> lparProcPairList = " + lparProcValuePairArray);
            LparProcValuePair[] lparProcValuePairArray2 = new LparProcValuePair[lparProcValuePairArray.length];
            int n3 = 0;
            int n4 = lparProcValuePairArray.length;
            long l2 = 0L;
            long l3 = 0L;
            HashSet<UnsignedInt16> hashSet = new HashSet<UnsignedInt16>();
            AllocProcAndLparInfo allocProcAndLparInfo = new AllocProcAndLparInfo();
            allocProcAndLparInfo.lparProcSettings = new Hashtable();
            boolean bl3 = false;
            boolean bl4 = true;
            while (n4 > 0 && !bl3) {
                boolean bl5 = false;
                for (n3 = 0; n3 < n4; ++n3) {
                    bl5 = false;
                    bl5 = bl2 ? PIResourcesAllocationUtils.isI5OSUncapped(lparProcValuePairArray[n3].lparID, omCecMgr) : false;
                    System.out.println("lparID = " + lparProcValuePairArray[n3].lparID);
                    System.out.println("isI5OSUncapped = " + bl5);
                    if (bl4) {
                        lparProcValuePairArray2[n3] = new LparProcValuePair();
                        lparProcValuePairArray2[n3].procAmount = lparProcValuePairArray[n3].minProcAmount;
                        lparProcValuePairArray2[n3].lparID = lparProcValuePairArray[n3].lparID;
                    }
                    l3 = l2 + (lparProcValuePairArray[n3].procAmount - lparProcValuePairArray[n3].minProcAmount);
                    if (2 <= Trace.LEVEL) {
                        Trace.trace("appahscF", "tempProcAdder = " + String.valueOf(l3));
                    }
                    if (l3 < l) continue;
                    if (bl5) {
                        long l4 = lparProcValuePairArray[n3].minProcAmount + (l3 - l);
                        int n5 = (int)(l4 / 100L);
                        int n6 = lparProcValuePairArray[n3].minVirProcAmount;
                        if (n5 < n6 || (long)(n5 * 100) < lparProcValuePairArray[n3].minProcAmount) continue;
                        if (l4 > (long)(n5 * 100)) {
                            l4 = n5 * 100;
                        }
                        allocProcAndLparInfo.lparProcSettings.put(new UnsignedInt16(lparProcValuePairArray[n3].lparID), new UnsignedInt32(l4));
                    }
                    hashSet.add(new UnsignedInt16(lparProcValuePairArray[n3].lparID));
                    if (!bl5) {
                        allocProcAndLparInfo.lparProcSettings.put(new UnsignedInt16(lparProcValuePairArray[n3].lparID), new UnsignedInt32(lparProcValuePairArray[n3].minProcAmount + (l3 - l)));
                    }
                    l2 = l;
                    bl3 = true;
                    break;
                }
                bl4 = false;
                if (bl3) continue;
                if (!bl5) {
                    l2 = l3;
                    hashSet.add(new UnsignedInt16(lparProcValuePairArray[--n3].lparID));
                    allocProcAndLparInfo.lparProcSettings.put(new UnsignedInt16(lparProcValuePairArray[n3].lparID), new UnsignedInt32(lparProcValuePairArray[n3].minProcAmount));
                }
                System.out.println("checkProcsToSteal -> still not enough. size = " + --n4);
            }
            if (bl3 || bl) {
                allocProcAndLparInfo.allocatedProcUnits = new UnsignedInt32(l2);
                if (hashSet != null) {
                    if (3 <= Trace.LEVEL) {
                        Trace.trace("appahscD", "invalidLpars =" + hashSet);
                    }
                    allocProcAndLparInfo.lparIDs = hashSet.toArray(new UnsignedInt16[hashSet.size()]);
                }
                System.out.println("checkProcsToSteal -> retVal = " + allocProcAndLparInfo);
                AllocProcAndLparInfo allocProcAndLparInfo2 = allocProcAndLparInfo;
                return allocProcAndLparInfo2;
            }
            Arrays.sort(lparProcValuePairArray2, new PIProcComparator());
            System.out.println("checkProcsToSteal -> lparProcPairList = " + lparProcValuePairArray2);
            n3 = 0;
            n4 = lparProcValuePairArray2.length;
            while (n4 > 0 && !bl3) {
                for (n3 = 0; n3 < n4; ++n3) {
                    l3 = l2 + lparProcValuePairArray2[n3].procAmount;
                    if (2 <= Trace.LEVEL) {
                        Trace.trace("appahscF", "tempProcAdder = " + String.valueOf(l3));
                    }
                    if (l3 < l) continue;
                    hashSet.add(new UnsignedInt16(lparProcValuePairArray2[n3].lparID));
                    allocProcAndLparInfo.lparProcSettings.put(new UnsignedInt16(lparProcValuePairArray2[n3].lparID), new UnsignedInt32(0L));
                    l2 = l;
                    bl3 = true;
                    break;
                }
                if (bl3) continue;
                l2 = l3;
                hashSet.add(new UnsignedInt16(lparProcValuePairArray2[--n3].lparID));
                allocProcAndLparInfo.lparProcSettings.put(new UnsignedInt16(lparProcValuePairArray2[n3].lparID), new UnsignedInt32(0L));
                System.out.println("checkProcsToSteal -> still not enough. size = " + --n4);
            }
            allocProcAndLparInfo.allocatedProcUnits = new UnsignedInt32(l2);
            if (hashSet != null) {
                if (3 <= Trace.LEVEL) {
                    Trace.trace("appahscD", "invalidLpars =" + hashSet);
                }
                allocProcAndLparInfo.lparIDs = hashSet.toArray(new UnsignedInt16[hashSet.size()]);
            }
            System.out.println("checkProcsToSteal -> retVal = " + allocProcAndLparInfo);
            AllocProcAndLparInfo allocProcAndLparInfo3 = allocProcAndLparInfo;
            return allocProcAndLparInfo3;
        }
        finally {
            if (1 <= Trace.LEVEL) {
                Trace.trace("appahscT", "<- checkProcsToSteal");
            }
        }
    }

    public static UnsignedInt16 checkInterPerfForAlloc(UnsignedInt16 unsignedInt16, UnsignedInt16 unsignedInt162, UnsignedInt16 unsignedInt163, UnsignedInt32 unsignedInt32, CIMObjectPath cIMObjectPath, String string, ProviderCIMOMHandle providerCIMOMHandle) throws PIHscServerException {
        return PIResourcesAllocationUtils.checkInterPerfForAlloc(unsignedInt16, unsignedInt162, unsignedInt163, unsignedInt32, cIMObjectPath, string, providerCIMOMHandle, null);
    }

    public static UnsignedInt16 checkInterPerfForAlloc(UnsignedInt16 unsignedInt16, UnsignedInt16 unsignedInt162, UnsignedInt16 unsignedInt163, UnsignedInt32 unsignedInt32, CIMObjectPath cIMObjectPath, String string, ProviderCIMOMHandle providerCIMOMHandle, Vector vector) throws PIHscServerException {
        Trace.trace("appahscT", "-> PIResourcesAllocationUtils.checkInterPerfForAlloc");
        Trace.trace("appahscF", "requiredInterPerf = " + unsignedInt16);
        Trace.trace("appahscF", "desiredInterPerf = " + unsignedInt162);
        Trace.trace("appahscF", "maxInterPerf = " + unsignedInt163);
        Trace.trace("appahscF", "procUnits = " + unsignedInt32);
        Trace.trace("appahscF", "lparPath = " + cIMObjectPath);
        Trace.trace("appahscF", "cecName = " + string);
        Trace.trace("appahscF", "cimHandle = " + providerCIMOMHandle);
        String string2 = cIMObjectPath.getNameSpace();
        OmCecMgr omCecMgr = OmCecMgr.getCecMgr(string);
        FspCmdHelper fspCmdHelper = omCecMgr.getCmdHelper();
        try {
            FspISeriesPerfRanges fspISeriesPerfRanges;
            try {
                fspISeriesPerfRanges = fspCmdHelper.getLparValidPerformanceRanges(unsignedInt32);
            }
            catch (PIHscCmdMgrException pIHscCmdMgrException) {
                try {
                    HSCLogUtils.serverLog(pIHscCmdMgrException, HSCLogUtils._LPARClassLogInfo);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                throw new PIHscServerException("0401", pIHscCmdMgrException);
            }
            int n = fspISeriesPerfRanges.getMinIntPerf().intValue();
            int n2 = fspISeriesPerfRanges.getMaxIntPerf().intValue();
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            try {
                n3 = unsignedInt16.intValue();
                n4 = unsignedInt162.intValue();
                n5 = unsignedInt163.intValue();
            }
            catch (NullPointerException nullPointerException) {
                try {
                    HSCLogUtils.serverLog(nullPointerException, HSCLogUtils._LPARClassLogInfo);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                UnsignedInt16 unsignedInt164 = new UnsignedInt16(0);
                Trace.trace("appahscT", "PIResourcesAllocationUtils.checkInterPerfForAlloc <-");
                return unsignedInt164;
            }
            if (n3 > n4 || n3 > n5) {
                System.out.println("ERROR: required interactive performance is greater than desired or max amount");
                throw new PIHscServerException("07DE", null);
            }
            if (n4 > n5) {
                System.out.println("ERROR: desired interactive performance is greater than max amount");
                throw new PIHscServerException("07DE", null);
            }
            CIMInstance cIMInstance = CimomWrapper.getInstance((CIMOMHandle)providerCIMOMHandle, cIMObjectPath, providerCIMOMHandle.getClass(cIMObjectPath, false), false);
            if (3 <= Trace.LEVEL) {
                Trace.trace("appahscD", "lparInst =" + cIMInstance);
            }
            CIMValue cIMValue = cIMInstance.getProperty("PendAllocInteractivePerf").getValue();
            int n6 = 0;
            if (cIMValue != null) {
                n6 = ((UnsignedInt16)cIMValue.getValue()).intValue();
            }
            int n7 = PIResourcesAllocationUtils.totalInterPerfAllocated(string, providerCIMOMHandle, string2);
            if (3 <= Trace.LEVEL) {
                Trace.trace("appahscD", "totalPerf =" + n7);
            }
            if (n4 >= n && n4 <= n2 && (n7 -= n6) + n4 <= 10000) {
                UnsignedInt16 unsignedInt165 = unsignedInt162;
                return unsignedInt165;
            }
            long l = 10000L;
            int n8 = (int)l - n7;
            if (3 <= Trace.LEVEL) {
                Trace.trace("appahscD", "allowedAmount =" + n8);
            }
            if (n4 > n2) {
                if (n2 >= n3) {
                    if (n8 >= n2) {
                        UnsignedInt16 unsignedInt166 = new UnsignedInt16(n2);
                        return unsignedInt166;
                    }
                    if (n8 >= n3) {
                        UnsignedInt16 unsignedInt167 = new UnsignedInt16(n8);
                        return unsignedInt167;
                    }
                    throw new PIHscServerException("03F6", new String[]{Double.toString((double)n8 / 100.0)}, null);
                }
                System.out.println("ERROR: cannot obtain value within the valid range");
                throw new PIHscServerException("03F7", new String[]{Double.toString((double)n2 / 100.0), Double.toString((double)n3 / 100.0)}, null);
            }
            if (n4 < n) {
                throw new PIHscServerException("03F8", new String[]{Double.toString((double)n / 100.0)}, null);
            }
            if (n4 > n8) {
                if (n8 >= n3) {
                    UnsignedInt16 unsignedInt168 = new UnsignedInt16(n8);
                    return unsignedInt168;
                }
                throw new PIHscServerException("03F6", new String[]{Double.toString((double)n8 / 100.0)}, null);
            }
            UnsignedInt16 unsignedInt169 = unsignedInt162;
            return unsignedInt169;
        }
        catch (Throwable throwable) {
            try {
                HSCLogUtils.serverLog(throwable, HSCLogUtils._LPARClassLogInfo);
            }
            catch (Throwable throwable2) {
                // empty catch block
            }
            throwable.printStackTrace();
            if (!(throwable instanceof PIHscServerException)) {
                throw new PIHscServerException("0616", null);
            }
            throw (PIHscServerException)throwable;
        }
        finally {
            Trace.trace("appahscT", "PIResourcesAllocationUtils.checkInterPerfForAlloc <-");
        }
    }

    public static int totalInterPerfAllocated(String string, ProviderCIMOMHandle providerCIMOMHandle, String string2) throws PIHscServerException {
        Trace.trace("appahscT", "-> PIResourcesAllocationUtils.totalInterPerfAllocated");
        Trace.trace("appahscF", "cecName = " + string);
        Trace.trace("appahscF", "cimHandle = " + providerCIMOMHandle);
        Trace.trace("appahscF", "namespace = " + string2);
        CIMObjectPath cIMObjectPath = PIResourcesAllocationUtils.constructCecPath(string, string2);
        Vector vector = null;
        try {
            vector = CimomWrapper.associators((CIMOMHandle)providerCIMOMHandle, new CIMObjectPath("IBMHSC_CompSysPartition", string2), cIMObjectPath, "IBMHSC_Partition", "GroupComponent", "PartComponent", false, false, null);
        }
        catch (Throwable throwable) {
            try {
                HSCLogUtils.serverLog(throwable, HSCLogUtils._LPARClassLogInfo);
            }
            catch (Throwable throwable2) {
                // empty catch block
            }
            vector = null;
        }
        int n = 0;
        if (vector != null) {
            if (3 <= Trace.LEVEL) {
                Trace.trace("appahscD", "lpars  =" + vector);
            }
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                CIMValue cIMValue;
                CIMInstance cIMInstance = (CIMInstance)enumeration.nextElement();
                CIMObjectPath cIMObjectPath2 = new CIMObjectPath("IBMHSC_Partition", string2);
                cIMObjectPath2.addKey("Name", cIMInstance.getProperty("Name").getValue());
                cIMObjectPath2.addKey("CreationClassName", cIMInstance.getProperty("CreationClassName").getValue());
                int n2 = 0;
                try {
                    n2 = ((UnsignedInt8)cIMInstance.getProperty("PartitionState").getValue().getValue()).intValue();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                boolean bl = PIHmcAccessUtils.checkCurrObjAccess(cIMObjectPath2, "start");
                if (n2 == 0 && bl || (cIMValue = cIMInstance.getProperty("PendAllocInteractivePerf").getValue()) == null) continue;
                n += ((UnsignedInt16)cIMValue.getValue()).intValue();
            }
        }
        Trace.trace("appahscT", "PIResourcesAllocationUtils.totalInterPerfAllocated <-");
        return n;
    }

    public static MemoryTable getLparMemInfo(int n, String string, ProviderCIMOMHandle providerCIMOMHandle, String string2, int n2) throws PIHscServerException {
        return PIResourcesAllocationUtils.getLparMemInfo(n, string, providerCIMOMHandle, string2, n2, null);
    }

    public static MemoryTable getLparMemInfo(int n, String string, ProviderCIMOMHandle providerCIMOMHandle, String string2, int n2, Vector vector) throws PIHscServerException {
        Trace.trace("appahscT", "-> PIResourcesAllocationUtils.getLparMemInfo");
        Trace.trace("appahscF", "actLparID = " + n);
        Trace.trace("appahscF", "cecName = " + string);
        Trace.trace("appahscF", "cimHandle = " + providerCIMOMHandle);
        Trace.trace("appahscF", "namespace = " + string2);
        MemoryTable memoryTable = new MemoryTable();
        long l = 0L;
        Vector vector2 = new Vector();
        Vector<LparMemValuePair> vector3 = new Vector<LparMemValuePair>();
        Object var11_10 = null;
        CIMObjectPath cIMObjectPath = PIResourcesAllocationUtils.constructCecPath(string, string2);
        Vector vector4 = null;
        try {
            vector4 = PIHmcAccessUtils.getLparObjWithAuthFromCec(cIMObjectPath, "ActivateLparProfile", providerCIMOMHandle, false);
        }
        catch (Throwable throwable) {
            vector4 = null;
        }
        if (null != vector4 && vector4.size() > 0) {
            if (3 <= Trace.LEVEL) {
                Trace.trace("appahscD", "lpars =" + vector4);
            }
            Enumeration enumeration = vector4.elements();
            while (enumeration.hasMoreElements()) {
                long l2;
                long l3;
                int n3;
                CIMInstance cIMInstance = (CIMInstance)enumeration.nextElement();
                String string3 = "";
                try {
                    string3 = (String)cIMInstance.getProperty("Name").getValue().getValue();
                }
                catch (Throwable throwable) {
                    try {
                        HSCLogUtils.serverLog(throwable, HSCLogUtils._LPARClassLogInfo);
                    }
                    catch (Throwable throwable2) {
                        // empty catch block
                    }
                    throw new PIHscServerException("2523", new String[]{"R50Partition.Name"}, throwable);
                }
                int[] nArray = null;
                try {
                    CIMObjectPath cIMObjectPath2 = new CIMObjectPath("IBMHSC_Partition", string2);
                    cIMObjectPath2.setKeys(cIMInstance.getKeyValuePairs());
                    nArray = PIClusterModifier.getLparClusterInfo((CIMOMHandle)providerCIMOMHandle, cIMObjectPath2);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                if (nArray == null && PIClusterModifier.isUserDefinedCluster(n2) || !PIClusterModifier.inSameCluster((int)nArray[0], n2) || (n3 = Integer.parseInt(string3.substring(0, string3.indexOf(42)))) == n) continue;
                int n4 = 0;
                try {
                    n4 = ((UnsignedInt8)cIMInstance.getProperty("DefinitionState").getValue().getValue()).intValue();
                }
                catch (Throwable throwable) {
                    try {
                        HSCLogUtils.serverLog(throwable, HSCLogUtils._LPARClassLogInfo);
                    }
                    catch (Throwable throwable3) {
                        // empty catch block
                    }
                    throw new PIHscServerException("2523", new String[]{"R50Partition.DefinitionState"}, throwable);
                }
                if (vector != null && vector.size() > 0 && vector.contains(new UnsignedInt16(n3))) continue;
                int n5 = 0;
                try {
                    n5 = ((UnsignedInt8)cIMInstance.getProperty("PartitionState").getValue().getValue()).intValue();
                }
                catch (Throwable throwable) {
                    try {
                        HSCLogUtils.serverLog(throwable, HSCLogUtils._LPARClassLogInfo);
                    }
                    catch (Throwable throwable4) {
                        // empty catch block
                    }
                    throw new PIHscServerException("2523", new String[]{"R50Partition.PartitionState"}, throwable);
                }
                if (0 != n5) continue;
                LparMemValuePair lparMemValuePair = new LparMemValuePair();
                lparMemValuePair.lparID = n3;
                CIMValue cIMValue = cIMInstance.getProperty("CurAllocMem").getValue();
                CIMValue cIMValue2 = cIMInstance.getProperty("Reserve1CurAllocMem").getValue();
                CIMValue cIMValue3 = cIMInstance.getProperty("Reserve2CurAllocMem").getValue();
                CIMValue cIMValue4 = cIMInstance.getProperty("PendAllocMem").getValue();
                CIMValue cIMValue5 = cIMInstance.getProperty("PendMinMem").getValue();
                CIMValue cIMValue6 = cIMInstance.getProperty("Reserve1PendAllocMem").getValue();
                CIMValue cIMValue7 = cIMInstance.getProperty("Reserve2PendAllocMem").getValue();
                if (cIMValue4 != null) {
                    l3 = 0L;
                    l2 = 0L;
                    try {
                        l3 = ((UnsignedInt32)cIMValue.getValue()).longValue();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    lparMemValuePair.memAmount = l2 = ((UnsignedInt32)cIMValue4.getValue()).longValue();
                }
                if (cIMValue5 != null) {
                    lparMemValuePair.minMemAmount = ((UnsignedInt32)cIMValue5.getValue()).longValue();
                }
                if (cIMValue6 != null) {
                    l3 = 0L;
                    l2 = 0L;
                    try {
                        l3 = ((UnsignedInt32)cIMValue2.getValue()).longValue();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    l2 = ((UnsignedInt32)cIMValue6.getValue()).longValue();
                    lparMemValuePair.memAmount += l2;
                }
                if (cIMValue7 != null) {
                    l3 = 0L;
                    l2 = 0L;
                    try {
                        l3 = ((UnsignedInt32)cIMValue3.getValue()).longValue();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    l2 = ((UnsignedInt32)cIMValue7.getValue()).longValue();
                    lparMemValuePair.memAmount += l2;
                }
                if (3 <= Trace.LEVEL) {
                    Trace.trace("appahscD", "valPair =" + lparMemValuePair);
                }
                vector3.add(lparMemValuePair);
            }
        }
        memoryTable.memForNotBootableLpar = new UnsignedInt32(l);
        if (vector2 != null) {
            if (3 <= Trace.LEVEL) {
                Trace.trace("appahscD", "notBootableLpars =" + vector2);
            }
            memoryTable.notBootableLpars = vector2.toArray(new UnsignedInt16[0]);
        }
        if (vector3 != null) {
            memoryTable.lparMemValPairs = vector3.toArray(new LparMemValuePair[0]);
        }
        Trace.trace("appahscT", "PIResourcesAllocationUtils.getLparMemInfo <-");
        return memoryTable;
    }

    public static AllocMemAndLparInfo checkMemForAlloc(UnsignedInt32 unsignedInt32, UnsignedInt32 unsignedInt322, UnsignedInt32 unsignedInt323, UnsignedInt32 unsignedInt324, UnsignedInt32 unsignedInt325, UnsignedInt32 unsignedInt326, UnsignedInt32 unsignedInt327, UnsignedInt32 unsignedInt328, UnsignedInt32 unsignedInt329, CIMObjectPath cIMObjectPath, String string, ProviderCIMOMHandle providerCIMOMHandle, boolean bl) throws PIHscServerException {
        return PIResourcesAllocationUtils.checkMemForAlloc(unsignedInt32, unsignedInt322, unsignedInt323, unsignedInt324, unsignedInt325, unsignedInt326, unsignedInt327, unsignedInt328, unsignedInt329, cIMObjectPath, string, providerCIMOMHandle, bl, (UnsignedInt8)null);
    }

    public static AllocMemAndLparInfo checkMemForAlloc(UnsignedInt32 unsignedInt32, UnsignedInt32 unsignedInt322, UnsignedInt32 unsignedInt323, UnsignedInt32 unsignedInt324, UnsignedInt32 unsignedInt325, UnsignedInt32 unsignedInt326, UnsignedInt32 unsignedInt327, UnsignedInt32 unsignedInt328, UnsignedInt32 unsignedInt329, CIMObjectPath cIMObjectPath, String string, ProviderCIMOMHandle providerCIMOMHandle, boolean bl, Vector vector) throws PIHscServerException {
        return PIResourcesAllocationUtils.checkMemForAlloc(unsignedInt32, unsignedInt322, unsignedInt323, unsignedInt324, unsignedInt325, unsignedInt326, unsignedInt327, unsignedInt328, unsignedInt329, cIMObjectPath, string, providerCIMOMHandle, bl, null, vector);
    }

    public static AllocMemAndLparInfo checkMemForAlloc(UnsignedInt32 unsignedInt32, UnsignedInt32 unsignedInt322, UnsignedInt32 unsignedInt323, UnsignedInt32 unsignedInt324, UnsignedInt32 unsignedInt325, UnsignedInt32 unsignedInt326, UnsignedInt32 unsignedInt327, UnsignedInt32 unsignedInt328, UnsignedInt32 unsignedInt329, CIMObjectPath cIMObjectPath, String string, ProviderCIMOMHandle providerCIMOMHandle, boolean bl, UnsignedInt8 unsignedInt8) throws PIHscServerException {
        return PIResourcesAllocationUtils.checkMemForAlloc(unsignedInt32, unsignedInt322, unsignedInt323, unsignedInt324, unsignedInt325, unsignedInt326, unsignedInt327, unsignedInt328, unsignedInt329, cIMObjectPath, string, providerCIMOMHandle, bl, unsignedInt8, null);
    }

    public static AllocMemAndLparInfo checkMemForAlloc(UnsignedInt32 unsignedInt32, UnsignedInt32 unsignedInt322, UnsignedInt32 unsignedInt323, UnsignedInt32 unsignedInt324, UnsignedInt32 unsignedInt325, UnsignedInt32 unsignedInt326, UnsignedInt32 unsignedInt327, UnsignedInt32 unsignedInt328, UnsignedInt32 unsignedInt329, CIMObjectPath cIMObjectPath, String string, ProviderCIMOMHandle providerCIMOMHandle, boolean bl, UnsignedInt8 unsignedInt8, Vector vector) throws PIHscServerException {
        System.out.println("PIResourcesAllocationUtils - checkMemForAlloc ->");
        Trace.trace("appahscT", "-> PIResourcesAllocationUtils.checkMemForAlloc");
        Trace.trace("appahscF", "requiredAmount = " + unsignedInt32);
        Trace.trace("appahscF", "desiredAmount = " + unsignedInt322);
        Trace.trace("appahscF", "userDefMaxAmount = " + unsignedInt323);
        Trace.trace("appahscF", "res1RequiredAmount = " + unsignedInt324);
        Trace.trace("appahscF", "res1DesiredAmount = " + unsignedInt325);
        Trace.trace("appahscF", "res1UserDefMaxAmount = " + unsignedInt326);
        Trace.trace("appahscF", "res2RequiredAmount = " + unsignedInt324);
        Trace.trace("appahscF", "res2DesiredAmount = " + unsignedInt325);
        Trace.trace("appahscF", "res2UserDefMaxAmount = " + unsignedInt326);
        Trace.trace("appahscF", "lparPath = " + cIMObjectPath);
        Trace.trace("appahscF", "cecName = " + string);
        Trace.trace("appahscF", "cimHandle = " + providerCIMOMHandle);
        Trace.trace("appahscF", "isMegaMouth = " + bl);
        CIMObjectPath cIMObjectPath2 = null;
        CIMInstance cIMInstance = null;
        CIMInstance cIMInstance2 = null;
        int n = -1;
        long l = 0L;
        int n2 = 0;
        long l2 = 0L;
        long l3 = 0L;
        long l4 = 0L;
        long l5 = 0L;
        long l6 = 0L;
        long l7 = 0L;
        long l8 = 0L;
        long l9 = 0L;
        long l10 = 0L;
        long l11 = 0L;
        long l12 = 0L;
        long l13 = 0L;
        long l14 = 0L;
        String string2 = cIMObjectPath.getNameSpace();
        AllocMemAndLparInfo allocMemAndLparInfo = new AllocMemAndLparInfo();
        OmCecMgr omCecMgr = OmCecMgr.getCecMgr(string);
        if (unsignedInt8 == null) {
            unsignedInt8 = omCecMgr.getRecommandedHptRatio();
        }
        try {
            Object object;
            Object object2;
            CIMValue cIMValue;
            long l15;
            long l16;
            long l17;
            cIMObjectPath2 = PIResourcesAllocationUtils.constructCecPath(string, string2);
            try {
                cIMInstance = CimomWrapper.getInstance((CIMOMHandle)providerCIMOMHandle, cIMObjectPath2, providerCIMOMHandle.getClass(cIMObjectPath2, false), false);
            }
            catch (CIMException cIMException) {
                try {
                    HSCLogUtils.serverLog(cIMException, HSCLogUtils._LPARClassLogInfo);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                cIMInstance = null;
            }
            if (cIMInstance == null) {
                throw new PIHscServerException("0228", null);
            }
            if (3 <= Trace.LEVEL) {
                Trace.trace("appahscD", "cecInstance =" + cIMInstance);
            }
            try {
                cIMInstance2 = CimomWrapper.getInstance((CIMOMHandle)providerCIMOMHandle, cIMObjectPath, providerCIMOMHandle.getClass(cIMObjectPath, false), false);
            }
            catch (CIMException cIMException) {
                try {
                    HSCLogUtils.serverLog(cIMException, HSCLogUtils._LPARClassLogInfo);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                cIMInstance2 = null;
            }
            if (cIMInstance2 == null) {
                throw new PIHscServerException("2916", null);
            }
            if (3 <= Trace.LEVEL) {
                Trace.trace("appahscD", "lparInstance =" + cIMInstance2);
            }
            String string3 = "";
            try {
                string3 = (String)cIMInstance2.getProperty("Name").getValue().getValue();
            }
            catch (Throwable throwable) {
                throw new PIHscServerException("2523", new String[]{"R50Partition.Name"}, throwable);
            }
            n = Integer.parseInt(string3.substring(0, string3.indexOf(42)));
            boolean bl2 = PIResourcesAllocationUtils.totalPendingOverConfigured(omCecMgr, false);
            OmLparMgr omLparMgr = null;
            try {
                omLparMgr = omCecMgr.getLparMgr(string3);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            if (bl2) {
                PIResourcesAllocationUtils.syncPendMemToCur(omCecMgr, omLparMgr);
                PIResourcesAllocationUtils.syncAllAccessiblePendResToCur(omCecMgr, omLparMgr, providerCIMOMHandle, false);
            }
            try {
                cIMInstance2 = CimomWrapper.getInstance((CIMOMHandle)providerCIMOMHandle, cIMObjectPath, providerCIMOMHandle.getClass(cIMObjectPath, false), false);
            }
            catch (CIMException cIMException) {
                try {
                    HSCLogUtils.serverLog(cIMException, HSCLogUtils._LPARClassLogInfo);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                cIMInstance2 = null;
            }
            if (cIMInstance2 == null) {
                throw new PIHscServerException("2916", null);
            }
            if (3 <= Trace.LEVEL) {
                Trace.trace("appahscD", "lparInstance =" + cIMInstance2);
            }
            try {
                n2 = ((UnsignedInt16)cIMInstance.getProperty("LMBSize").getValue().getValue()).intValue();
            }
            catch (Throwable throwable) {
                throw new PIHscServerException("2523", new String[]{"R5ComputerSystem.LMBSize"}, throwable);
            }
            if (unsignedInt32 != null && (l17 = (l3 = unsignedInt32.longValue()) % (long)n2) != 0L) {
                throw new PIHscServerException("0229", new String[]{String.valueOf(l3), String.valueOf(n2)}, null);
            }
            if (unsignedInt322 != null && (l16 = (l4 = unsignedInt322.longValue()) % (long)n2) != 0L) {
                throw new PIHscServerException("0229", new String[]{String.valueOf(l4), String.valueOf(n2)}, null);
            }
            if (unsignedInt323 != null && (l15 = (l5 = unsignedInt323.longValue()) % (long)n2) != 0L) {
                throw new PIHscServerException("0229", new String[]{String.valueOf(l5), String.valueOf(n2)}, null);
            }
            if (bl) {
                long l18;
                long l19;
                long l20;
                long l21;
                long l22;
                long l23;
                if (unsignedInt324 != null && (l23 = (l6 = unsignedInt324.longValue()) % (long)n2) != 0L) {
                    throw new PIHscServerException("0229", new String[]{String.valueOf(l6), String.valueOf(n2)}, null);
                }
                if (unsignedInt325 != null && (l22 = (l7 = unsignedInt325.longValue()) % (long)n2) != 0L) {
                    throw new PIHscServerException("0229", new String[]{String.valueOf(l7), String.valueOf(n2)}, null);
                }
                if (unsignedInt326 != null && (l21 = (l8 = unsignedInt326.longValue()) % (long)n2) != 0L) {
                    throw new PIHscServerException("0229", new String[]{String.valueOf(l8), String.valueOf(n2)}, null);
                }
                if (unsignedInt327 != null && (l20 = (l9 = unsignedInt327.longValue()) % (long)n2) != 0L) {
                    throw new PIHscServerException("0229", new String[]{String.valueOf(l9), String.valueOf(n2)}, null);
                }
                if (unsignedInt328 != null && (l19 = (l10 = unsignedInt328.longValue()) % (long)n2) != 0L) {
                    throw new PIHscServerException("0229", new String[]{String.valueOf(l10), String.valueOf(n2)}, null);
                }
                if (unsignedInt329 != null && (l18 = (l11 = unsignedInt329.longValue()) % (long)n2) != 0L) {
                    throw new PIHscServerException("0229", new String[]{String.valueOf(l11), String.valueOf(n2)}, null);
                }
            }
            try {
                l = ((UnsignedInt32)cIMInstance.getProperty("ConfigurableMem").getValue().getValue()).longValue();
            }
            catch (Throwable throwable) {
                try {
                    HSCLogUtils.serverLog(throwable, HSCLogUtils._LPARClassLogInfo);
                }
                catch (Throwable throwable2) {
                    // empty catch block
                }
                throw new PIHscServerException("2523", new String[]{"R50ComputerSystem.ConfigurableProc"}, throwable);
            }
            if (l < l3 + l6 + l9 || l < l3) {
                System.out.println("ERROR: memory want is greater than configurable memory available");
                throw new PIHscServerException("03F9", null);
            }
            if (l3 > l4 || l3 > l5) {
                System.out.println("ERROR: required memory is greater than desired or max memory");
                throw new PIHscServerException("0617", null);
            }
            if (l4 > l5) {
                System.out.println("ERROR: desired memory is greater than max memory");
                throw new PIHscServerException("0617", null);
            }
            if (bl) {
                if (l6 > l7 || l6 > l8) {
                    System.out.println("ERROR: MegaMouth reserve1 region required memory is greater than desired or max memory");
                    throw new PIHscServerException("0617", null);
                }
                if (l9 > l10 || l9 > l11) {
                    System.out.println("ERROR: MegaMouth reserve2 region required memory is greater than desired or max memory");
                    throw new PIHscServerException("0617", null);
                }
                if (l7 > l8 || l10 > l11) {
                    System.out.println("ERROR: MegaMouth reserve1 or 2 region desired memory is greater than max memory");
                    throw new PIHscServerException("0617", null);
                }
            }
            try {
                l2 = ((UnsignedInt32)cIMInstance.getProperty("PendAvailMem").getValue().getValue()).longValue();
            }
            catch (Throwable throwable) {
                try {
                    HSCLogUtils.serverLog(throwable, HSCLogUtils._LPARClassLogInfo);
                }
                catch (Throwable throwable3) {
                    // empty catch block
                }
                throw new PIHscServerException("2523", new String[]{"R50ComputerSystem.PendAvailMem"}, throwable);
            }
            int n3 = 0;
            try {
                n3 = ((UnsignedInt8)cIMInstance2.getProperty("DefinitionState").getValue().getValue()).intValue();
            }
            catch (Throwable throwable) {
                try {
                    HSCLogUtils.serverLog(throwable, HSCLogUtils._LPARClassLogInfo);
                }
                catch (Throwable throwable4) {
                    // empty catch block
                }
                throw new PIHscServerException("2523", new String[]{"R50Partition.DefinitionState"}, throwable);
            }
            int n4 = 0;
            try {
                n4 = ((UnsignedInt8)cIMInstance2.getProperty("PartitionState").getValue().getValue()).intValue();
            }
            catch (Throwable throwable) {
                try {
                    HSCLogUtils.serverLog(throwable, HSCLogUtils._LPARClassLogInfo);
                }
                catch (Throwable throwable5) {
                    // empty catch block
                }
                throw new PIHscServerException("2523", new String[]{"R50Partition.PartitionState"}, throwable);
            }
            if (n4 == 0) {
                cIMValue = cIMInstance2.getProperty("PendAllocMem").getValue();
                if (cIMValue != null) {
                    l13 = ((UnsignedInt32)cIMValue.getValue()).longValue();
                }
                cIMValue = cIMInstance2.getProperty("Reserve1PendAllocMem").getValue();
                try {
                    if (cIMValue != null) {
                        l13 += ((UnsignedInt32)cIMValue.getValue()).longValue();
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                cIMValue = cIMInstance2.getProperty("Reserve2PendAllocMem").getValue();
                try {
                    if (cIMValue != null) {
                        l13 += ((UnsignedInt32)cIMValue.getValue()).longValue();
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            FspCmdHelper fspCmdHelper = omCecMgr.getCmdHelper();
            cIMValue = null;
            if (n3 == 2 || n3 == 1 || n3 == 4 || n3 == 3) {
                cIMValue = new UnsignedInt8(1);
            } else if (n3 == 66 || n3 == 65) {
                cIMValue = new UnsignedInt8(2);
            } else if (n3 == 130 || n3 == 129) {
                cIMValue = new UnsignedInt8(3);
            }
            UnsignedInt32 unsignedInt3210 = new UnsignedInt32(l4 / (long)n2);
            UnsignedInt32 unsignedInt3211 = new UnsignedInt32(l5 / (long)n2);
            if (n4 == 0) {
                FspRequiredMemoryInfo fspRequiredMemoryInfo = null;
                try {
                    fspRequiredMemoryInfo = fspCmdHelper.getRequiredMinimumMemoryForMaximum((UnsignedInt8)cIMValue, unsignedInt8, unsignedInt3211);
                }
                catch (Throwable throwable) {
                    throw new PIHscServerException("0400", throwable);
                }
                long l24 = fspRequiredMemoryInfo.getReqMinMemRegionsAssignedToLpar().longValue() * (long)n2;
                if (l24 > l3) {
                    System.out.println("ERROR: required memory is not enough for max memory");
                    throw new PIHscServerException("0618", new String[]{Long.toString(l24)}, null);
                }
            }
            long l25 = 0L;
            if (l13 + l2 >= l4 + l7 + l10 && n4 == 0) {
                Object object3;
                try {
                    fspCmdHelper.setLparPendingMemory(new UnsignedInt16(n), unsignedInt8, new UnsignedInt32(l3 / (long)n2), unsignedInt3210, unsignedInt3211);
                    try {
                        object2 = (UnsignedInt32)omLparMgr.getObject().getProperty("PendMaxMem");
                        object = new OmLparActResourceUpdater(omLparMgr);
                        ((OmLparActResourceUpdater)object).updateLparPendMem(unsignedInt32, unsignedInt322, unsignedInt323);
                        object3 = new OmCecInstUpdater(omCecMgr);
                        ((OmCecInstUpdater)object3).updatePhypAvailMemData();
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                    }
                }
                catch (PIHscCmdMgrException pIHscCmdMgrException) {
                    if (pIHscCmdMgrException.isExtendedError()) {
                        object = pIHscCmdMgrException.getExtendedError();
                        object3 = ((CmdExtendedErrorList)object).getErrorArray();
                        if (object3 != null && ((CmdExtendedError[])object3).length > 0) {
                            CmdExtendedError cmdExtendedError = object3[0];
                            long l26 = cmdExtendedError.extractErrorCode();
                            System.out.println("errCode = " + l26);
                            System.out.println("PIHscConstants.PHYP_EXT_ERR_ERROR  |0xE002 = 1073799170");
                            if (l26 == 1073799170L) {
                                byte[] byArray = cmdExtendedError.getErrorParms();
                                if (byArray == null || byArray.length <= 0) {
                                    throw new PIHscServerException("061C", pIHscCmdMgrException);
                                }
                                BigInteger bigInteger = new BigInteger(byArray);
                                System.out.println("memVal = " + bigInteger);
                                l25 = PIResourcesAllocationUtils.getAdditionPhypMemNeeded(bigInteger.longValue() * (long)n2, n2, fspCmdHelper);
                            }
                            throw new PIHscServerException("061C", pIHscCmdMgrException);
                        }
                        throw new PIHscServerException("061C", pIHscCmdMgrException);
                    }
                    throw new PIHscServerException("061C", pIHscCmdMgrException);
                }
                if (l25 <= 0L) {
                    allocMemAndLparInfo.allocatedMem = new UnsignedInt32(l4);
                    if (bl) {
                        allocMemAndLparInfo.res1AllocatedMem = new UnsignedInt32(l7);
                        allocMemAndLparInfo.res2AllocatedMem = new UnsignedInt32(l10);
                    }
                    object2 = allocMemAndLparInfo;
                    return object2;
                }
            }
            if (l25 <= 0L && l13 + l2 >= l4 + l7 + l10) {
                l12 = l13 + l2;
                allocMemAndLparInfo.allocatedMem = new UnsignedInt32(l4);
                if (bl) {
                    allocMemAndLparInfo.res1AllocatedMem = new UnsignedInt32(l7);
                    allocMemAndLparInfo.res2AllocatedMem = new UnsignedInt32(l10);
                }
                object2 = allocMemAndLparInfo;
                return object2;
            }
            l12 = l13 + l2 - l25;
            object2 = PIResourcesAllocationUtils.getLparMemInfo(n, string, providerCIMOMHandle, string2, 65535, vector);
            if (3 <= Trace.LEVEL) {
                Trace.trace("appahscD", "memTable =" + object2);
            }
            object = null;
            if (object2 != null) {
                long l27 = 0L;
                if (((MemoryTable)object2).lparMemValPairs != null) {
                    object = PIResourcesAllocationUtils.checkMemForSteal(n, l4 + l7 + l10 - l12, ((MemoryTable)object2).lparMemValPairs, false);
                    if (3 <= Trace.LEVEL) {
                        Trace.trace("appahscD", "invalidateLparMem =" + object);
                    }
                    if (object != null && ((AllocMemAndLparInfo)object).allocatedMem != null) {
                        l12 += ((AllocMemAndLparInfo)object).allocatedMem.longValue();
                    }
                }
            }
            System.out.println("accumMem = " + l12);
            long l28 = l4 + l7 + l10 - l12;
            System.out.println("lackedMem = " + l28);
            AllocMemAndLparInfo allocMemAndLparInfo2 = null;
            long l29 = 0L;
            int[] nArray = PIClusterModifier.getLparClusterInfo((CIMOMHandle)providerCIMOMHandle, cIMObjectPath);
            if (l28 >= 0L && nArray[0] <= Short.MAX_VALUE) {
                System.out.println("wlmData[0] = " + nArray[0]);
                MemoryTable memoryTable = PIResourcesAllocationUtils.getLparMemInfo(n, string, providerCIMOMHandle, string2, nArray[0], vector);
                System.out.println("inWlmTable = " + memoryTable);
                if (3 <= Trace.LEVEL) {
                    Trace.trace("appahscD", "inWlmTable =" + memoryTable);
                }
                if (memoryTable != null || memoryTable.lparMemValPairs != null) {
                    allocMemAndLparInfo2 = PIResourcesAllocationUtils.checkMemForSteal(n, l28, memoryTable.lparMemValPairs, true);
                    if (3 <= Trace.LEVEL) {
                        Trace.trace("appahscD", "inWlmLparMem =" + allocMemAndLparInfo2);
                    }
                    if (allocMemAndLparInfo2 != null && allocMemAndLparInfo2.allocatedMem != null) {
                        l12 += allocMemAndLparInfo2.allocatedMem.longValue();
                        ((AllocMemAndLparInfo)object).mergeLparMemInfo(allocMemAndLparInfo2);
                    }
                }
            }
            if (l12 < l3 + l6 + l9) {
                System.out.println("ERROR: not enough memory to satisfy minimum configuration");
                throw new PIHscServerException("03EC", new String[]{Long.toString(l12), Long.toString(l3 + l6 + l9)}, null);
            }
            if (bl) {
                allocMemAndLparInfo.res2AllocatedMem = new UnsignedInt32(l9);
                long l30 = l12 - l9;
                if (l30 >= l4 + l7) {
                    allocMemAndLparInfo.res1AllocatedMem = new UnsignedInt32(l7);
                    allocMemAndLparInfo.allocatedMem = new UnsignedInt32(l4);
                    if ((l30 = l30 - l7 - l4) > 0L) {
                        allocMemAndLparInfo.res2AllocatedMem = new UnsignedInt32(l9 + l30);
                    }
                } else {
                    allocMemAndLparInfo.res1AllocatedMem = new UnsignedInt32(l6);
                    if ((l30 -= l6) >= l4) {
                        allocMemAndLparInfo.allocatedMem = new UnsignedInt32(l4);
                        if ((l30 -= l4) > 0L) {
                            allocMemAndLparInfo.res1AllocatedMem = new UnsignedInt32(l6 + l30);
                        }
                    } else {
                        allocMemAndLparInfo.allocatedMem = new UnsignedInt32(l30);
                    }
                }
            } else {
                allocMemAndLparInfo.allocatedMem = new UnsignedInt32(l12);
                allocMemAndLparInfo.res2AllocatedMem = new UnsignedInt32(l10);
                allocMemAndLparInfo.res1AllocatedMem = new UnsignedInt32(l7);
            }
            boolean bl3 = false;
            boolean bl4 = false;
            allocMemAndLparInfo.lparIDs = ((AllocMemAndLparInfo)object).lparIDs;
            allocMemAndLparInfo.lparMem = ((AllocMemAndLparInfo)object).lparMem;
            AllocMemAndLparInfo allocMemAndLparInfo3 = allocMemAndLparInfo;
            return allocMemAndLparInfo3;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            try {
                HSCLogUtils.serverLog(throwable, HSCLogUtils._LPARClassLogInfo);
            }
            catch (Throwable throwable6) {
                // empty catch block
            }
            if (!(throwable instanceof PIHscServerException)) {
                throw new PIHscServerException("0617", null);
            }
            throw (PIHscServerException)throwable;
        }
        finally {
            if (1 <= Trace.LEVEL) {
                Trace.trace("appahscT", "<- checkMemForAlloc");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AllocMemAndLparInfo checkMemForSteal(int n, long l, LparMemValuePair[] lparMemValuePairArray, boolean bl) throws CIMException {
        System.out.println("checkMemForSteal ->");
        Trace.trace("appahscT", "->PIResourcesAllocationUtils.checkMemForSteal");
        Trace.trace("appahscF", "lparID = " + String.valueOf(n));
        Trace.trace("appahscF", "amountNeeded = " + String.valueOf(l));
        Trace.trace("appahscF", "lparMemPairList = " + lparMemValuePairArray);
        Vector<UnsignedInt32> vector = new Vector<UnsignedInt32>();
        LparMemValuePair[] lparMemValuePairArray2 = new LparMemValuePair[lparMemValuePairArray.length];
        try {
            long l2;
            if (lparMemValuePairArray == null) {
                AllocMemAndLparInfo allocMemAndLparInfo = null;
                return allocMemAndLparInfo;
            }
            Arrays.sort(lparMemValuePairArray, new PIMemoryComparator());
            int n2 = 0;
            int n3 = lparMemValuePairArray.length;
            boolean bl2 = false;
            boolean bl3 = true;
            long l3 = 0L;
            long l4 = 0L;
            Vector<UnsignedInt16> vector2 = new Vector<UnsignedInt16>();
            AllocMemAndLparInfo allocMemAndLparInfo = new AllocMemAndLparInfo();
            boolean bl4 = false;
            boolean bl5 = true;
            while (0 != n3 && !bl4) {
                l2 = 0L;
                for (n2 = 0; n2 < n3; ++n2) {
                    if (bl5) {
                        lparMemValuePairArray2[n2] = new LparMemValuePair();
                        lparMemValuePairArray2[n2].memAmount = lparMemValuePairArray[n2].minMemAmount;
                        lparMemValuePairArray2[n2].lparID = lparMemValuePairArray[n2].lparID;
                    }
                    l2 = l3 + (lparMemValuePairArray[n2].memAmount - lparMemValuePairArray[n2].minMemAmount);
                    Trace.trace("appahscF", "tmpMemAdder = " + String.valueOf(l2));
                    if (l2 < l) continue;
                    vector2.add(new UnsignedInt16(lparMemValuePairArray[n2].lparID));
                    vector.add(new UnsignedInt32(lparMemValuePairArray[n2].minMemAmount + (l2 - l)));
                    l3 = l;
                    bl4 = true;
                    break;
                }
                bl5 = false;
                if (bl4) continue;
                l3 = l2;
                if (2 <= Trace.LEVEL) {
                    Trace.trace("appahscF", "accumulatedMem = " + String.valueOf(l3));
                }
                vector2.add(new UnsignedInt16(lparMemValuePairArray[n2 - 1].lparID));
                vector.add(new UnsignedInt32(lparMemValuePairArray[n2 - 1].minMemAmount));
                --n3;
            }
            if (3 <= Trace.LEVEL) {
                Trace.trace("appahscD", "accumulatedMem =" + l3);
            }
            if (bl4 || bl) {
                allocMemAndLparInfo.allocatedMem = new UnsignedInt32(l3);
                allocMemAndLparInfo.lparIDs = new UnsignedInt16[vector2.size()];
                allocMemAndLparInfo.lparIDs = vector2.toArray(new UnsignedInt16[0]);
                allocMemAndLparInfo.lparMem = new UnsignedInt32[vector2.size()];
                allocMemAndLparInfo.lparMem = vector.toArray(new UnsignedInt32[0]);
                System.out.println("retVal = " + allocMemAndLparInfo);
                AllocMemAndLparInfo allocMemAndLparInfo2 = allocMemAndLparInfo;
                return allocMemAndLparInfo2;
            }
            Arrays.sort(lparMemValuePairArray2, new PIMemoryComparator());
            n2 = 0;
            n3 = lparMemValuePairArray2.length;
            bl2 = false;
            bl3 = true;
            l4 = 0L;
            while (0 != n3 && !bl4) {
                int n4;
                l2 = 0L;
                for (n2 = 0; n2 < n3; ++n2) {
                    l2 = l3 + lparMemValuePairArray2[n2].memAmount;
                    Trace.trace("appahscF", "tmpMemAdder = " + String.valueOf(l2));
                    if (l2 < l) continue;
                    n4 = vector2.indexOf(new UnsignedInt16(lparMemValuePairArray2[n2].lparID));
                    if (n4 != -1) {
                        vector.setElementAt(new UnsignedInt32(0L), n4);
                    } else {
                        vector2.add(new UnsignedInt16(lparMemValuePairArray2[n2].lparID));
                        vector.add(new UnsignedInt32(0L));
                    }
                    l3 = l;
                    bl4 = true;
                    break;
                }
                if (bl4) continue;
                l3 = l2;
                if (2 <= Trace.LEVEL) {
                    Trace.trace("appahscF", "accumulatedMem = " + String.valueOf(l3));
                }
                if ((n4 = vector2.indexOf(new UnsignedInt16(lparMemValuePairArray2[n2 - 1].lparID))) != -1) {
                    vector.setElementAt(new UnsignedInt32(0L), n4);
                } else {
                    vector2.add(new UnsignedInt16(lparMemValuePairArray2[n2 - 1].lparID));
                    vector.add(new UnsignedInt32(0L));
                }
                --n3;
            }
            allocMemAndLparInfo.allocatedMem = new UnsignedInt32(l3);
            allocMemAndLparInfo.lparIDs = new UnsignedInt16[vector2.size()];
            allocMemAndLparInfo.lparIDs = vector2.toArray(new UnsignedInt16[0]);
            allocMemAndLparInfo.lparMem = new UnsignedInt32[vector2.size()];
            allocMemAndLparInfo.lparMem = vector.toArray(new UnsignedInt32[0]);
            System.out.println("retVal = " + allocMemAndLparInfo);
            AllocMemAndLparInfo allocMemAndLparInfo3 = allocMemAndLparInfo;
            return allocMemAndLparInfo3;
        }
        finally {
            Trace.trace("appahscT", "PIResourcesAllocationUtils.checkMemForSteal <-");
        }
    }

    public static IOInfo buildIOInfo(CIMObjectPath cIMObjectPath, UnsignedInt16 unsignedInt16, ProviderCIMOMHandle providerCIMOMHandle) throws PIHscServerException {
        Trace.trace("appahscT", "-> PIResourcesAllocationUtils.buildIOInfo");
        Trace.trace("appahscF", "cecPath = " + cIMObjectPath);
        Trace.trace("appahscF", "lparID = " + unsignedInt16);
        Trace.trace("appahscF", "cimHandle = " + providerCIMOMHandle);
        IOInfo iOInfo = null;
        String string = cIMObjectPath.getNameSpace();
        String string2 = "";
        Vector vector = null;
        CIMInstance cIMInstance = null;
        try {
            cIMInstance = CimomWrapper.getInstance((CIMOMHandle)providerCIMOMHandle, cIMObjectPath, providerCIMOMHandle.getClass(cIMObjectPath, false), false);
        }
        catch (Throwable throwable) {
            cIMInstance = null;
        }
        if (cIMInstance == null) {
            throw new PIHscServerException("0228", null);
        }
        if (3 <= Trace.LEVEL) {
            Trace.trace("appahscD", "cecInst =" + cIMInstance);
        }
        try {
            string2 = (String)cIMInstance.getProperty("Name").getValue().getValue();
        }
        catch (NullPointerException nullPointerException) {
            try {
                HSCLogUtils.serverLog(nullPointerException, HSCLogUtils._LPARClassLogInfo);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw new PIHscServerException("2523", new String[]{"R50ComputerSystem.Name"}, nullPointerException);
        }
        try {
            vector = CimomWrapper.associatorNames((CIMOMHandle)providerCIMOMHandle, new CIMObjectPath("IBMHSC_UsingIODrawer", string), cIMObjectPath, "IBMHSC_IODrawer", "Antecedent", "Dependent");
        }
        catch (CIMException cIMException) {
            try {
                HSCLogUtils.serverLog(cIMException, HSCLogUtils._LPARClassLogInfo);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            vector = null;
        }
        if (null != vector && vector.size() > 0) {
            if (3 <= Trace.LEVEL) {
                Trace.trace("appahscD", "ioUnitPathVec =" + vector);
            }
            iOInfo = new IOInfo();
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                CIMObjectPath cIMObjectPath2 = (CIMObjectPath)enumeration.nextElement();
                Vector vector2 = null;
                try {
                    vector2 = CimomWrapper.associatorNames((CIMOMHandle)providerCIMOMHandle, new CIMObjectPath("IBMHSC_IODrawerSlot", string), cIMObjectPath2, "IBMHSC_PCISlot", "GroupComponent", "PartComponent");
                }
                catch (CIMException cIMException) {
                    try {
                        HSCLogUtils.serverLog(cIMException, HSCLogUtils._LPARClassLogInfo);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    vector2 = null;
                }
                if (null == vector2 || vector2.size() <= 0) continue;
                if (3 <= Trace.LEVEL) {
                    Trace.trace("appahscD", "ioSlotPathVec =" + vector2);
                }
                Enumeration enumeration2 = vector2.elements();
                while (enumeration2.hasMoreElements()) {
                    SlotInstLparIDPair slotInstLparIDPair;
                    CIMObjectPath cIMObjectPath3 = (CIMObjectPath)enumeration2.nextElement();
                    CIMInstance cIMInstance2 = null;
                    try {
                        cIMInstance2 = CimomWrapper.getInstance((CIMOMHandle)providerCIMOMHandle, cIMObjectPath3, providerCIMOMHandle.getClass(cIMObjectPath3, false), false);
                    }
                    catch (CIMException cIMException) {
                        try {
                            HSCLogUtils.serverLog(cIMException, HSCLogUtils._LPARClassLogInfo);
                        }
                        catch (Throwable throwable) {}
                        continue;
                    }
                    if (3 <= Trace.LEVEL) {
                        Trace.trace("appahscD", "ioSlotInst =" + cIMInstance2);
                    }
                    UnsignedInt32 unsignedInt32 = new UnsignedInt32(Long.parseLong((String)cIMInstance2.getProperty("DeviceID").getValue().getValue()));
                    Vector vector3 = null;
                    try {
                        vector3 = CimomWrapper.associators((CIMOMHandle)providerCIMOMHandle, new CIMObjectPath("IBMHSC_AllocatedSlot", string), cIMObjectPath3, "IBMHSC_Partition", "PartComponent", "GroupComponent", false, false, null);
                    }
                    catch (CIMException cIMException) {
                        try {
                            HSCLogUtils.serverLog(cIMException, HSCLogUtils._LPARClassLogInfo);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        vector3 = null;
                    }
                    UnsignedInt16 unsignedInt162 = null;
                    if (3 <= Trace.LEVEL) {
                        Trace.trace("appahscD", "slotOwnVec =" + vector3);
                    }
                    if (null == vector3 || vector3.size() <= 0) {
                        unsignedInt162 = new UnsignedInt16(65535);
                    } else {
                        slotInstLparIDPair = null;
                        String string3 = "";
                        int n = 65535;
                        for (int i = 0; i < vector3.size(); ++i) {
                            slotInstLparIDPair = (CIMInstance)vector3.elementAt(i);
                            string3 = "";
                            try {
                                string3 = (String)slotInstLparIDPair.getProperty("Name").getValue().getValue();
                            }
                            catch (NullPointerException nullPointerException) {
                                throw new PIHscServerException("2523", new String[]{"R50Partition.Name"}, nullPointerException);
                            }
                            String string4 = string3.substring(string3.indexOf(42) + 1);
                            if (!string4.equals(string2)) {
                                unsignedInt162 = new UnsignedInt16(65535);
                                continue;
                            }
                            n = Integer.parseInt(string3.substring(0, string3.indexOf(42)));
                            unsignedInt162 = new UnsignedInt16(n);
                            if (n != unsignedInt16.intValue()) continue;
                            if (null == iOInfo.drcIndices) {
                                iOInfo.drcIndices = new Vector();
                            }
                            iOInfo.drcIndices.add(unsignedInt32);
                        }
                    }
                    slotInstLparIDPair = new SlotInstLparIDPair();
                    slotInstLparIDPair.ioSlotInst = cIMInstance2;
                    slotInstLparIDPair.ownerLpar = unsignedInt162;
                    if (null == iOInfo.ioSlotInfoTable) {
                        iOInfo.ioSlotInfoTable = new Hashtable();
                    }
                    iOInfo.ioSlotInfoTable.put(unsignedInt32, slotInstLparIDPair);
                }
            }
        }
        Trace.trace("appahscT", "PIResourcesAllocationUtils.buildIOInfo <-");
        return iOInfo;
    }

    public static boolean checkIOSlotStateStatus(CIMInstance cIMInstance) {
        return true;
    }

    public static boolean checkIOSlotOwner(UnsignedInt16 unsignedInt16, UnsignedInt16 unsignedInt162, String string, ProviderCIMOMHandle providerCIMOMHandle, String string2) throws CIMException {
        if (unsignedInt16.equals((Object)unsignedInt162)) {
            return true;
        }
        if (unsignedInt16.intValue() == 0 || unsignedInt16.intValue() == 65535) {
            return true;
        }
        Vector vector = PIResourcesAllocationUtils.getAccessibleLparIds(string, string2, providerCIMOMHandle);
        return PIResourcesAllocationUtils.checkIOSlotOwnerWithAccess(unsignedInt16, unsignedInt162, string, providerCIMOMHandle, string2, vector);
    }

    public static Vector getAccessibleLparIds(String string, String string2, ProviderCIMOMHandle providerCIMOMHandle) throws CIMException {
        CIMObjectPath cIMObjectPath = PIResourcesAllocationUtils.constructCecPath(string, string2);
        Vector vector = PIHmcAccessUtils.getLparObjWithAuthFromCec(cIMObjectPath, "ActivateLparProfile", providerCIMOMHandle, false);
        System.out.println("accessibleLpars = " + vector);
        Vector<UnsignedInt16> vector2 = new Vector<UnsignedInt16>();
        if (vector != null && vector.size() > 0) {
            for (int i = 0; i < vector.size(); ++i) {
                CIMInstance cIMInstance = (CIMInstance)vector.elementAt(i);
                String string3 = (String)cIMInstance.getProperty("Name").getValue().getValue();
                int n = PIResourcesAllocationUtils.parseLparID(string3);
                vector2.add(new UnsignedInt16(n));
            }
        }
        return vector2;
    }

    public static boolean checkIOSlotOwnerWithAccess(UnsignedInt16 unsignedInt16, UnsignedInt16 unsignedInt162, String string, ProviderCIMOMHandle providerCIMOMHandle, String string2, Vector vector) {
        int n;
        if (unsignedInt16.equals((Object)unsignedInt162)) {
            return true;
        }
        if (unsignedInt16.intValue() == 0 || unsignedInt16.intValue() == 65535) {
            return true;
        }
        if (vector == null) {
            return false;
        }
        if (!vector.contains(unsignedInt16)) {
            return false;
        }
        String string3 = unsignedInt16.intValue() + "*" + string;
        CIMObjectPath cIMObjectPath = new CIMObjectPath("IBMHSC_Partition", string2);
        cIMObjectPath.addKey("Name", new CIMValue((Object)string3));
        cIMObjectPath.addKey("CreationClassName", new CIMValue((Object)"IBMHSC_Partition"));
        CIMInstance cIMInstance = null;
        try {
            cIMInstance = CimomWrapper.getInstance((CIMOMHandle)providerCIMOMHandle, cIMObjectPath, providerCIMOMHandle.getClass(cIMObjectPath, false), false);
        }
        catch (CIMException cIMException) {
            try {
                HSCLogUtils.serverLog(cIMException, HSCLogUtils._LPARClassLogInfo);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            cIMInstance = null;
        }
        if (null == cIMInstance) {
            return true;
        }
        if (3 <= Trace.LEVEL) {
            Trace.trace("appahscD", "lparInst =" + cIMInstance);
        }
        if (0 == (n = ((UnsignedInt8)cIMInstance.getProperty("DefinitionState").getValue().getValue()).intValue()) || 1 == n || 3 == n || 129 == n) {
            return true;
        }
        if (2 == n || 4 == n || 130 == n || 66 == n) {
            int n2 = 0;
            try {
                n2 = ((UnsignedInt8)cIMInstance.getProperty("PartitionState").getValue().getValue()).intValue();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            return 0 == n2;
        }
        return true;
    }

    public static AllocIOAndLparInfo checkIOForAlloc(Vector vector, Vector vector2, Vector vector3, Vector vector4, Vector vector5, UnsignedInt16 unsignedInt16, String string, ProviderCIMOMHandle providerCIMOMHandle, String string2) throws PIHscServerException {
        return PIResourcesAllocationUtils.checkIOForAlloc(vector, vector2, vector3, vector4, vector5, unsignedInt16, string, providerCIMOMHandle, string2, null);
    }

    public static AllocIOAndLparInfo checkIOForAlloc(Vector vector, Vector vector2, Vector vector3, Vector vector4, Vector vector5, UnsignedInt16 unsignedInt16, String string, ProviderCIMOMHandle providerCIMOMHandle, String string2, Vector vector6) throws PIHscServerException {
        Cloneable cloneable;
        Object object;
        Trace.trace("appahscT", "-> PIResourcesAllocationUtils.checkIOForAlloc");
        Trace.trace("appahscF", "requiredIOs = " + vector);
        Trace.trace("appahscF", "requiredIOPools = " + vector2);
        Trace.trace("appahscF", "desiredIOs = " + vector3);
        Trace.trace("appahscF", "desiredIOPools = " + vector4);
        Trace.trace("appahscF", "lparID = " + unsignedInt16);
        Trace.trace("appahscF", "cecName = " + string);
        Trace.trace("appahscF", "cimHandle = " + providerCIMOMHandle);
        Trace.trace("appahscF", "namespace = " + string2);
        Vector vector7 = null;
        Vector<UnsignedInt16> vector8 = new Vector<UnsignedInt16>();
        Vector vector9 = new Vector();
        Vector<UnsignedInt8> vector10 = new Vector<UnsignedInt8>();
        Vector vector11 = new Vector();
        AllocIOAndLparInfo allocIOAndLparInfo = new AllocIOAndLparInfo();
        OmCecMgr omCecMgr = OmCecMgr.getCecMgr(string);
        boolean bl = false;
        try {
            object = omCecMgr.getLparMgr(unsignedInt16 + "*" + string);
            cloneable = ((OmLparMgr)object).getObject();
            UnsignedInt8 unsignedInt8 = (UnsignedInt8)cloneable.getProperty("DefinitionState");
            int n = unsignedInt8.intValue();
            if (n == 1 || n == 2 || n == 65 || n == 66 || n == 3 || n == 4) {
                bl = true;
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        try {
            UnsignedInt16 unsignedInt162;
            String string3;
            object = PIResourcesAllocationUtils.buildIOInfo(PIResourcesAllocationUtils.constructCecPath(string, string2), unsignedInt16, providerCIMOMHandle);
            if (object == null) {
                throw new PIHscServerException("03FA", null);
            }
            if (3 <= Trace.LEVEL) {
                Trace.trace("appahscD", "ioInfo =" + object);
            }
            if (null != ((IOInfo)object).drcIndices) {
                vector7 = (Vector)((IOInfo)object).drcIndices.clone();
            } else {
                vector7 = new Vector();
                vector10 = new Vector();
            }
            cloneable = PIResourcesAllocationUtils.getAccessibleLparIds(string, string2, providerCIMOMHandle);
            if (vector != null) {
                for (int i = 0; i < vector.size(); ++i) {
                    UnsignedInt16 unsignedInt163;
                    SlotInstLparIDPair slotInstLparIDPair = (SlotInstLparIDPair)((IOInfo)object).ioSlotInfoTable.get(vector.elementAt(i));
                    string3 = omCecMgr.drcIndexToFullLocCode((UnsignedInt32)vector.elementAt(i));
                    if (slotInstLparIDPair == null) {
                        throw new PIHscServerException("03EB", new String[]{string3}, null);
                    }
                    unsignedInt162 = slotInstLparIDPair.ioSlotInst;
                    if (bl) {
                        boolean bl2 = PICommonUtilMethods.underIOPAndStorageDev((CIMInstance)unsignedInt162, string2);
                        System.out.println("isStorageUnderIOP = " + bl2);
                        System.out.println("slotInst = " + unsignedInt162);
                        if (bl2) {
                            throw new PIHscServerException("063F", null);
                        }
                    }
                    UnsignedInt16 unsignedInt164 = slotInstLparIDPair.ownerLpar;
                    if (vector6 != null && vector6.size() > 0 && vector6.contains(unsignedInt164)) {
                        throw new PIHscServerException("03EB", new String[]{string3}, null);
                    }
                    if (!PIResourcesAllocationUtils.checkIOSlotStateStatus((CIMInstance)unsignedInt162)) {
                        System.out.println("ERROR: cannot acquire io slot " + vector.elementAt(i));
                        throw new PIHscServerException("03EB", new String[]{string3}, null);
                    }
                    if (!PIResourcesAllocationUtils.checkIOSlotOwnerWithAccess(unsignedInt164, unsignedInt16, string, providerCIMOMHandle, string2, (Vector)cloneable)) {
                        System.out.println("ERROR: canot acquire io slot " + vector.elementAt(i));
                        throw new PIHscServerException("03EB", new String[]{string3}, null);
                    }
                    int n = unsignedInt164.intValue();
                    if (unsignedInt16.intValue() == n) {
                        vector7.remove(vector.elementAt(i));
                        unsignedInt163 = unsignedInt162.getProperty("PriorityFlag").getValue();
                        System.out.println("priorityVal = " + unsignedInt163);
                        if (unsignedInt163 != null && ((UnsignedInt8)unsignedInt163.getValue()).intValue() == 2 && vector2.elementAt(i).equals(PIResourcesAllocationUtils.getIOPoolID((CIMInstance)unsignedInt162, providerCIMOMHandle, string2))) {
                            System.out.println("nothing changed in io setting for required " + vector.elementAt(i));
                            continue;
                        }
                    } else if (0 != n && 65535 != n) {
                        vector8.add(unsignedInt164);
                    }
                    if (!((unsignedInt163 = (UnsignedInt16)vector2.elementAt(i)).equals((Object)new UnsignedInt16(65535)) || vector5 != null && vector5.contains(unsignedInt163))) {
                        throw new PIHscServerException("147C", new String[]{string3}, null);
                    }
                    vector9.add(vector.elementAt(i));
                    vector10.add(new UnsignedInt8(2));
                    vector11.add(vector2.elementAt(i));
                }
            }
            if (vector3 != null) {
                for (int i = 0; i < vector3.size(); ++i) {
                    CIMValue cIMValue;
                    int n;
                    SlotInstLparIDPair slotInstLparIDPair = (SlotInstLparIDPair)((IOInfo)object).ioSlotInfoTable.get(vector3.elementAt(i));
                    if (slotInstLparIDPair == null) continue;
                    string3 = slotInstLparIDPair.ioSlotInst;
                    unsignedInt162 = slotInstLparIDPair.ownerLpar;
                    if (bl) {
                        n = PICommonUtilMethods.underIOPAndStorageDev((CIMInstance)string3, string2);
                        System.out.println("isStorageUnderIOP = " + (n != 0));
                        System.out.println("slotInst = " + string3);
                        if (n != 0) continue;
                    }
                    if (!PIResourcesAllocationUtils.checkIOSlotStateStatus((CIMInstance)string3) || vector6 != null && vector6.size() > 0 && vector6.contains(unsignedInt162) || !PIResourcesAllocationUtils.checkIOSlotOwnerWithAccess(unsignedInt162, unsignedInt16, string, providerCIMOMHandle, string2, (Vector)cloneable)) continue;
                    n = unsignedInt162.intValue();
                    if (unsignedInt16.intValue() == n) {
                        vector7.remove(vector3.elementAt(i));
                        cIMValue = string3.getProperty("PriorityFlag").getValue();
                        System.out.println("priorityVal = " + cIMValue);
                        if ((cIMValue == null || ((UnsignedInt8)cIMValue.getValue()).intValue() == 1) && vector4.elementAt(i).equals(PIResourcesAllocationUtils.getIOPoolID((CIMInstance)string3, providerCIMOMHandle, string2))) {
                            System.out.println("io setting for desired didn't change " + vector3.elementAt(i));
                            continue;
                        }
                    } else if (0 != n || 65535 != n) {
                        vector8.add(unsignedInt162);
                    }
                    if (!(cIMValue = (UnsignedInt16)vector4.elementAt(i)).equals((Object)new UnsignedInt16(65535)) && (vector5 == null || !vector5.contains(cIMValue))) continue;
                    vector9.add(vector3.elementAt(i));
                    vector10.add(new UnsignedInt8(1));
                    vector11.add(vector4.elementAt(i));
                }
            }
            allocIOAndLparInfo.allocatedIOs = new UnsignedInt32[vector9.size()];
            allocIOAndLparInfo.allocatedIOs = vector9.toArray(allocIOAndLparInfo.allocatedIOs);
            allocIOAndLparInfo.priorityFlags = new UnsignedInt8[vector10.size()];
            allocIOAndLparInfo.priorityFlags = vector10.toArray(allocIOAndLparInfo.priorityFlags);
            allocIOAndLparInfo.allocatedIOPools = vector11.toArray(new UnsignedInt16[0]);
            if (vector7 != null && vector7.size() > 0) {
                allocIOAndLparInfo.freeIOs = new UnsignedInt32[vector7.size()];
                allocIOAndLparInfo.freeIOs = vector7.toArray(new UnsignedInt32[0]);
            }
            if (vector8 != null && vector8.size() > 0) {
                allocIOAndLparInfo.lparIDs = new UnsignedInt16[vector8.size()];
                allocIOAndLparInfo.lparIDs = vector8.toArray(new UnsignedInt16[0]);
            }
            AllocIOAndLparInfo allocIOAndLparInfo2 = allocIOAndLparInfo;
            return allocIOAndLparInfo2;
        }
        catch (Throwable throwable) {
            try {
                HSCLogUtils.serverLog(throwable, HSCLogUtils._LPARClassLogInfo);
            }
            catch (Throwable throwable2) {
                // empty catch block
            }
            throwable.printStackTrace();
            if (!(throwable instanceof PIHscServerException)) {
                throw new PIHscServerException("0619", null);
            }
            throw (PIHscServerException)throwable;
        }
        finally {
            Trace.trace("appahscT", "PIResourcesAllocationUtils.checkIOForAlloc <-");
        }
    }

    public static HashMap buildVIOStateTable(UnsignedInt16 unsignedInt16, OmCecMgr omCecMgr) throws PIHscServerException {
        Trace.trace("appahscT", "-> PIResourcesAllocationUtils.buildVIOStateTable");
        Trace.trace("appahscF", "lparID = " + unsignedInt16);
        Trace.trace("appahscF", "cecMgr = " + omCecMgr);
        HashMap<UnsignedInt16, VioSlotState> hashMap = new HashMap<UnsignedInt16, VioSlotState>();
        FspCmdHelper fspCmdHelper = omCecMgr.getCmdHelper();
        try {
            FspLparVioSlotStates fspLparVioSlotStates;
            try {
                fspLparVioSlotStates = fspCmdHelper.getFspLparVioSlotStates(unsignedInt16, new UnsignedInt16(0), new UnsignedInt16(65535));
            }
            catch (PIHscCmdMgrException pIHscCmdMgrException) {
                if (pIHscCmdMgrException.getHscExId().equals("1552") || pIHscCmdMgrException.getHscExId().equals("1400")) {
                    throw new PIHscServerException("063A", pIHscCmdMgrException);
                }
                throw pIHscCmdMgrException;
            }
            if (null == fspLparVioSlotStates) {
                HashMap hashMap2 = null;
                return hashMap2;
            }
            VioSlotState[] vioSlotStateArray = fspLparVioSlotStates.getVioSlotStates();
            if (null == vioSlotStateArray) {
                HashMap hashMap3 = null;
                return hashMap3;
            }
            for (int i = 0; i < vioSlotStateArray.length; ++i) {
                hashMap.put(vioSlotStateArray[i].slotNumber, vioSlotStateArray[i]);
            }
            HashMap<UnsignedInt16, VioSlotState> hashMap4 = hashMap;
            return hashMap4;
        }
        catch (Throwable throwable) {
            try {
                HSCLogUtils.serverLog(throwable, HSCLogUtils._LPARClassLogInfo);
            }
            catch (Throwable throwable2) {
                // empty catch block
            }
            throwable.printStackTrace();
            if (!(throwable instanceof PIHscServerException)) {
                throw new PIHscServerException("03FB", null);
            }
            throw (PIHscServerException)throwable;
        }
        finally {
            Trace.trace("appahscT", "PIResourcesAllocationUtils.buildVIOStateTable <-");
        }
    }

    public static Set checkVIOForAlloc(UnsignedInt16 unsignedInt16, VirtualIOInfo virtualIOInfo, ProviderCIMOMHandle providerCIMOMHandle, OmCecMgr omCecMgr) throws PIHscServerException {
        Trace.trace("appahscT", "-> PIResourcesAllocationUtils.checkVIOForAlloc");
        Trace.trace("appahscF", "lparID = " + unsignedInt16);
        Trace.trace("appahscF", "vioInfo = " + virtualIOInfo);
        Trace.trace("appahscF", "cimHandle = " + providerCIMOMHandle);
        Trace.trace("appahscF", "cecMgr = " + omCecMgr);
        try {
            Object object;
            HashMap hashMap = PIResourcesAllocationUtils.buildVIOStateTable(unsignedInt16, omCecMgr);
            if (3 <= Trace.LEVEL) {
                Trace.trace("appahscD", "vioSlotToClear =" + hashMap);
            }
            if (null != virtualIOInfo) {
                UnsignedInt16[] unsignedInt16Array;
                UnsignedInt16[] unsignedInt16Array2;
                UnsignedInt8 unsignedInt8;
                RObject rObject;
                RObjectId rObjectId;
                UnsignedInt8 unsignedInt82;
                int n;
                VioSlotState vioSlotState;
                UnsignedInt16 unsignedInt162;
                int n2;
                object = virtualIOInfo.virSCSIAdapters;
                UnsignedInt16[] unsignedInt16Array3 = virtualIOInfo.virSerialAdapters;
                if (null != object) {
                    for (n2 = 0; n2 < ((UnsignedInt16[])object).length; ++n2) {
                        unsignedInt162 = object[n2];
                        vioSlotState = (VioSlotState)hashMap.get(unsignedInt162);
                        if (vioSlotState == null) continue;
                        if (3 <= Trace.LEVEL) {
                            Trace.trace("appahscD", "vioSlotState =" + vioSlotState);
                        }
                        n = vioSlotState.slotState.intValue();
                        unsignedInt82 = virtualIOInfo.virSCSIDeviceAttributes[n2];
                        rObjectId = new RObjectId(omCecMgr.getObject().getNameSpaceId(), R50Define.CID_IBMHSC_VirtualSCSI);
                        rObjectId.setKeyValue(0, "IBMHSC_VirtualSCSI");
                        rObjectId.setKeyValue(1, unsignedInt162.toString());
                        rObjectId.setKeyValue(2, "IBMHSC_Partition");
                        rObjectId.setKeyValue(3, unsignedInt16.toString() + "*" + omCecMgr.getCecName());
                        rObject = rObjectId.getObject();
                        if (rObject == null) continue;
                        unsignedInt8 = (UnsignedInt8)rObject.getProperty(R50VirtualSCSI.Index_DeviceAttribute);
                        if (n != 2 || !unsignedInt8.equals((Object)unsignedInt82)) continue;
                        hashMap.remove(unsignedInt162);
                    }
                }
                System.out.println("vioSlotsToClear = " + hashMap);
                if (null != unsignedInt16Array3) {
                    for (n2 = 0; n2 < unsignedInt16Array3.length; ++n2) {
                        unsignedInt162 = unsignedInt16Array3[n2];
                        System.out.println("slotNum = " + unsignedInt162);
                        vioSlotState = (VioSlotState)hashMap.get(unsignedInt162);
                        System.out.println("vSlotState = " + vioSlotState);
                        if (vioSlotState == null) continue;
                        if (3 <= Trace.LEVEL) {
                            Trace.trace("appahscD", "vSlotState =" + vioSlotState);
                        }
                        n = vioSlotState.slotState.intValue();
                        unsignedInt82 = virtualIOInfo.virSerialDeviceAttributes[n2];
                        rObjectId = new RObjectId(omCecMgr.getObject().getNameSpaceId(), R50Define.CID_IBMHSC_VirtualSerial);
                        rObjectId.setKeyValue(0, "IBMHSC_VirtualSerial");
                        rObjectId.setKeyValue(1, unsignedInt162.toString());
                        rObjectId.setKeyValue(2, "IBMHSC_Partition");
                        rObjectId.setKeyValue(3, unsignedInt16.toString() + "*" + omCecMgr.getCecName());
                        rObject = rObjectId.getObject();
                        if (rObject == null) continue;
                        unsignedInt8 = (UnsignedInt8)rObject.getProperty(R50VirtualSerial.Index_DeviceAttribute);
                        if (3 != n || !unsignedInt8.equals((Object)unsignedInt82)) continue;
                        hashMap.remove(unsignedInt162);
                    }
                }
                if (null != (unsignedInt16Array2 = virtualIOInfo.virtualLanSlotIDs)) {
                    for (int i = 0; i < unsignedInt16Array2.length; ++i) {
                        int n3;
                        vioSlotState = unsignedInt16Array2[i];
                        VioSlotState vioSlotState2 = (VioSlotState)hashMap.get(vioSlotState);
                        if (vioSlotState2 == null) continue;
                        if (3 <= Trace.LEVEL) {
                            Trace.trace("appahscD", "vSlotState =" + vioSlotState2);
                        }
                        if (1 != (n3 = vioSlotState2.slotState.intValue())) continue;
                        hashMap.remove(vioSlotState);
                    }
                }
                if (null != (unsignedInt16Array = virtualIOInfo.virSMCASlotIDs)) {
                    for (int i = 0; i < unsignedInt16Array.length; ++i) {
                        UnsignedInt16 unsignedInt163 = unsignedInt16Array[i];
                        VioSlotState vioSlotState3 = (VioSlotState)hashMap.get(unsignedInt163);
                        if (vioSlotState3 == null) continue;
                        if (3 <= Trace.LEVEL) {
                            Trace.trace("appahscD", "vSlotState =" + vioSlotState3);
                        }
                        int n4 = vioSlotState3.slotState.intValue();
                    }
                }
            }
            if (hashMap != null && hashMap.size() > 0) {
                hashMap.remove(new UnsignedInt16(0));
                hashMap.remove(new UnsignedInt16(1));
            }
            if (hashMap == null) {
                object = null;
                return object;
            }
            object = hashMap.keySet();
            return object;
        }
        catch (Throwable throwable) {
            try {
                HSCLogUtils.serverLog(throwable, HSCLogUtils._LPARClassLogInfo);
            }
            catch (Throwable throwable2) {
                // empty catch block
            }
            throwable.printStackTrace();
            if (!(throwable instanceof PIHscServerException)) {
                throw new PIHscServerException("061A", null);
            }
            throw (PIHscServerException)throwable;
        }
        finally {
            Trace.trace("appahscT", "PIResourcesAllocationUtils.checkVIOForAlloc <-");
        }
    }

    public static void checkVLANConfig(VirtualIOInfo virtualIOInfo, OmCecMgr omCecMgr) throws PIHscServerException {
        UnsignedInt16[] unsignedInt16Array = virtualIOInfo.virtualLanSlotIDs;
        UnsignedInt8[] unsignedInt8Array = virtualIOInfo.trunk;
        UnsignedInt16[] unsignedInt16Array2 = virtualIOInfo.pVLANID;
        UnsignedInt16[] unsignedInt16Array3 = virtualIOInfo.addVlanNum;
        UnsignedInt16[] unsignedInt16Array4 = virtualIOInfo.addVlans;
        if (unsignedInt16Array != null && unsignedInt16Array.length > 0) {
            System.out.println("\nPIResourcesAllocationUtils.checkVLANConfig() - VLAN adapters exist\n");
            Vector vector = null;
            RObject rObject = null;
            String string = "";
            String string2 = "";
            UnsignedInt16 unsignedInt16 = unsignedInt16Array2[0];
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            for (int i = 0; i < unsignedInt16Array.length; ++i) {
                if (unsignedInt8Array[i].intValue() != 1) continue;
                System.out.println("\nPIResourcesAllocationUtils.checkVLANConfig() - Checking VIO slot " + unsignedInt16Array[i] + "\n");
                unsignedInt16 = unsignedInt16Array2[i];
                n2 = 0;
                do {
                    System.out.println("\nPIResourcesAllocationUtils.checkVLANConfig() - Checking for trunk adapters on VLAN " + unsignedInt16 + "\n");
                    vector = PIResourcesAllocationUtils.getTrunkAdapterList(omCecMgr, unsignedInt16);
                    if (vector != null && vector.size() > 0) {
                        rObject = (RObject)vector.firstElement();
                        try {
                            n = ((UnsignedInt8)((RObject)rObject.associators(R50Define.AID_IBMHSC_LparVirtualEthernet).firstElement()).getProperty("PartitionState")).intValue();
                            string = (String)rObject.getProperty("SystemName");
                            string2 = (String)rObject.getProperty("Name");
                        }
                        catch (RException rException) {
                            // empty catch block
                        }
                        if (n != 0) {
                            throw new PIHscServerException("0282", new String[]{unsignedInt16Array[i].toString(), string.substring(0, string.indexOf("*")), string2}, null);
                        }
                    }
                    if (unsignedInt16Array4 == null || n3 >= unsignedInt16Array4.length) continue;
                    unsignedInt16 = unsignedInt16Array4[n3++];
                } while (n2++ < unsignedInt16Array3[i].intValue());
            }
        }
    }

    public String convertMem(long l) {
        String string = "";
        long l2 = 0L;
        string = l == 0L ? "0 MB" : ((l2 = l / 1024L) == 0L ? l + " MB" : l2 + " GB " + l % 1024L + " MB");
        return string;
    }

    public static CIMObjectPath constructCecPath(String string, String string2) {
        CIMObjectPath cIMObjectPath = new CIMObjectPath("IBMHSC_ComputerSystem", string2);
        cIMObjectPath.addKey("CreationClassName", new CIMValue((Object)"IBMHSC_ComputerSystem"));
        cIMObjectPath.addKey("Name", new CIMValue((Object)string));
        return cIMObjectPath;
    }

    public static int parseLparID(String string) {
        return Integer.parseInt(string.substring(0, string.indexOf(42)));
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void doSetPendingIO(UnsignedInt16 unsignedInt16, UnsignedInt32[] unsignedInt32Array, UnsignedInt8[] unsignedInt8Array, UnsignedInt16[] unsignedInt16Array, UnsignedInt32[] unsignedInt32Array2, UnsignedInt32 unsignedInt32, UnsignedInt32 unsignedInt322, UnsignedInt32 unsignedInt323, UnsignedInt32 unsignedInt324, UnsignedInt32 unsignedInt325, OmCecMgr omCecMgr) throws PIHscServerException {
        FspCmdHelper fspCmdHelper = omCecMgr.getCmdHelper();
        OmCecActResourceUpdater omCecActResourceUpdater = new OmCecActResourceUpdater(omCecMgr);
        try {
            void var27_43;
            void var25_36;
            CmdExtendedError[] cmdExtendedErrorArray;
            Object object;
            UnsignedInt32 unsignedInt326;
            Object object2;
            Object object3;
            int n;
            int n2 = unsignedInt16.intValue();
            String string = omCecMgr.getCecName();
            String string2 = String.valueOf(n2) + "*" + string;
            System.out.println("lparName: " + string2);
            if (null != unsignedInt32Array) {
                if (unsignedInt16Array != null) {
                    for (n = 0; n < unsignedInt32Array.length; ++n) {
                        block51: {
                            object3 = omCecMgr.drcIndexToFullLocCode(unsignedInt32Array[n]);
                            try {
                                fspCmdHelper.setIoSlotOwnerAndPoolId(unsignedInt32Array[n], unsignedInt16, unsignedInt16Array[n], unsignedInt8Array[n]);
                            }
                            catch (PIHscCmdMgrException pIHscCmdMgrException) {
                                if (unsignedInt8Array[n].intValue() == 1) break block51;
                                if (!pIHscCmdMgrException.getHscExId().equals("1552") && !pIHscCmdMgrException.getHscExId().equals("1400")) throw pIHscCmdMgrException;
                                throw new PIHscServerException("063B", new String[]{object3}, pIHscCmdMgrException);
                            }
                        }
                        omCecActResourceUpdater.updateAddIoSlotOwnerAndPoolId(string2, unsignedInt32Array[n], unsignedInt16Array[n]);
                    }
                } else {
                    for (n = 0; n < unsignedInt32Array.length; ++n) {
                        block52: {
                            object3 = omCecMgr.drcIndexToFullLocCode(unsignedInt32Array[n]);
                            try {
                                fspCmdHelper.setIoSlotOwnerAndPoolId(unsignedInt32Array[n], unsignedInt16, new UnsignedInt16(65535), unsignedInt8Array[n]);
                            }
                            catch (PIHscCmdMgrException pIHscCmdMgrException) {
                                if (unsignedInt8Array[n].intValue() == 1) break block52;
                                if (!pIHscCmdMgrException.getHscExId().equals("1552") && !pIHscCmdMgrException.getHscExId().equals("1400")) throw pIHscCmdMgrException;
                                throw new PIHscServerException("063B", new String[]{object3}, pIHscCmdMgrException);
                            }
                        }
                        omCecActResourceUpdater.updateAddIoSlotOwnerAndPoolId(string2, unsignedInt32Array[n], null);
                    }
                }
            }
            if (null != unsignedInt32Array2) {
                for (n = 0; n < unsignedInt32Array2.length; ++n) {
                    object3 = omCecMgr.drcIndexToFullLocCode(unsignedInt32Array2[n]);
                    try {
                        fspCmdHelper.setIoSlotOwnerAndPoolId(unsignedInt32Array2[n], new UnsignedInt16(65535), new UnsignedInt16(65535), new UnsignedInt8(1));
                    }
                    catch (PIHscCmdMgrException pIHscCmdMgrException) {
                        if (pIHscCmdMgrException.isExtendedError()) {
                            object2 = pIHscCmdMgrException.getExtendedError();
                            unsignedInt326 = ((CmdExtendedErrorList)object2).getErrorArray();
                            if (unsignedInt326 != null && ((CmdExtendedError[])unsignedInt326).length > 0) {
                                object = unsignedInt326[0];
                                long l = ((CmdExtendedError)object).extractErrorCode();
                                if (l == 0x40000144L) {
                                    System.out.println("switchale towers");
                                }
                                if (!pIHscCmdMgrException.getHscExId().equals("1552") && !pIHscCmdMgrException.getHscExId().equals("1400")) throw pIHscCmdMgrException;
                                throw new PIHscServerException("063B", new String[]{object3}, pIHscCmdMgrException);
                            }
                            if (!pIHscCmdMgrException.getHscExId().equals("1552") && !pIHscCmdMgrException.getHscExId().equals("1400")) throw pIHscCmdMgrException;
                            throw new PIHscServerException("063B", new String[]{object3}, pIHscCmdMgrException);
                        }
                        if (!pIHscCmdMgrException.getHscExId().equals("1552") && !pIHscCmdMgrException.getHscExId().equals("1400")) throw pIHscCmdMgrException;
                        throw new PIHscServerException("063B", new String[]{object3}, pIHscCmdMgrException);
                    }
                    omCecActResourceUpdater.updateRemoveIoSlotOwnerAndPoolId(unsignedInt32Array2[n]);
                }
            }
            OmLparMgr omLparMgr = omCecMgr.getLparMgr(string2);
            if (null == unsignedInt32) return;
            object3 = omLparMgr.getObject();
            UnsignedInt32 unsignedInt327 = new UnsignedInt32(0L);
            object2 = unsignedInt327;
            unsignedInt326 = unsignedInt327;
            object = unsignedInt327;
            UnsignedInt32 unsignedInt328 = unsignedInt327;
            UnsignedInt32 unsignedInt329 = unsignedInt327;
            UnsignedInt32 unsignedInt3210 = unsignedInt327;
            UnsignedInt32 unsignedInt3211 = unsignedInt327;
            UnsignedInt32 unsignedInt3212 = unsignedInt327;
            UnsignedInt32 unsignedInt3213 = unsignedInt327;
            UnsignedInt32 unsignedInt3214 = unsignedInt327;
            try {
                object2 = (UnsignedInt32)((RObject)object3).getProperty("LoadSourceDRCIndex");
                unsignedInt326 = (UnsignedInt32)((RObject)object3).getProperty("AltLoadSourceDRCIndex");
                object = (UnsignedInt32)((RObject)object3).getProperty("ConsoleDRCIndex");
                unsignedInt328 = (UnsignedInt32)((RObject)object3).getProperty("AltConsoleDRCIndex");
                unsignedInt329 = (UnsignedInt32)((RObject)object3).getProperty("ECSDRCIndex");
                Vector vector = (Vector)((RObject)object3).getProperty("TaggedIOInfo");
                if (vector != null && vector.size() > 0) {
                    int n3 = vector.size();
                    if (n3 > 0) {
                        if (vector.elementAt(0) != null && ((Boolean)vector.elementAt(0)).booleanValue()) {
                            cmdExtendedErrorArray = fspCmdHelper.getVirtualIoDrcIndexAndName(unsignedInt16, new UnsignedInt16(unsignedInt32.intValue()));
                            UnsignedInt32 unsignedInt3215 = (UnsignedInt32)cmdExtendedErrorArray.get("DRC_INDEX");
                        } else {
                            Object object4 = object2;
                        }
                    } else {
                        Object object5 = object2;
                    }
                    if (n3 > 1) {
                        if (vector.elementAt(1) != null && ((Boolean)vector.elementAt(1)).booleanValue()) {
                            cmdExtendedErrorArray = fspCmdHelper.getVirtualIoDrcIndexAndName(unsignedInt16, new UnsignedInt16(unsignedInt322.intValue()));
                            unsignedInt3211 = (UnsignedInt32)cmdExtendedErrorArray.get("DRC_INDEX");
                        } else {
                            unsignedInt3211 = unsignedInt326;
                        }
                    } else {
                        unsignedInt3211 = unsignedInt326;
                    }
                    if (n3 > 2) {
                        if (vector.elementAt(2) != null && ((Boolean)vector.elementAt(2)).booleanValue()) {
                            cmdExtendedErrorArray = fspCmdHelper.getVirtualIoDrcIndexAndName(unsignedInt16, new UnsignedInt16(unsignedInt323.intValue()));
                            UnsignedInt32 unsignedInt3216 = (UnsignedInt32)cmdExtendedErrorArray.get("DRC_INDEX");
                        } else {
                            Object object6 = object;
                        }
                    } else {
                        Object object7 = object;
                    }
                    if (n3 > 3) {
                        if (vector.elementAt(3) != null && ((Boolean)vector.elementAt(3)).booleanValue()) {
                            cmdExtendedErrorArray = fspCmdHelper.getVirtualIoDrcIndexAndName(unsignedInt16, new UnsignedInt16(unsignedInt324.intValue()));
                            unsignedInt3213 = (UnsignedInt32)cmdExtendedErrorArray.get("DRC_INDEX");
                        } else {
                            unsignedInt3213 = unsignedInt328;
                        }
                    } else {
                        unsignedInt3213 = unsignedInt328;
                    }
                    if (n3 > 4) {
                        if (vector.elementAt(4) != null && ((Boolean)vector.elementAt(4)).booleanValue()) {
                            cmdExtendedErrorArray = fspCmdHelper.getVirtualIoDrcIndexAndName(unsignedInt16, new UnsignedInt16(unsignedInt325.intValue()));
                            unsignedInt3214 = (UnsignedInt32)cmdExtendedErrorArray.get("DRC_INDEX");
                        } else {
                            unsignedInt3214 = unsignedInt329;
                        }
                    } else {
                        unsignedInt3214 = unsignedInt329;
                    }
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            System.out.println("curLoadSrcDrcIndex = " + var25_36);
            System.out.println("loadSrcDrcIndex = " + unsignedInt32);
            System.out.println("curAltLoadSrcDrcIndex = " + unsignedInt3211);
            System.out.println("altLoadSrcDrcIndex = " + unsignedInt322);
            System.out.println("curConsoleDrcIndex = " + var27_43);
            System.out.println("consoleDrcIndex = " + unsignedInt323);
            System.out.println(" curAltConsoleDrcIndex= " + unsignedInt3213);
            System.out.println(" altConsoleDrcIndex= " + unsignedInt324);
            System.out.println("curEcsDrcIndex = " + unsignedInt3214);
            System.out.println("ecsDrcIndex = " + unsignedInt325);
            if (var25_36.equals((Object)unsignedInt32) && unsignedInt3211.equals((Object)unsignedInt322) && var27_43.equals((Object)unsignedInt323) && unsignedInt3213.equals((Object)unsignedInt324) && unsignedInt3214.equals((Object)unsignedInt325)) return;
            FspTaggedIosForOs400 fspTaggedIosForOs400 = new FspTaggedIosForOs400();
            fspTaggedIosForOs400.setLoadSrcDrcIndex(unsignedInt32);
            fspTaggedIosForOs400.setAltLoadSrcDrcIndex(unsignedInt322);
            fspTaggedIosForOs400.setConsoleDrcIndex(unsignedInt323);
            fspTaggedIosForOs400.setAltConsoleDrcIndex(unsignedInt324);
            fspTaggedIosForOs400.setEcsDrcIndex(unsignedInt325);
            try {
                fspCmdHelper.setTaggedIosForOs400(unsignedInt16, fspTaggedIosForOs400);
                return;
            }
            catch (PIHscCmdMgrException pIHscCmdMgrException) {
                if (pIHscCmdMgrException.isExtendedError()) {
                    CmdExtendedErrorList cmdExtendedErrorList = pIHscCmdMgrException.getExtendedError();
                    cmdExtendedErrorArray = cmdExtendedErrorList.getErrorArray();
                    if (cmdExtendedErrorArray == null || cmdExtendedErrorArray.length <= 0) throw new PIHscServerException("063C", pIHscCmdMgrException);
                    CmdExtendedError cmdExtendedError = cmdExtendedErrorArray[0];
                    long l = cmdExtendedError.extractErrorCode();
                    if (l == 536871206L) {
                        System.out.println("WARNING --> NOT OWNED BY PARTITION");
                    } else {
                        if (!pIHscCmdMgrException.getHscExId().equals("1552") && !pIHscCmdMgrException.getHscExId().equals("1400")) throw pIHscCmdMgrException;
                        throw new PIHscServerException("063C", pIHscCmdMgrException);
                    }
                }
                OmLparActResourceUpdater omLparActResourceUpdater = new OmLparActResourceUpdater(omLparMgr);
                omLparActResourceUpdater.updateTaggedIoForOS400();
            }
            return;
        }
        catch (Throwable throwable) {
            try {
                HSCLogUtils.serverLog(throwable, HSCLogUtils._LPARClassLogInfo);
            }
            catch (Throwable throwable2) {
                // empty catch block
            }
            throwable.printStackTrace();
            if (throwable instanceof PIHscServerException) throw (PIHscServerException)throwable;
            throw new PIHscServerException("0620", null);
        }
        finally {
            Trace.trace("appahscT", "PIResourcesAllocationUtils.doSetPendingIO <-");
        }
    }

    public static void setLparIOPools(UnsignedInt16 unsignedInt16, Vector vector, OmCecMgr omCecMgr) throws PIHscServerException {
        Object object;
        Object object2;
        Trace.trace("appahscT", "-> PIResourcesAllocationUtils.setLparIOPools");
        Trace.trace("appahscF", "actLparID = " + unsignedInt16);
        Trace.trace("appahscF", "lparIOPools = " + vector);
        Trace.trace("appahscF", "cecMgr = " + omCecMgr);
        String string = unsignedInt16 + "*" + omCecMgr.getCecName();
        OmLparMgr omLparMgr = null;
        try {
            omLparMgr = omCecMgr.getLparMgr(string);
        }
        catch (Throwable throwable) {
            throw new PIHscServerException("2916", null);
        }
        RObject rObject = omLparMgr.getObject();
        Vector vector2 = null;
        if (vector != null) {
            vector2 = (Vector)vector.clone();
        }
        boolean bl = false;
        Vector vector3 = null;
        try {
            vector3 = rObject.associators(R50Define.AID_IBMHSC_LparInIOFailOverPool);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        System.out.println(")))))))))))))))))))))))))))))))))");
        System.out.println("curLparPools = " + vector3);
        System.out.println("lparIOPools = " + vector);
        if (vector3 != null && vector3.size() > 0) {
            if (vector == null || vector.isEmpty()) {
                bl = true;
            } else {
                for (int i = 0; i < vector3.size(); ++i) {
                    object2 = (RObject)vector3.elementAt(i);
                    object = "";
                    try {
                        object = (String)((RObject)object2).getProperty("CollectionID");
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    UnsignedInt16 unsignedInt162 = new UnsignedInt16(Integer.parseInt((String)object));
                    if (!vector.contains(unsignedInt162)) {
                        bl = true;
                        break;
                    }
                    vector2.remove(unsignedInt162);
                }
            }
        } else {
            if (vector == null || vector.isEmpty()) {
                return;
            }
            bl = true;
        }
        if (bl || vector2 != null && vector2.isEmpty()) {
            UnsignedInt16[] unsignedInt16Array = new UnsignedInt16[]{};
            if (vector != null && vector.size() > 0) {
                unsignedInt16Array = vector.toArray(new UnsignedInt16[vector.size()]);
            }
            object2 = omCecMgr.getCmdHelper();
            ((FspCmdHelper)object2).setLparIoPoolConfiguration(unsignedInt16, unsignedInt16Array);
            try {
                object = new OmLparActResourceUpdater(omLparMgr);
                ((OmLparActResourceUpdater)object).setLparIOPools(vector);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    public static void setPendingIO(UnsignedInt16 unsignedInt16, AllocIOAndLparInfo allocIOAndLparInfo, UnsignedInt32 unsignedInt32, UnsignedInt32 unsignedInt322, UnsignedInt32 unsignedInt323, UnsignedInt32 unsignedInt324, UnsignedInt32 unsignedInt325, OmCecMgr omCecMgr) throws PIHscServerException {
        Trace.trace("appahscT", "-> PIResourcesAllocationUtils.setPendingIO");
        Trace.trace("appahscF", "actLparID = " + unsignedInt16);
        Trace.trace("appahscF", "pendingResInfo = " + allocIOAndLparInfo);
        Trace.trace("appahscF", "loadSrcDrcIndex = " + unsignedInt32);
        Trace.trace("appahscF", "altLoadSrcDrcIndex = " + unsignedInt322);
        Trace.trace("appahscF", "consoleDrcIndex = " + unsignedInt323);
        Trace.trace("appahscF", "altConsoleDrcIndex = " + unsignedInt324);
        Trace.trace("appahscF", "ecsDrcIndex = " + unsignedInt325);
        Trace.trace("appahscF", "cecMgr = " + omCecMgr);
        if (allocIOAndLparInfo == null) {
            return;
        }
        UnsignedInt32[] unsignedInt32Array = allocIOAndLparInfo.allocatedIOs;
        UnsignedInt16[] unsignedInt16Array = allocIOAndLparInfo.allocatedIOPools;
        UnsignedInt8[] unsignedInt8Array = allocIOAndLparInfo.priorityFlags;
        UnsignedInt32[] unsignedInt32Array2 = allocIOAndLparInfo.freeIOs;
        PIResourcesAllocationUtils.doSetPendingIO(unsignedInt16, unsignedInt32Array, unsignedInt8Array, unsignedInt16Array, unsignedInt32Array2, unsignedInt32, unsignedInt322, unsignedInt323, unsignedInt324, unsignedInt325, omCecMgr);
        Trace.trace("appahscT", "PIResourcesAllocationUtils.setPendingIO <-");
    }

    public static void setPendingProc(UnsignedInt16 unsignedInt16, AllocProcAndLparInfo allocProcAndLparInfo, FspLparProcessingInfo fspLparProcessingInfo, OmCecMgr omCecMgr) throws PIHscServerException {
        Trace.trace("appahscT", "-> PIResourcesAllocationUtils.setPendingProc");
        Trace.trace("appahscF", "actLparID = " + unsignedInt16);
        Trace.trace("appahscF", "pendingProcInfo = " + allocProcAndLparInfo);
        Trace.trace("appahscF", "profProcData = " + fspLparProcessingInfo);
        Trace.trace("appahscF", "cecMgr = " + omCecMgr);
        FspCmdHelper fspCmdHelper = omCecMgr.getCmdHelper();
        try {
            UnsignedInt16 unsignedInt162;
            String string = omCecMgr.getCecName();
            OmLparMgr omLparMgr = omCecMgr.getLparMgr(unsignedInt16 + "*" + string);
            RObject rObject = omLparMgr.getObject();
            UnsignedInt8 unsignedInt8 = (UnsignedInt8)rObject.getProperty("PendProcMode");
            UnsignedInt8 unsignedInt82 = (UnsignedInt8)rObject.getProperty("PendSharingMode");
            UnsignedInt8 unsignedInt83 = fspLparProcessingInfo.getProcType();
            UnsignedInt8 unsignedInt84 = fspLparProcessingInfo.getSharingMode();
            UnsignedInt16 unsignedInt163 = fspLparProcessingInfo.getMinProcs();
            UnsignedInt16 unsignedInt164 = fspLparProcessingInfo.getMaxProcs();
            UnsignedInt32 unsignedInt32 = null;
            UnsignedInt32 unsignedInt322 = null;
            UnsignedInt32 unsignedInt323 = null;
            UnsignedInt8 unsignedInt85 = null;
            UnsignedInt16 unsignedInt165 = new UnsignedInt16(0);
            UnsignedInt16 unsignedInt166 = new UnsignedInt16(0);
            UnsignedInt16 unsignedInt167 = new UnsignedInt16(0);
            UnsignedInt32 unsignedInt324 = new UnsignedInt32(0L);
            UnsignedInt32 unsignedInt325 = new UnsignedInt32(0L);
            UnsignedInt32 unsignedInt326 = new UnsignedInt32(0L);
            UnsignedInt8 unsignedInt86 = new UnsignedInt8(0);
            try {
                unsignedInt165 = (UnsignedInt16)rObject.getProperty("PendMinProcs");
                unsignedInt166 = (UnsignedInt16)rObject.getProperty("PendAllocProcs");
                unsignedInt167 = (UnsignedInt16)rObject.getProperty("PendMaxProcs");
                unsignedInt324 = (UnsignedInt32)rObject.getProperty("PendMinProcUnits");
                unsignedInt325 = (UnsignedInt32)rObject.getProperty("PendAllocProcUnits");
                unsignedInt326 = (UnsignedInt32)rObject.getProperty("PendMaxProcUnits");
                unsignedInt86 = (UnsignedInt8)rObject.getProperty("PendUncappedWeight");
                if (unsignedInt86 == null) {
                    unsignedInt86 = new UnsignedInt8(0);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (255 != unsignedInt83.intValue()) {
                unsignedInt162 = fspLparProcessingInfo.getAllocProcs();
                if (allocProcAndLparInfo.allocatedProc != null) {
                    unsignedInt162 = allocProcAndLparInfo.allocatedProc;
                }
                unsignedInt32 = fspLparProcessingInfo.getMinProcUnits();
                unsignedInt322 = allocProcAndLparInfo.allocatedProcUnits;
                unsignedInt323 = fspLparProcessingInfo.getMaxProcUnits();
                unsignedInt85 = fspLparProcessingInfo.getUncappedWeight();
                if (unsignedInt85 == null) {
                    unsignedInt85 = new UnsignedInt8(0);
                }
            } else {
                unsignedInt162 = allocProcAndLparInfo.allocatedProc;
                unsignedInt32 = new UnsignedInt32((long)(unsignedInt163.intValue() * 100));
                unsignedInt322 = new UnsignedInt32((long)(unsignedInt162.intValue() * 100));
                unsignedInt323 = new UnsignedInt32((long)(unsignedInt164.intValue() * 100));
                unsignedInt85 = new UnsignedInt8(0);
            }
            if (unsignedInt8 == null || 255 == unsignedInt8.intValue()) {
                if (255 != unsignedInt83.intValue()) {
                    try {
                        fspCmdHelper.setLparPendingProcessoringMode(unsignedInt16, unsignedInt83, unsignedInt84);
                    }
                    catch (PIHscCmdMgrException pIHscCmdMgrException) {
                        if (pIHscCmdMgrException.getHscExId().equals("1552") || pIHscCmdMgrException.getHscExId().equals("1400")) {
                            throw new PIHscServerException("063D", pIHscCmdMgrException);
                        }
                        throw pIHscCmdMgrException;
                    }
                    try {
                        fspCmdHelper.setLparPendingSharedProcessors(unsignedInt16, unsignedInt83, unsignedInt163, unsignedInt162, unsignedInt164, unsignedInt32, unsignedInt322, unsignedInt323, unsignedInt85);
                    }
                    catch (PIHscCmdMgrException pIHscCmdMgrException) {
                        if (pIHscCmdMgrException.getHscExId().equals("1552") || pIHscCmdMgrException.getHscExId().equals("1400")) {
                            throw new PIHscServerException("063E", pIHscCmdMgrException);
                        }
                        throw pIHscCmdMgrException;
                    }
                }
                if (!(unsignedInt163.equals((Object)unsignedInt165) && unsignedInt162.equals((Object)unsignedInt166) && unsignedInt164.equals((Object)unsignedInt167))) {
                    try {
                        fspCmdHelper.setLparPendingDedicatedProcessors(unsignedInt16, unsignedInt163, unsignedInt162, unsignedInt164);
                    }
                    catch (PIHscCmdMgrException pIHscCmdMgrException) {
                        if (pIHscCmdMgrException.getHscExId().equals("1552") || pIHscCmdMgrException.getHscExId().equals("1400")) {
                            throw new PIHscServerException("063E", pIHscCmdMgrException);
                        }
                        throw pIHscCmdMgrException;
                    }
                }
                if (unsignedInt82 == null || unsignedInt84 == null || !unsignedInt82.equals((Object)unsignedInt84)) {
                    System.out.println("pendSharingMode = " + unsignedInt82);
                    System.out.println("sharingMode = " + unsignedInt84);
                    try {
                        fspCmdHelper.setLparPendingProcessoringMode(unsignedInt16, unsignedInt83, unsignedInt84);
                    }
                    catch (PIHscCmdMgrException pIHscCmdMgrException) {
                        if (pIHscCmdMgrException.getHscExId().equals("1552") || pIHscCmdMgrException.getHscExId().equals("1400")) {
                            throw new PIHscServerException("063D", pIHscCmdMgrException);
                        }
                        throw pIHscCmdMgrException;
                    }
                }
            } else {
                if (unsignedInt82 == null || unsignedInt84 == null || !unsignedInt82.equals((Object)unsignedInt84)) {
                    if (!(unsignedInt82 != null && unsignedInt82.intValue() != 0 || unsignedInt84 != null && unsignedInt84.intValue() != 1)) {
                        if (!(unsignedInt163.equals((Object)unsignedInt165) && unsignedInt162.equals((Object)unsignedInt166) && unsignedInt164.equals((Object)unsignedInt167) && unsignedInt32.equals((Object)unsignedInt324) && unsignedInt322.equals((Object)unsignedInt325) && unsignedInt323.equals((Object)unsignedInt326))) {
                            fspCmdHelper.setLparPendingSharedProcessors(unsignedInt16, unsignedInt8, unsignedInt163, unsignedInt162, unsignedInt164, unsignedInt32, unsignedInt322, unsignedInt323, new UnsignedInt8(0));
                        }
                    } else {
                        fspCmdHelper.setLparPendingSharedProcessors(unsignedInt16, unsignedInt8, new UnsignedInt16(65535), new UnsignedInt16(65535), new UnsignedInt16(65535), new UnsignedInt32(-1L), new UnsignedInt32(-1L), new UnsignedInt32(-1L), unsignedInt85);
                    }
                    fspCmdHelper.setLparPendingProcessoringMode(unsignedInt16, unsignedInt8, unsignedInt84);
                }
                if (!(unsignedInt163.equals((Object)unsignedInt165) && unsignedInt162.equals((Object)unsignedInt166) && unsignedInt164.equals((Object)unsignedInt167) && unsignedInt32.equals((Object)unsignedInt324) && unsignedInt322.equals((Object)unsignedInt325) && unsignedInt323.equals((Object)unsignedInt326) && unsignedInt85.equals((Object)unsignedInt86))) {
                    fspCmdHelper.setLparPendingSharedProcessors(unsignedInt16, unsignedInt8, unsignedInt163, unsignedInt162, unsignedInt164, unsignedInt32, unsignedInt322, unsignedInt323, unsignedInt85);
                }
                System.out.println(")))))))))))))))))))))))))))))");
                System.out.println("procMode.intValue() = " + unsignedInt83.intValue());
                System.out.println("pendSharingMode = " + unsignedInt82);
                System.out.println("sharingMode = " + unsignedInt84);
                boolean bl = 255 == unsignedInt83.intValue() || unsignedInt82 == null || unsignedInt84 == null || !unsignedInt82.equals((Object)unsignedInt84);
                boolean bl2 = 255 != unsignedInt83.intValue() && (unsignedInt82 == null || unsignedInt82.intValue() == 1) && unsignedInt84 != null && unsignedInt84.intValue() == 0;
                System.out.println("bool0 = " + bl);
                System.out.println("bool1 = " + bl2);
                System.out.println("((((((((((((((((((((((((((((");
                if (255 == unsignedInt83.intValue() || unsignedInt82 == null || unsignedInt84 == null || !unsignedInt82.equals((Object)unsignedInt84) || 255 != unsignedInt83.intValue() && (unsignedInt82 == null || unsignedInt82.intValue() == 1) && unsignedInt84 != null && unsignedInt84.intValue() == 0) {
                    fspCmdHelper.setLparPendingProcessoringMode(unsignedInt16, unsignedInt83, unsignedInt84);
                }
            }
            OmLparActResourceUpdater omLparActResourceUpdater = new OmLparActResourceUpdater(omLparMgr);
            omLparActResourceUpdater.updateLparPendProcInfo(unsignedInt83, unsignedInt84, unsignedInt163, unsignedInt162, unsignedInt164, unsignedInt32, unsignedInt322, unsignedInt323, unsignedInt85);
            OmCecInstUpdater omCecInstUpdater = new OmCecInstUpdater(omCecMgr);
            omCecInstUpdater.updatePhypAvailProcData();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            if (!(throwable instanceof PIHscServerException)) {
                throw new PIHscServerException("061F", null);
            }
            throw (PIHscServerException)throwable;
        }
    }

    public static void setPendingProc(UnsignedInt16 unsignedInt16, FspLparProcessingInfo fspLparProcessingInfo, OmCecMgr omCecMgr) throws PIHscServerException {
        Trace.trace("appahscT", "-> PIResourcesAllocationUtils.setPendingProc");
        Trace.trace("appahscF", "actLparID = " + unsignedInt16);
        Trace.trace("appahscF", "procData = " + fspLparProcessingInfo);
        Trace.trace("appahscF", "cecMgr = " + omCecMgr);
        FspCmdHelper fspCmdHelper = omCecMgr.getCmdHelper();
        try {
            String string = omCecMgr.getCecName();
            OmLparMgr omLparMgr = omCecMgr.getLparMgr(unsignedInt16 + "*" + string);
            RObject rObject = omLparMgr.getObject();
            UnsignedInt8 unsignedInt8 = (UnsignedInt8)rObject.getProperty("PendProcMode");
            UnsignedInt8 unsignedInt82 = (UnsignedInt8)rObject.getProperty("PendSharingMode");
            UnsignedInt8 unsignedInt83 = fspLparProcessingInfo.getProcType();
            UnsignedInt8 unsignedInt84 = fspLparProcessingInfo.getSharingMode();
            UnsignedInt16 unsignedInt162 = fspLparProcessingInfo.getMinProcs();
            UnsignedInt16 unsignedInt163 = fspLparProcessingInfo.getAllocProcs();
            UnsignedInt16 unsignedInt164 = fspLparProcessingInfo.getMaxProcs();
            UnsignedInt32 unsignedInt32 = null;
            UnsignedInt32 unsignedInt322 = null;
            UnsignedInt32 unsignedInt323 = null;
            UnsignedInt8 unsignedInt85 = null;
            UnsignedInt16 unsignedInt165 = new UnsignedInt16(0);
            UnsignedInt16 unsignedInt166 = new UnsignedInt16(0);
            UnsignedInt16 unsignedInt167 = new UnsignedInt16(0);
            UnsignedInt32 unsignedInt324 = new UnsignedInt32(0L);
            UnsignedInt32 unsignedInt325 = new UnsignedInt32(0L);
            UnsignedInt32 unsignedInt326 = new UnsignedInt32(0L);
            try {
                unsignedInt165 = (UnsignedInt16)rObject.getProperty("PendMinProcs");
                unsignedInt166 = (UnsignedInt16)rObject.getProperty("PendAllocProcs");
                unsignedInt167 = (UnsignedInt16)rObject.getProperty("PendMaxProcs");
                unsignedInt324 = (UnsignedInt32)rObject.getProperty("PendMinProcUnits");
                unsignedInt325 = (UnsignedInt32)rObject.getProperty("PendAllocProcUnits");
                unsignedInt326 = (UnsignedInt32)rObject.getProperty("PendMaxProcUnits");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (255 != unsignedInt83.intValue()) {
                unsignedInt32 = fspLparProcessingInfo.getMinProcUnits();
                unsignedInt322 = fspLparProcessingInfo.getAllocProcUnits();
                unsignedInt323 = fspLparProcessingInfo.getMaxProcUnits();
                unsignedInt85 = fspLparProcessingInfo.getUncappedWeight();
            } else {
                unsignedInt32 = new UnsignedInt32((long)(unsignedInt162.intValue() * 100));
                unsignedInt322 = new UnsignedInt32((long)(unsignedInt163.intValue() * 100));
                unsignedInt323 = new UnsignedInt32((long)(unsignedInt164.intValue() * 100));
                unsignedInt85 = new UnsignedInt8(0);
            }
            if (unsignedInt8 == null || 255 == unsignedInt8.intValue()) {
                if (255 != unsignedInt83.intValue()) {
                    try {
                        fspCmdHelper.setLparPendingProcessoringMode(unsignedInt16, unsignedInt83, unsignedInt84);
                    }
                    catch (PIHscCmdMgrException pIHscCmdMgrException) {
                        if (pIHscCmdMgrException.getHscExId().equals("1552") || pIHscCmdMgrException.getHscExId().equals("1400")) {
                            throw new PIHscServerException("063D", pIHscCmdMgrException);
                        }
                        throw pIHscCmdMgrException;
                    }
                    try {
                        fspCmdHelper.setLparPendingSharedProcessors(unsignedInt16, unsignedInt83, unsignedInt162, unsignedInt163, unsignedInt164, unsignedInt32, unsignedInt322, unsignedInt323, unsignedInt85);
                    }
                    catch (PIHscCmdMgrException pIHscCmdMgrException) {
                        if (pIHscCmdMgrException.getHscExId().equals("1552") || pIHscCmdMgrException.getHscExId().equals("1400")) {
                            throw new PIHscServerException("063E", pIHscCmdMgrException);
                        }
                        throw pIHscCmdMgrException;
                    }
                }
                if (!(unsignedInt162.equals((Object)unsignedInt165) && unsignedInt163.equals((Object)unsignedInt166) && unsignedInt164.equals((Object)unsignedInt167))) {
                    try {
                        fspCmdHelper.setLparPendingDedicatedProcessors(unsignedInt16, unsignedInt162, unsignedInt163, unsignedInt164);
                    }
                    catch (PIHscCmdMgrException pIHscCmdMgrException) {
                        if (pIHscCmdMgrException.getHscExId().equals("1552") || pIHscCmdMgrException.getHscExId().equals("1400")) {
                            throw new PIHscServerException("063E", pIHscCmdMgrException);
                        }
                        throw pIHscCmdMgrException;
                    }
                }
                if (unsignedInt82 == null || unsignedInt84 == null || !unsignedInt82.equals((Object)unsignedInt84)) {
                    System.out.println("pendSharingMode = " + unsignedInt82);
                    System.out.println("sharingMode = " + unsignedInt84);
                    try {
                        fspCmdHelper.setLparPendingProcessoringMode(unsignedInt16, unsignedInt83, unsignedInt84);
                    }
                    catch (PIHscCmdMgrException pIHscCmdMgrException) {
                        if (pIHscCmdMgrException.getHscExId().equals("1552") || pIHscCmdMgrException.getHscExId().equals("1400")) {
                            throw new PIHscServerException("063D", pIHscCmdMgrException);
                        }
                        throw pIHscCmdMgrException;
                    }
                }
            } else {
                if (!(unsignedInt82 != null && unsignedInt84 != null && unsignedInt82.equals((Object)unsignedInt84) || unsignedInt82 != null && unsignedInt82.intValue() != 0 || unsignedInt84 != null && unsignedInt84.intValue() != 1)) {
                    fspCmdHelper.setLparPendingProcessoringMode(unsignedInt16, unsignedInt8, unsignedInt84);
                }
                if (!(unsignedInt162.equals((Object)unsignedInt165) && unsignedInt163.equals((Object)unsignedInt166) && unsignedInt164.equals((Object)unsignedInt167) && unsignedInt32.equals((Object)unsignedInt324) && unsignedInt322.equals((Object)unsignedInt325) && unsignedInt323.equals((Object)unsignedInt326))) {
                    fspCmdHelper.setLparPendingSharedProcessors(unsignedInt16, unsignedInt8, unsignedInt162, unsignedInt163, unsignedInt164, unsignedInt32, unsignedInt322, unsignedInt323, unsignedInt85);
                }
                if (255 == unsignedInt83.intValue() && (unsignedInt82 == null || unsignedInt84 == null || unsignedInt82 != unsignedInt84) || 255 != unsignedInt83.intValue() && (unsignedInt82 == null || unsignedInt82.intValue() == 1) && unsignedInt84 != null && unsignedInt84.intValue() == 0) {
                    fspCmdHelper.setLparPendingProcessoringMode(unsignedInt16, unsignedInt83, unsignedInt84);
                }
            }
            OmLparActResourceUpdater omLparActResourceUpdater = new OmLparActResourceUpdater(omLparMgr);
            omLparActResourceUpdater.updateLparPendProcInfo(unsignedInt83, unsignedInt84, unsignedInt162, unsignedInt163, unsignedInt164, unsignedInt32, unsignedInt322, unsignedInt323, unsignedInt85);
            OmCecInstUpdater omCecInstUpdater = new OmCecInstUpdater(omCecMgr);
            omCecInstUpdater.updatePhypAvailProcData();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            if (!(throwable instanceof PIHscServerException)) {
                throw new PIHscServerException("061F", null);
            }
            throw (PIHscServerException)throwable;
        }
    }

    public static void setPendingInteractivePerf(UnsignedInt16 unsignedInt16, UnsignedInt16 unsignedInt162, UnsignedInt16 unsignedInt163, UnsignedInt16 unsignedInt164, OmCecMgr omCecMgr) throws PIHscServerException {
        FspCmdHelper fspCmdHelper = omCecMgr.getCmdHelper();
        try {
            OmLparMgr omLparMgr = omCecMgr.getLparMgr(unsignedInt16 + "*" + omCecMgr.getCecName());
            RObject rObject = omLparMgr.getObject();
            UnsignedInt16 unsignedInt165 = new UnsignedInt16(0);
            UnsignedInt16 unsignedInt166 = new UnsignedInt16(0);
            UnsignedInt16 unsignedInt167 = new UnsignedInt16(0);
            try {
                unsignedInt165 = (UnsignedInt16)rObject.getProperty("PendMinInteractivePerf");
                unsignedInt166 = (UnsignedInt16)rObject.getProperty("PendAllocInteractivePerf");
                unsignedInt167 = (UnsignedInt16)rObject.getProperty("PendMaxInteractivePerf");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (!(unsignedInt162.equals((Object)unsignedInt165) && unsignedInt163.equals((Object)unsignedInt166) && unsignedInt164.equals((Object)unsignedInt167))) {
                fspCmdHelper.setLparPendingPerformance(unsignedInt16, unsignedInt162, unsignedInt163, unsignedInt164);
                OmLparActResourceUpdater omLparActResourceUpdater = new OmLparActResourceUpdater(omLparMgr);
                omLparActResourceUpdater.updateLparPendCPWInfo(unsignedInt162, unsignedInt163, unsignedInt164);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            if (!(throwable instanceof PIHscServerException)) {
                throw new PIHscServerException("061E", null);
            }
            throw (PIHscServerException)throwable;
        }
    }

    public static void setPendingVIO(UnsignedInt16 unsignedInt16, VirtualIOInfo virtualIOInfo, Set set, OmCecMgr omCecMgr) throws PIHscServerException {
        FspCmdHelper fspCmdHelper = omCecMgr.getCmdHelper();
        try {
            UnsignedInt8 unsignedInt8;
            UnsignedInt8 unsignedInt82;
            Object object;
            Object object2;
            Object object3;
            int n;
            Object object4;
            Hashtable<UnsignedInt16, Object> hashtable;
            UnsignedInt16 unsignedInt162;
            Object object5;
            UnsignedInt16[] unsignedInt16Array = virtualIOInfo.virSCSIServerLPARs;
            UnsignedInt16[] unsignedInt16Array2 = virtualIOInfo.virSCSIServerSlotNum;
            UnsignedInt16[] unsignedInt16Array3 = virtualIOInfo.virSCSIAdapters;
            UnsignedInt8[] unsignedInt8Array = virtualIOInfo.virSCSIDeviceAttributes;
            UnsignedInt8[] unsignedInt8Array2 = virtualIOInfo.virSCSISupportHMCClients;
            UnsignedInt8[] unsignedInt8Array3 = virtualIOInfo.virSCSIRequired;
            UnsignedInt16[] unsignedInt16Array4 = virtualIOInfo.virSerialServerLPARs;
            UnsignedInt16[] unsignedInt16Array5 = virtualIOInfo.virSerialServerSlotNum;
            UnsignedInt16[] unsignedInt16Array6 = virtualIOInfo.virSerialAdapters;
            UnsignedInt8[] unsignedInt8Array4 = virtualIOInfo.virSerialDeviceAttributes;
            UnsignedInt8[] unsignedInt8Array5 = virtualIOInfo.virSerialSupportHMCClients;
            UnsignedInt8[] unsignedInt8Array6 = virtualIOInfo.virSerialRequired;
            UnsignedInt16[] unsignedInt16Array7 = virtualIOInfo.virtualLanSlotIDs;
            UnsignedInt8[] unsignedInt8Array7 = virtualIOInfo.ieee;
            UnsignedInt8[] unsignedInt8Array8 = virtualIOInfo.trunk;
            UnsignedInt16[] unsignedInt16Array8 = virtualIOInfo.pVLANID;
            UnsignedInt16[] unsignedInt16Array9 = virtualIOInfo.addVlanNum;
            UnsignedInt16[] unsignedInt16Array10 = virtualIOInfo.addVlans;
            UnsignedInt8[] unsignedInt8Array9 = virtualIOInfo.vEthernetRequired;
            String string = (String)omCecMgr.getProperty("VirtualEthernetMACAddressPrefix");
            PIVirtualEthernetMACAddressUtils pIVirtualEthernetMACAddressUtils = new PIVirtualEthernetMACAddressUtils(omCecMgr);
            UnsignedInt16[] unsignedInt16Array11 = virtualIOInfo.virSMCASlotIDs;
            UnsignedInt32[] unsignedInt32Array = virtualIOInfo.virSMCAHubDrcIndices;
            UnsignedInt32[] unsignedInt32Array2 = virtualIOInfo.virSMCAIOBusIDs;
            UnsignedInt16[] unsignedInt16Array12 = virtualIOInfo.virSMCARemoteLparIDs;
            UnsignedInt16[] unsignedInt16Array13 = virtualIOInfo.virSMCARemoteSlotIDs;
            UnsignedInt8[] unsignedInt8Array10 = virtualIOInfo.virSMCARequired;
            OmLparMgr omLparMgr = omCecMgr.getLparMgr(unsignedInt16 + "*" + omCecMgr.getCecName());
            OmLparActResourceUpdater omLparActResourceUpdater = new OmLparActResourceUpdater(omLparMgr);
            if (null != set && set.size() > 0) {
                object5 = set.iterator();
                while (object5.hasNext()) {
                    unsignedInt162 = (UnsignedInt16)object5.next();
                    fspCmdHelper.clearVirtualIoSlotConfiguration(unsignedInt16, unsignedInt162);
                    omLparActResourceUpdater.clearVIO(unsignedInt162);
                }
            }
            object5 = omLparMgr.getObject();
            unsignedInt162 = new UnsignedInt16(0);
            try {
                unsignedInt162 = (UnsignedInt16)((RObject)object5).getProperty("PendMaxVirtualIOSlots");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            UnsignedInt16 unsignedInt163 = virtualIOInfo.maxVIOSlots;
            if (!unsignedInt163.equals((Object)unsignedInt162)) {
                fspCmdHelper.setLparPendingNumberOfVirtualSlots(unsignedInt16, unsignedInt163);
                try {
                    System.out.println("setMaxVirtualIOSlot");
                    ((RObject)object5).setProperty(R50Partition.Index_PendMaxVirtualIOSlots, (Object)unsignedInt163);
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
            if (null != unsignedInt16Array3 && unsignedInt16Array3.length > 0) {
                hashtable = new Hashtable<UnsignedInt16, Object>();
                object4 = new UnsignedInt8(0);
                for (n = 0; n < unsignedInt16Array3.length; ++n) {
                    object3 = new RObjectId(omCecMgr.getObject().getNameSpaceId(), R50Define.CID_IBMHSC_VirtualSCSI);
                    ((RObjectId)object3).setKeyValue(0, "IBMHSC_VirtualSCSI");
                    ((RObjectId)object3).setKeyValue(1, unsignedInt16Array3[n].toString());
                    ((RObjectId)object3).setKeyValue(2, "IBMHSC_Partition");
                    ((RObjectId)object3).setKeyValue(3, unsignedInt16.toString() + "*" + omCecMgr.getCecName());
                    RObject rObject = ((RObjectId)object3).getObject();
                    boolean bl = false;
                    if (rObject == null) {
                        bl = true;
                    } else {
                        object2 = null;
                        object = null;
                        unsignedInt82 = null;
                        unsignedInt8 = null;
                        try {
                            object2 = (UnsignedInt16)rObject.getProperty("RemoteLparID");
                            object = (UnsignedInt16)rObject.getProperty("RemoteSlotID");
                            unsignedInt82 = (UnsignedInt8)rObject.getProperty("SupportHMC");
                            unsignedInt8 = (UnsignedInt8)rObject.getProperty("Required");
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        if (!(unsignedInt16Array[n].equals(object2) && unsignedInt16Array2[n].equals(object) && object4.equals((Object)unsignedInt82) && unsignedInt8Array3[n].equals((Object)unsignedInt8))) {
                            bl = true;
                        }
                    }
                    if (!bl) continue;
                    object2 = new FspVioScsiConfig();
                    try {
                        ((FspVioScsiConfig)object2).setServerLparId(unsignedInt16Array[n]);
                        ((FspVioScsiConfig)object2).setServerVirtSlotNum(unsignedInt16Array2[n]);
                        ((FspVioScsiConfig)object2).setVirtDeviceClass(new UnsignedInt8(2));
                        ((FspVioScsiConfig)object2).setVirtDeviceAttr(unsignedInt8Array[n]);
                        ((FspVioScsiConfig)object2).setSupportHmcClient(new UnsignedInt8(0));
                        ((FspVioScsiConfig)object2).setPriorityFlag(unsignedInt8Array3[n]);
                        fspCmdHelper.setVirtualScsiSerialConfig(unsignedInt16, unsignedInt16Array3[n], (FspVioScsiConfig)object2);
                        object = new VioSlotState();
                        object.slotNumber = unsignedInt16Array3[n];
                        object.slotState = new UnsignedInt8(2);
                        hashtable.put(unsignedInt16Array3[n], object);
                        continue;
                    }
                    catch (Throwable throwable) {
                        if (unsignedInt8Array3[n] == null || unsignedInt8Array3[n].intValue() != 2) continue;
                        throw throwable;
                    }
                }
                if (!hashtable.isEmpty()) {
                    try {
                        omLparMgr.getLparVscsiUpdater().update(hashtable);
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                    }
                }
            }
            if (null != unsignedInt16Array6 && unsignedInt16Array6.length > 0) {
                hashtable = new Hashtable();
                for (int i = 0; i < unsignedInt16Array6.length; ++i) {
                    FspVioScsiConfig fspVioScsiConfig;
                    RObjectId rObjectId = new RObjectId(omCecMgr.getObject().getNameSpaceId(), R50Define.CID_IBMHSC_VirtualSerial);
                    rObjectId.setKeyValue(0, "IBMHSC_VirtualSerial");
                    rObjectId.setKeyValue(1, unsignedInt16Array6[i].toString());
                    rObjectId.setKeyValue(2, "IBMHSC_Partition");
                    rObjectId.setKeyValue(3, unsignedInt16.toString() + "*" + omCecMgr.getCecName());
                    object3 = rObjectId.getObject();
                    boolean bl = false;
                    if (object3 == null) {
                        bl = true;
                    } else {
                        fspVioScsiConfig = null;
                        object2 = null;
                        object = null;
                        unsignedInt82 = null;
                        unsignedInt8 = new UnsignedInt8(0);
                        try {
                            fspVioScsiConfig = (UnsignedInt16)((RObject)object3).getProperty("RemoteLparID");
                            object2 = (UnsignedInt16)((RObject)object3).getProperty("RemoteSlotID");
                            object = (UnsignedInt8)((RObject)object3).getProperty("SupportHMC");
                            unsignedInt82 = (UnsignedInt8)((RObject)object3).getProperty("Required");
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        if (!(unsignedInt16Array4[i].equals((Object)fspVioScsiConfig) && unsignedInt16Array5[i].equals(object2) && unsignedInt8.equals(object) && unsignedInt8Array6[i].equals((Object)unsignedInt82))) {
                            bl = true;
                        }
                    }
                    if (!bl) continue;
                    fspVioScsiConfig = new FspVioScsiConfig();
                    try {
                        fspVioScsiConfig.setServerLparId(unsignedInt16Array4[i]);
                        fspVioScsiConfig.setServerVirtSlotNum(unsignedInt16Array5[i]);
                        fspVioScsiConfig.setVirtDeviceClass(new UnsignedInt8(3));
                        fspVioScsiConfig.setVirtDeviceAttr(unsignedInt8Array4[i]);
                        fspVioScsiConfig.setSupportHmcClient(unsignedInt8Array5[i]);
                        fspVioScsiConfig.setPriorityFlag(unsignedInt8Array6[i]);
                        fspCmdHelper.setVirtualScsiSerialConfig(unsignedInt16, unsignedInt16Array6[i], fspVioScsiConfig);
                        object2 = new VioSlotState();
                        ((VioSlotState)object2).slotNumber = unsignedInt16Array6[i];
                        ((VioSlotState)object2).slotState = new UnsignedInt8(3);
                        hashtable.put(unsignedInt16Array6[i], object2);
                        continue;
                    }
                    catch (Throwable throwable) {
                        if (unsignedInt8Array6[i] == null || unsignedInt8Array6[i].intValue() != 2) continue;
                        throw throwable;
                    }
                }
                if (!hashtable.isEmpty()) {
                    try {
                        omLparMgr.getLparVserialUpdater().update(hashtable);
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                    }
                }
            }
            if (null != unsignedInt16Array7 && unsignedInt16Array7.length > 0) {
                System.out.println("VIO INFO EXIST");
                int n2 = 0;
                object4 = new Hashtable();
                for (n = 0; n < unsignedInt16Array7.length; ++n) {
                    object3 = new FspVioEtherConfig();
                    try {
                        ((FspVioEtherConfig)object3).setIsIEEE(unsignedInt8Array7[n]);
                        ((FspVioEtherConfig)object3).setPortVid(unsignedInt16Array8[n]);
                        ((FspVioEtherConfig)object3).setPortVid(unsignedInt16Array8[n]);
                        ((FspVioEtherConfig)object3).setPriority(unsignedInt8Array9[n]);
                        ((FspVioEtherConfig)object3).setIsTrunk(unsignedInt8Array8[n]);
                        ((FspVioEtherConfig)object3).setMACAddress(pIVirtualEthernetMACAddressUtils.getMACAddress(unsignedInt16, unsignedInt16Array7[n]));
                        int n3 = unsignedInt16Array9[n].intValue();
                        UnsignedInt16[] unsignedInt16Array14 = new UnsignedInt16[n3];
                        if (n3 != 0) {
                            System.arraycopy(unsignedInt16Array10, n2, unsignedInt16Array14, 0, n3);
                        }
                        ((FspVioEtherConfig)object3).setAdditionalVids(unsignedInt16Array14);
                        n2 += n3;
                        System.out.println(" vEthernetSetting = " + object3);
                        System.out.println(" vlanSlotIDs = " + unsignedInt16Array7[n]);
                        fspCmdHelper.setVirtualEthernetSlotConfiguration(unsignedInt16, unsignedInt16Array7[n], (FspVioEtherConfig)object3);
                        object2 = new VioSlotState();
                        ((VioSlotState)object2).slotNumber = unsignedInt16Array7[n];
                        ((VioSlotState)object2).slotState = new UnsignedInt8(1);
                        ((Hashtable)object4).put(unsignedInt16Array7[n], object2);
                        continue;
                    }
                    catch (Throwable throwable) {
                        if (unsignedInt8Array9[n] == null || unsignedInt8Array9[n].intValue() != 2) continue;
                        throw throwable;
                    }
                }
                try {
                    omLparMgr.getLparVethUpdater().update((Hashtable)object4);
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
            if (null != unsignedInt16Array11 && unsignedInt16Array11.length > 0) {
                Hashtable<UnsignedInt16, Object> hashtable2 = new Hashtable<UnsignedInt16, Object>();
                for (int i = 0; i < unsignedInt16Array11.length; ++i) {
                    FspVioSmcaConfig fspVioSmcaConfig = new FspVioSmcaConfig();
                    try {
                        fspVioSmcaConfig.setHubDrcIndex(unsignedInt32Array[i]);
                        fspVioSmcaConfig.setIOBusID(unsignedInt32Array2[i]);
                        fspVioSmcaConfig.setRemoteLparID(unsignedInt16Array12[i]);
                        fspVioSmcaConfig.setRemoteSlotID(unsignedInt16Array13[i]);
                        fspVioSmcaConfig.setRequired(unsignedInt8Array10[i]);
                        fspCmdHelper.setSharedMemoryClusterIO(unsignedInt16, unsignedInt16Array11[i], fspVioSmcaConfig);
                        object3 = new VioSlotState();
                        ((VioSlotState)object3).slotNumber = unsignedInt16Array11[i];
                        ((VioSlotState)object3).slotState = new UnsignedInt8(4);
                        hashtable2.put(unsignedInt16Array11[i], object3);
                        continue;
                    }
                    catch (Throwable throwable) {
                        if (unsignedInt8Array10[i] == null || unsignedInt8Array10[i].intValue() != 2) continue;
                        throw throwable;
                    }
                }
                try {
                    new OmLparVsmcaUpdater(omLparMgr).update(hashtable2);
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            if (!(throwable instanceof PIHscServerException)) {
                throw new PIHscServerException("061D", null);
            }
            throw (PIHscServerException)throwable;
        }
    }

    private static Vector getTrunkAdapterList(OmCecMgr omCecMgr, UnsignedInt16 unsignedInt16) {
        try {
            RObjectId rObjectId = new RObjectId(omCecMgr.getObject().getNameSpaceId(), R50Define.CID_IBMHSC_VLAN);
            rObjectId.setKeyValue(0, "IBMHSC_VLAN");
            rObjectId.setKeyValue(1, unsignedInt16.toString());
            rObjectId.setKeyValue(2, "IBMHSC_ComputerSystem");
            rObjectId.setKeyValue(3, omCecMgr.getCecName());
            RObject rObject = rObjectId.getObject();
            if (rObject != null) {
                System.out.println("\nPIResourcesAllocationUtils.getTrunkAdapterList() - Found a VLAN on VID " + unsignedInt16 + "\n");
                return rObject.associators(R50Define.AID_IBMHSC_VLANTrunk);
            }
            return null;
        }
        catch (RException rException) {
            return null;
        }
    }

    private static String buildMacAddressStr(String string, UnsignedInt16 unsignedInt16, UnsignedInt16 unsignedInt162) {
        String string2;
        int n;
        String string3 = ByteUtilities.toHexString((Number)unsignedInt16, 4);
        int n2 = string3.length();
        if (n2 > 4) {
            string3 = string3.substring(n2 - 4);
        }
        if ((n = (string2 = ByteUtilities.toHexString((Number)unsignedInt162, 3)).length()) > 3) {
            string2 = string2.substring(n - 3);
        }
        if (string.length() < 5) {
            string = string + "00000";
        }
        string = string.substring(0, 5);
        return string + string3 + string2;
    }

    public static void setPendingMemory(UnsignedInt16 unsignedInt16, UnsignedInt32 unsignedInt32, UnsignedInt32 unsignedInt322, UnsignedInt32 unsignedInt323, UnsignedInt8 unsignedInt8, OmCecMgr omCecMgr) throws PIHscServerException {
        FspCmdHelper fspCmdHelper = omCecMgr.getCmdHelper();
        RObject rObject = omCecMgr.getObject();
        UnsignedInt16 unsignedInt162 = null;
        UnsignedInt32 unsignedInt324 = unsignedInt322;
        UnsignedInt32 unsignedInt325 = new UnsignedInt32(-1L);
        UnsignedInt32 unsignedInt326 = new UnsignedInt32(-1L);
        try {
            unsignedInt162 = (UnsignedInt16)rObject.getProperty(R50ComputerSystem.Index_LMBSize);
        }
        catch (RException rException) {
            throw new PIHscServerException("2523", new String[]{"R50ComputerSystem.LMBSize"}, rException);
        }
        try {
            if (!unsignedInt323.equals((Object)unsignedInt325)) {
                unsignedInt325 = new UnsignedInt32(unsignedInt323.longValue() / unsignedInt162.longValue());
            }
            if (!unsignedInt32.equals((Object)unsignedInt326)) {
                unsignedInt326 = new UnsignedInt32(unsignedInt32.longValue() / unsignedInt162.longValue());
            }
            fspCmdHelper.setLparPendingMemory(unsignedInt16, unsignedInt8, unsignedInt326, new UnsignedInt32(unsignedInt322.longValue() / unsignedInt162.longValue()), unsignedInt325);
            try {
                OmLparMgr omLparMgr = omCecMgr.getLparMgr(unsignedInt16 + "*" + omCecMgr.getCecName());
                UnsignedInt32 unsignedInt327 = (UnsignedInt32)omLparMgr.getObject().getProperty("PendMaxMem");
                if (!unsignedInt323.equals((Object)new UnsignedInt32(-1L))) {
                    unsignedInt327 = unsignedInt323;
                }
                UnsignedInt32 unsignedInt328 = (UnsignedInt32)omLparMgr.getObject().getProperty("PendMinMem");
                if (!unsignedInt32.equals((Object)new UnsignedInt32(-1L))) {
                    unsignedInt328 = unsignedInt32;
                }
                OmLparActResourceUpdater omLparActResourceUpdater = new OmLparActResourceUpdater(omLparMgr);
                omLparActResourceUpdater.updateLparPendMem(unsignedInt328, unsignedInt324, unsignedInt327);
                OmCecInstUpdater omCecInstUpdater = new OmCecInstUpdater(omCecMgr);
                omCecInstUpdater.updatePhypAvailMemData();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
        catch (PIHscCmdMgrException pIHscCmdMgrException) {
            if (pIHscCmdMgrException.isExtendedError()) {
                CmdExtendedErrorList cmdExtendedErrorList = pIHscCmdMgrException.getExtendedError();
                CmdExtendedError[] cmdExtendedErrorArray = cmdExtendedErrorList.getErrorArray();
                if (cmdExtendedErrorArray != null && cmdExtendedErrorArray.length > 0) {
                    CmdExtendedError cmdExtendedError = cmdExtendedErrorArray[0];
                    long l = cmdExtendedError.extractErrorCode();
                    System.out.println("errCode = " + l);
                    System.out.println("PIHscConstants.PHYP_EXT_ERR_ERROR  |0xE002 = 1073799170");
                    if (l == 1073799170L) {
                        byte[] byArray = cmdExtendedError.getErrorParms();
                        if (byArray == null || byArray.length <= 0) {
                            throw new PIHscServerException("061C", pIHscCmdMgrException);
                        }
                        BigInteger bigInteger = new BigInteger(byArray);
                        System.out.println("memVal = " + bigInteger);
                        long l2 = PIResourcesAllocationUtils.getAdditionPhypMemNeeded(bigInteger.longValue() * unsignedInt162.longValue(), unsignedInt162.longValue(), fspCmdHelper);
                        long l3 = unsignedInt322.longValue() - l2;
                        unsignedInt324 = new UnsignedInt32(l3);
                        System.out.println("newDesAmount = " + l3);
                        OmLparMgr omLparMgr = null;
                        UnsignedInt32 unsignedInt329 = null;
                        try {
                            omLparMgr = omCecMgr.getLparMgr(unsignedInt16 + "*" + omCecMgr.getCecName());
                            unsignedInt329 = (UnsignedInt32)omLparMgr.getObject().getProperty("PendMinMem");
                        }
                        catch (Throwable throwable) {
                            throwable.printStackTrace();
                        }
                        if (!unsignedInt32.equals((Object)new UnsignedInt32(-1L))) {
                            unsignedInt329 = unsignedInt32;
                        }
                        if (l3 < unsignedInt329.longValue()) {
                            throw new PIHscServerException("0402", new String[]{Long.toString(l2)}, null);
                        }
                        try {
                            fspCmdHelper.setLparPendingMemory(unsignedInt16, unsignedInt8, unsignedInt326, new UnsignedInt32(l3 / unsignedInt162.longValue()), unsignedInt325);
                            try {
                                UnsignedInt32 unsignedInt3210 = (UnsignedInt32)omLparMgr.getObject().getProperty("PendMaxMem");
                                if (!unsignedInt323.equals((Object)new UnsignedInt32(-1L))) {
                                    unsignedInt3210 = unsignedInt323;
                                }
                                OmLparActResourceUpdater omLparActResourceUpdater = new OmLparActResourceUpdater(omLparMgr);
                                omLparActResourceUpdater.updateLparPendMem(unsignedInt329, new UnsignedInt32(l3), unsignedInt3210);
                                OmCecInstUpdater omCecInstUpdater = new OmCecInstUpdater(omCecMgr);
                                omCecInstUpdater.updatePhypAvailMemData();
                            }
                            catch (Throwable throwable) {
                                throwable.printStackTrace();
                            }
                        }
                        catch (Throwable throwable) {
                            throw new PIHscServerException("061C", throwable);
                        }
                    }
                    throw new PIHscServerException("061C", pIHscCmdMgrException);
                }
                throw new PIHscServerException("061C", pIHscCmdMgrException);
            }
            throw new PIHscServerException("061C", pIHscCmdMgrException);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            if (!(throwable instanceof PIHscServerException)) {
                throw new PIHscServerException("061C", null);
            }
            throw (PIHscServerException)throwable;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void setMMLparPendingMemory(UnsignedInt16 unsignedInt16, UnsignedInt32 unsignedInt32, UnsignedInt32 unsignedInt322, UnsignedInt32 unsignedInt323, UnsignedInt32 unsignedInt324, UnsignedInt32 unsignedInt325, UnsignedInt32 unsignedInt326, OmCecMgr omCecMgr) throws PIHscServerException {
        FspCmdHelper fspCmdHelper = omCecMgr.getCmdHelper();
        RObject rObject = omCecMgr.getObject();
        UnsignedInt16 unsignedInt162 = null;
        try {
            unsignedInt162 = (UnsignedInt16)rObject.getProperty(R50ComputerSystem.Index_LMBSize);
        }
        catch (RException rException) {
            throw new PIHscServerException("2523", new String[]{"R50ComputerSystem.LMBSize"}, rException);
        }
        StringBuffer stringBuffer = new StringBuffer("");
        if (unsignedInt32 == null) {
            stringBuffer.append("*MinReserve1Mem*");
        }
        if (unsignedInt322 == null) {
            stringBuffer.append("*Reserve1Mem*");
        }
        if (unsignedInt323 == null) {
            stringBuffer.append("*MaxReserve1Mem*");
        }
        if (unsignedInt324 == null) {
            stringBuffer.append("*MinReserve2Mem*");
        }
        if (unsignedInt325 == null) {
            stringBuffer.append("*Reserve2Mem*");
        }
        if (unsignedInt326 == null) {
            stringBuffer.append("*MaxReserve2Mem*");
        }
        if (stringBuffer.length() > 0) {
            stringBuffer.append(" is null. ");
            System.out.println("inside PIResourceAllocationUtils->setMMLparPendingMemory(), the following error happened: \n" + stringBuffer.toString());
            throw new PIHscServerException("061C", new String[]{stringBuffer.toString()}, null);
        }
        UnsignedInt32 unsignedInt327 = unsignedInt322;
        UnsignedInt32 unsignedInt328 = unsignedInt325;
        long l = unsignedInt162.longValue();
        try {
            fspCmdHelper.setMMLparPendingMemory(unsignedInt16, new UnsignedInt32(unsignedInt32.longValue() / l), new UnsignedInt32(unsignedInt322.longValue() / l), new UnsignedInt32(unsignedInt323.longValue() / l), new UnsignedInt32(unsignedInt324.longValue() / l), new UnsignedInt32(unsignedInt325.longValue() / l), new UnsignedInt32(unsignedInt326.longValue() / l));
            return;
        }
        catch (PIHscCmdMgrException pIHscCmdMgrException) {
            if (!pIHscCmdMgrException.isExtendedError()) throw new PIHscServerException("061C", pIHscCmdMgrException);
            Object object = pIHscCmdMgrException.getExtendedError();
            Object object2 = ((CmdExtendedErrorList)object).getErrorArray();
            if (object2 == null || ((CmdExtendedError[])object2).length <= 0) throw new PIHscServerException("061C", pIHscCmdMgrException);
            CmdExtendedError cmdExtendedError = object2[0];
            long l2 = cmdExtendedError.extractErrorCode();
            if (l2 != 1073799170L) throw new PIHscServerException("061C", pIHscCmdMgrException);
            byte[] byArray = cmdExtendedError.getErrorParms();
            if (byArray == null || byArray.length <= 0) {
                throw new PIHscServerException("061C", pIHscCmdMgrException);
            }
            BigInteger bigInteger = new BigInteger(byArray);
            System.out.println("memVal = " + bigInteger);
            long l3 = PIResourcesAllocationUtils.getAdditionPhypMemNeeded(bigInteger.longValue() * l, l, fspCmdHelper);
            long l4 = unsignedInt325.longValue() - l3;
            unsignedInt328 = new UnsignedInt32(l4);
            System.out.println("newDesRes2Amount = " + l4);
            if (l4 < unsignedInt324.longValue()) {
                throw new PIHscServerException("03EC", new String[]{Long.toString(l4), unsignedInt324.toString()}, null);
            }
            try {
                fspCmdHelper.setMMLparPendingMemory(unsignedInt16, new UnsignedInt32(unsignedInt32.longValue() / l), new UnsignedInt32(unsignedInt322.longValue() / l), new UnsignedInt32(unsignedInt323.longValue() / l), new UnsignedInt32(unsignedInt324.longValue() / l), new UnsignedInt32(l4 / l), new UnsignedInt32(unsignedInt326.longValue() / l));
            }
            catch (Throwable throwable) {
                throw new PIHscServerException("061C", throwable);
            }
            try {
                object = omCecMgr.getLparMgr(unsignedInt16 + "*" + omCecMgr.getCecName());
                object2 = new OmLparActResourceUpdater((OmLparMgr)object);
                ((OmLparActResourceUpdater)object2).updateMMLparPendMem(unsignedInt32, unsignedInt322, unsignedInt323, unsignedInt324, unsignedInt328, unsignedInt326);
                return;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            if (throwable instanceof PIHscServerException) throw (PIHscServerException)throwable;
            throw new PIHscServerException("061C", null);
        }
    }

    public static void setOtherLparConfigInfo(UnsignedInt16 unsignedInt16, boolean bl, Hashtable hashtable, UnsignedInt8 unsignedInt8, UnsignedInt8 unsignedInt82, UnsignedInt8 unsignedInt83, OmCecMgr omCecMgr) throws PIHscServerException {
        System.out.println("setOtherLparConfigInfo ");
        FspCmdHelper fspCmdHelper = omCecMgr.getCmdHelper();
        try {
            UnsignedInt16[] unsignedInt16Array;
            UnsignedInt8 unsignedInt84 = (UnsignedInt8)hashtable.get("BootMode");
            System.out.println("bootMode1 = " + unsignedInt84);
            short s = ((UnsignedInt8)hashtable.get("SFPSurveillance")).shortValue();
            UnsignedInt8 unsignedInt85 = (UnsignedInt8)hashtable.get("AutoIPLEnabled");
            UnsignedInt16 unsignedInt162 = (UnsignedInt16)hashtable.get("ClusterGroupID");
            UnsignedInt8 unsignedInt86 = (UnsignedInt8)hashtable.get("HSLOptiConnectPool");
            UnsignedInt8 unsignedInt87 = (UnsignedInt8)hashtable.get("VirtualOptiConnectPool");
            Vector vector = (Vector)hashtable.get("HostingPartitions");
            if (unsignedInt8 != null && !unsignedInt8.equals((Object)new UnsignedInt8(255))) {
                unsignedInt84 = unsignedInt8;
                System.out.println("bootMode2 = " + unsignedInt84);
            }
            if (bl) {
                unsignedInt84 = new UnsignedInt8(255);
                System.out.println("bootMode3 = " + unsignedInt84);
            }
            if (unsignedInt82 == null || !bl) {
                unsignedInt82 = new UnsignedInt8(255);
            }
            if (unsignedInt83 == null) {
                unsignedInt83 = new UnsignedInt8(255);
            }
            UnsignedInt8 unsignedInt88 = null;
            UnsignedInt8 unsignedInt89 = null;
            UnsignedInt8 unsignedInt810 = null;
            UnsignedInt8 unsignedInt811 = null;
            OmLparMgr omLparMgr = null;
            RObject rObject = null;
            try {
                omLparMgr = omCecMgr.getLparMgr(unsignedInt16 + "*" + omCecMgr.getCecName());
                rObject = omLparMgr.getObject();
                unsignedInt88 = (UnsignedInt8)rObject.getProperty("BootMode");
                unsignedInt89 = (UnsignedInt8)rObject.getProperty("IPLSource");
                unsignedInt810 = (UnsignedInt8)rObject.getProperty("Keylock");
                unsignedInt811 = (UnsignedInt8)rObject.getProperty("PowerOnWithHypervisor");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            boolean bl2 = false;
            if (!bl && !unsignedInt84.equals(unsignedInt88)) {
                bl2 = true;
            }
            if (bl && unsignedInt82 != null && !unsignedInt82.equals((Object)new UnsignedInt8(255)) && !unsignedInt82.equals(unsignedInt89)) {
                bl2 = true;
            }
            if (unsignedInt83 != null && !unsignedInt83.equals((Object)new UnsignedInt8(255)) && !unsignedInt83.equals(unsignedInt810)) {
                bl2 = true;
            }
            if (!unsignedInt85.equals(unsignedInt811)) {
                bl2 = true;
            }
            OmLparActResourceUpdater omLparActResourceUpdater = new OmLparActResourceUpdater(omLparMgr);
            if (bl2) {
                unsignedInt16Array = new FspVspAttr();
                unsignedInt16Array.setBootMode(unsignedInt84);
                unsignedInt16Array.setIplSource(unsignedInt82);
                unsignedInt16Array.setAutoIpl(unsignedInt85);
                unsignedInt16Array.setKeylock(unsignedInt83);
                System.out.println("set vspAttr = " + unsignedInt16Array);
                fspCmdHelper.setLparVSPAttributes(unsignedInt16, (FspVspAttr)unsignedInt16Array);
                omLparActResourceUpdater.updateVspAttr((FspVspAttr)unsignedInt16Array);
            }
            if (null != unsignedInt162) {
                fspCmdHelper.setLparClusterId(unsignedInt16, unsignedInt162);
            }
            if (null != vector && vector.size() > 0) {
                unsignedInt16Array = vector.toArray(new UnsignedInt16[vector.size()]);
                fspCmdHelper.setLparHostingPartitionIds(unsignedInt16, unsignedInt16Array);
                omLparActResourceUpdater.updateLparPowerCtrlLpars(vector);
            } else {
                fspCmdHelper.setLparHostingPartitionIds(unsignedInt16, new UnsignedInt16[]{new UnsignedInt16(65535)});
                omLparActResourceUpdater.updateLparPowerCtrlLpars(new Vector());
            }
            int n = 0;
            try {
                n = ((UnsignedInt8)rObject.getProperty(R50Partition.Index_DefinitionState)).intValue();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (bl || n == 65 || n == 66) {
                if (unsignedInt87 == null) {
                    unsignedInt87 = new UnsignedInt8(0);
                }
                if (unsignedInt86 == null) {
                    unsignedInt86 = new UnsignedInt8(0);
                }
                FspLparVirtualOptiConnect fspLparVirtualOptiConnect = new FspLparVirtualOptiConnect();
                System.out.println("virtOptiConnect = " + unsignedInt87);
                System.out.println(" virtHSLOptiConnect = " + unsignedInt86);
                fspLparVirtualOptiConnect.setVirtualOptiConnect(unsignedInt87);
                fspLparVirtualOptiConnect.setHslOptiConnect(unsignedInt86);
                fspCmdHelper.setLparVirtualOptiConnect(unsignedInt16, fspLparVirtualOptiConnect);
                omLparActResourceUpdater.updateLparOptiSetting(unsignedInt87, unsignedInt86);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            if (!(throwable instanceof PIHscServerException)) {
                throw new PIHscServerException("061B", null);
            }
            throw (PIHscServerException)throwable;
        }
    }

    public static void setVSPInfo(UnsignedInt16 unsignedInt16, Hashtable hashtable, UnsignedInt8 unsignedInt8, OmCecMgr omCecMgr) throws PIHscServerException {
        FspCmdHelper fspCmdHelper = omCecMgr.getCmdHelper();
        try {
            UnsignedInt8 unsignedInt82 = (UnsignedInt8)hashtable.get("BootMode");
            short s = ((UnsignedInt8)hashtable.get("SFPSurveillance")).shortValue();
            UnsignedInt8 unsignedInt83 = (UnsignedInt8)hashtable.get("IPLSource");
            UnsignedInt8 unsignedInt84 = (UnsignedInt8)hashtable.get("AutoIPLEnabled");
            UnsignedInt8 unsignedInt85 = new UnsignedInt8(255);
            if (unsignedInt8 != null) {
                unsignedInt82 = unsignedInt8;
            }
            FspVspAttr fspVspAttr = new FspVspAttr();
            fspVspAttr.setBootMode(unsignedInt82);
            fspVspAttr.setIplSource(unsignedInt83);
            fspVspAttr.setAutoIpl(unsignedInt84);
            fspVspAttr.setKeylock(unsignedInt85);
            fspCmdHelper.setLparVSPAttributes(unsignedInt16, fspVspAttr);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            if (!(throwable instanceof PIHscServerException)) {
                throw new PIHscServerException("061B", null);
            }
            throw (PIHscServerException)throwable;
        }
    }

    public static UnsignedInt16 getIOPoolID(CIMInstance cIMInstance, ProviderCIMOMHandle providerCIMOMHandle, String string) throws CIMException {
        CIMObjectPath cIMObjectPath = new CIMObjectPath("IBMHSC_PCISlot", string);
        cIMObjectPath.setKeys(cIMInstance.getKeyValuePairs());
        System.out.println("slotPath = " + cIMObjectPath);
        Vector vector = CimomWrapper.associators((CIMOMHandle)providerCIMOMHandle, new CIMObjectPath("IBMHSC_SlotInIOFailOverPool", string), cIMObjectPath, "IBMHSC_PCISlot", "Member", "Collection", false, false, null);
        System.out.println("pools = " + vector);
        UnsignedInt16 unsignedInt16 = new UnsignedInt16(65535);
        if (vector != null && vector.size() > 0) {
            CIMInstance cIMInstance2 = (CIMInstance)vector.firstElement();
            unsignedInt16 = new UnsignedInt16((String)cIMInstance2.getProperty("CollectionID").getValue().getValue());
        }
        return unsignedInt16;
    }

    public static long getAdditionPhypMemNeeded(long l, long l2, FspCmdHelper fspCmdHelper) throws PIHscServerException {
        FspLparMemory fspLparMemory = fspCmdHelper.getCurrAndPendLparMem(new UnsignedInt16(0));
        long l3 = fspLparMemory.getPendAllocMem().longValue() * l2;
        System.out.println("curPhypPendAllocMem = " + l3);
        long l4 = l - l3;
        if (l4 <= 0L) {
            return 0L;
        }
        return l4;
    }

    public static void free5250CPW(UnsignedInt16 unsignedInt16, OmCecMgr omCecMgr) throws PIHscServerException {
        omCecMgr.getCmdHelper().setLparPendingPerformance(unsignedInt16, new UnsignedInt16(0), new UnsignedInt16(0), new UnsignedInt16(0));
        try {
            OmLparMgr omLparMgr = omCecMgr.getLparMgr(unsignedInt16 + "*" + omCecMgr.getCecName());
            OmLparActResourceUpdater omLparActResourceUpdater = new OmLparActResourceUpdater(omLparMgr);
            omLparActResourceUpdater.free5250();
        }
        catch (Throwable throwable) {
            System.out.println("Error in free5250");
            throwable.printStackTrace();
        }
    }

    public static void freeProcs(UnsignedInt16 unsignedInt16, UnsignedInt8 unsignedInt8, OmCecMgr omCecMgr) throws PIHscServerException {
        if (unsignedInt8.intValue() == 255) {
            System.out.println("try to free processor");
            omCecMgr.getCmdHelper().setLparPendingDedicatedProcessors(unsignedInt16, new UnsignedInt16(0), new UnsignedInt16(0), new UnsignedInt16(0));
        } else {
            omCecMgr.getCmdHelper().setLparPendingSharedProcessors(unsignedInt16, unsignedInt8, new UnsignedInt16(0), new UnsignedInt16(0), new UnsignedInt16(0), new UnsignedInt32(0L), new UnsignedInt32(0L), new UnsignedInt32(0L), new UnsignedInt8(0));
        }
        String string = omCecMgr.getCecName();
        String string2 = String.valueOf(unsignedInt16) + "*" + string;
        System.out.println("freeProcs: lparName=" + string2);
        try {
            OmLparMgr omLparMgr = omCecMgr.getLparMgr(string2);
            OmLparActResourceUpdater omLparActResourceUpdater = new OmLparActResourceUpdater(omLparMgr);
            omLparActResourceUpdater.freePendingProc(unsignedInt8);
        }
        catch (Throwable throwable) {
            System.out.println("Error in freeProcs");
            throwable.printStackTrace();
        }
    }

    public static void freeMem(UnsignedInt16 unsignedInt16, OmCecMgr omCecMgr) throws PIHscServerException {
        omCecMgr.getCmdHelper().setLparPendingMemory(unsignedInt16, omCecMgr.getRecommandedHptRatio(), new UnsignedInt32(0L), new UnsignedInt32(0L), new UnsignedInt32(0L));
        String string = omCecMgr.getCecName();
        String string2 = String.valueOf(unsignedInt16) + "*" + string;
        System.out.println("freeMem: lparName=" + string2);
        try {
            OmLparMgr omLparMgr = omCecMgr.getLparMgr(string2);
            OmLparActResourceUpdater omLparActResourceUpdater = new OmLparActResourceUpdater(omLparMgr);
            omLparActResourceUpdater.freePendingMem();
        }
        catch (Throwable throwable) {
            System.out.println("Error in freeMem");
            throwable.printStackTrace();
        }
    }

    public static boolean totalPendingOverConfigured(OmCecMgr omCecMgr, boolean bl) {
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        long l4 = 0L;
        long l5 = 0L;
        long l6 = 0L;
        Hashtable hashtable = null;
        RObject rObject = omCecMgr.getObject();
        if (bl) {
            try {
                l = ((UnsignedInt32)rObject.getProperty("ConfigurableProcUnits")).longValue();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                l3 = ((UnsignedInt32)rObject.getProperty("PendAvailProcUnits")).longValue();
            }
            catch (Throwable throwable) {}
        } else {
            try {
                l2 = ((UnsignedInt32)rObject.getProperty("ConfigurableMem")).longValue();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                l4 = ((UnsignedInt32)rObject.getProperty("PendAvailMem")).longValue();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        hashtable = (Hashtable)omCecMgr.getLparMgrHash().clone();
        if (hashtable == null || hashtable.isEmpty()) {
            return false;
        }
        Enumeration enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            UnsignedInt16 unsignedInt16;
            UnsignedInt8 unsignedInt8;
            RObject rObject2;
            OmLparMgr omLparMgr = (OmLparMgr)enumeration.nextElement();
            if (omLparMgr == null || (rObject2 = omLparMgr.getObject()) == null) continue;
            if (bl) {
                unsignedInt8 = null;
                try {
                    unsignedInt8 = (UnsignedInt8)rObject2.getProperty("PendProcMode");
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (unsignedInt8 != null && unsignedInt8.intValue() != 255) {
                    unsignedInt16 = null;
                    try {
                        unsignedInt16 = (UnsignedInt32)rObject2.getProperty("PendAllocProcUnits");
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    if (unsignedInt16 == null) continue;
                    l5 += unsignedInt16.longValue();
                    continue;
                }
                unsignedInt16 = null;
                try {
                    unsignedInt16 = (UnsignedInt16)rObject2.getProperty("PendAllocProcs");
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (unsignedInt16 == null) continue;
                l5 += (long)(unsignedInt16.intValue() * 100);
                continue;
            }
            unsignedInt8 = null;
            try {
                unsignedInt8 = (UnsignedInt32)rObject2.getProperty("PendAllocMem");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (unsignedInt8 != null) {
                l6 += unsignedInt8.longValue();
            }
            unsignedInt16 = null;
            try {
                unsignedInt16 = (UnsignedInt32)rObject2.getProperty("Reserve1PendAllocMem");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (unsignedInt16 != null) {
                l6 += unsignedInt16.longValue();
            }
            UnsignedInt32 unsignedInt32 = null;
            try {
                unsignedInt32 = (UnsignedInt32)rObject2.getProperty("Reserve2PendAllocMem");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (unsignedInt32 == null) continue;
            l6 += unsignedInt32.longValue();
        }
        if (bl) {
            return l3 + l5 > l;
        }
        return l4 + l6 > l2;
    }

    public static void syncPendProcToCur(OmCecMgr omCecMgr, OmLparMgr omLparMgr) throws PIHscServerException {
        System.out.println("syncPendProcToCur");
        RObject rObject = null;
        try {
            rObject = omLparMgr.getObject();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (rObject == null) {
            return;
        }
        UnsignedInt8 unsignedInt8 = null;
        UnsignedInt16 unsignedInt16 = null;
        UnsignedInt16 unsignedInt162 = null;
        UnsignedInt16 unsignedInt163 = null;
        UnsignedInt32 unsignedInt32 = null;
        UnsignedInt32 unsignedInt322 = null;
        UnsignedInt32 unsignedInt323 = null;
        UnsignedInt8 unsignedInt82 = null;
        UnsignedInt8 unsignedInt83 = null;
        boolean bl = false;
        int n = 0;
        int n2 = 0;
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        boolean bl2 = true;
        FspLparProcessingInfo fspLparProcessingInfo = new FspLparProcessingInfo();
        AllocProcAndLparInfo allocProcAndLparInfo = new AllocProcAndLparInfo();
        try {
            boolean bl3;
            unsignedInt8 = (UnsignedInt8)rObject.getProperty("CurProcMode");
            unsignedInt82 = (UnsignedInt8)rObject.getProperty("CurSharingMode");
            if (unsignedInt8 == null || unsignedInt8.equals((Object)new UnsignedInt8(255))) {
                fspLparProcessingInfo.setProcType(new UnsignedInt8(255));
                unsignedInt16 = (UnsignedInt16)rObject.getProperty("CurMinProcs");
                unsignedInt162 = (UnsignedInt16)rObject.getProperty("CurAllocProcs");
                unsignedInt163 = (UnsignedInt16)rObject.getProperty("CurMaxProcs");
                bl3 = false;
                if (unsignedInt162 != null) {
                    n = unsignedInt162.intValue();
                    if (n == 0) {
                        bl3 = true;
                    }
                    fspLparProcessingInfo.setAllocProcs(unsignedInt162);
                } else {
                    bl3 = true;
                    fspLparProcessingInfo.setAllocProcs(new UnsignedInt16(0));
                }
                if (!bl3) {
                    if (unsignedInt16 != null) {
                        if (unsignedInt16.intValue() > unsignedInt162.intValue()) {
                            unsignedInt16 = unsignedInt162;
                        }
                        fspLparProcessingInfo.setMinProcs(unsignedInt16);
                    } else {
                        fspLparProcessingInfo.setMinProcs(new UnsignedInt16(0));
                    }
                    if (unsignedInt163 != null) {
                        fspLparProcessingInfo.setMaxProcs(unsignedInt163);
                    } else {
                        fspLparProcessingInfo.setMaxProcs(new UnsignedInt16(0));
                    }
                } else {
                    fspLparProcessingInfo.setMinProcs(new UnsignedInt16(0));
                    fspLparProcessingInfo.setMaxProcs(new UnsignedInt16(0));
                }
            } else {
                bl2 = false;
                fspLparProcessingInfo.setProcType(new UnsignedInt8(0));
                unsignedInt83 = (UnsignedInt8)rObject.getProperty("CurUncappedWeight");
                unsignedInt16 = (UnsignedInt16)rObject.getProperty("CurMinProcs");
                unsignedInt162 = (UnsignedInt16)rObject.getProperty("CurAllocProcs");
                unsignedInt163 = (UnsignedInt16)rObject.getProperty("CurMaxProcs");
                unsignedInt32 = (UnsignedInt32)rObject.getProperty("CurMinProcUnits");
                unsignedInt322 = (UnsignedInt32)rObject.getProperty("CurAllocProcUnits");
                unsignedInt323 = (UnsignedInt32)rObject.getProperty("CurMaxProcUnits");
                if (unsignedInt83 != null) {
                    fspLparProcessingInfo.setUncappedWeight(unsignedInt83);
                } else {
                    fspLparProcessingInfo.setUncappedWeight(new UnsignedInt8(0));
                }
                bl3 = false;
                if (unsignedInt162 != null) {
                    n = unsignedInt162.intValue();
                    if (n == 0) {
                        bl3 = true;
                    }
                    fspLparProcessingInfo.setAllocProcs(unsignedInt162);
                } else {
                    bl3 = true;
                    fspLparProcessingInfo.setAllocProcs(new UnsignedInt16(0));
                }
                if (!bl3) {
                    if (unsignedInt16 != null) {
                        if (unsignedInt16.intValue() > unsignedInt162.intValue()) {
                            unsignedInt16 = unsignedInt162;
                        }
                        fspLparProcessingInfo.setMinProcs(unsignedInt16);
                    } else {
                        fspLparProcessingInfo.setMinProcs(new UnsignedInt16(0));
                    }
                    if (unsignedInt163 != null) {
                        n2 = unsignedInt163.intValue();
                        fspLparProcessingInfo.setMaxProcs(unsignedInt163);
                    } else {
                        fspLparProcessingInfo.setMaxProcs(new UnsignedInt16(0));
                    }
                } else {
                    fspLparProcessingInfo.setMinProcs(new UnsignedInt16(0));
                    fspLparProcessingInfo.setMaxProcs(new UnsignedInt16(0));
                }
                boolean bl4 = false;
                if (unsignedInt322 != null) {
                    fspLparProcessingInfo.setAllocProcUnits(unsignedInt322);
                    l2 = unsignedInt322.longValue();
                    if (l2 == 0L) {
                        bl4 = true;
                    }
                } else {
                    fspLparProcessingInfo.setAllocProcUnits(new UnsignedInt32(0L));
                    bl4 = true;
                }
                if (!bl4) {
                    if (unsignedInt32 != null) {
                        if (unsignedInt32.longValue() > unsignedInt322.longValue()) {
                            unsignedInt32 = unsignedInt322;
                        }
                        fspLparProcessingInfo.setMinProcUnits(unsignedInt32);
                        l = unsignedInt32.longValue();
                    } else {
                        fspLparProcessingInfo.setMinProcUnits(new UnsignedInt32(0L));
                    }
                    if (unsignedInt323 != null) {
                        fspLparProcessingInfo.setMaxProcUnits(unsignedInt323);
                        l3 = unsignedInt323.longValue();
                    } else {
                        fspLparProcessingInfo.setMaxProcUnits(new UnsignedInt32(0L));
                    }
                } else {
                    fspLparProcessingInfo.setMinProcUnits(new UnsignedInt32(0L));
                    fspLparProcessingInfo.setMaxProcUnits(new UnsignedInt32(0L));
                    fspLparProcessingInfo.setAllocProcs(new UnsignedInt16(0));
                    fspLparProcessingInfo.setMinProcs(new UnsignedInt16(0));
                    fspLparProcessingInfo.setMaxProcs(new UnsignedInt16(0));
                }
            }
            if (!bl2) {
                long l4 = fspLparProcessingInfo.getAllocProcUnits().longValue();
                int n3 = fspLparProcessingInfo.getAllocProcs().intValue();
                if (n3 != 0 || l4 != 0L) {
                    long l5 = 10L;
                    try {
                        RObject rObject2 = omCecMgr.getObject();
                        l5 = ((UnsignedInt16)rObject2.getProperty("MinProcUnit")).intValue();
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                    }
                    if (n3 == 0) {
                        fspLparProcessingInfo.setMinProcUnits(new UnsignedInt32(0L));
                        fspLparProcessingInfo.setAllocProcUnits(new UnsignedInt32(0L));
                        fspLparProcessingInfo.setMaxProcUnits(new UnsignedInt32(0L));
                        fspLparProcessingInfo.setAllocProcs(new UnsignedInt16(0));
                        fspLparProcessingInfo.setMinProcs(new UnsignedInt16(0));
                        fspLparProcessingInfo.setMaxProcs(new UnsignedInt16(0));
                    } else if (l4 == 0L) {
                        fspLparProcessingInfo.setMinProcUnits(new UnsignedInt32(0L));
                        fspLparProcessingInfo.setAllocProcUnits(new UnsignedInt32(0L));
                        fspLparProcessingInfo.setMaxProcUnits(new UnsignedInt32(0L));
                        fspLparProcessingInfo.setAllocProcs(new UnsignedInt16(0));
                        fspLparProcessingInfo.setMinProcs(new UnsignedInt16(0));
                        fspLparProcessingInfo.setMaxProcs(new UnsignedInt16(0));
                    } else if (l4 / (long)n3 < l5) {
                        long l6 = l4 % l5;
                        n3 = (int)(l4 / l5);
                        fspLparProcessingInfo.setAllocProcs(new UnsignedInt16(n3));
                        if (fspLparProcessingInfo.getMinProcs().intValue() > n3) {
                            fspLparProcessingInfo.setMinProcs(fspLparProcessingInfo.getAllocProcs());
                        }
                    }
                }
            }
            if (unsignedInt82 != null) {
                fspLparProcessingInfo.setSharingMode(unsignedInt82);
            } else {
                fspLparProcessingInfo.setSharingMode(new UnsignedInt8(0));
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        UnsignedInt8 unsignedInt84 = null;
        UnsignedInt16 unsignedInt164 = null;
        UnsignedInt16 unsignedInt165 = null;
        UnsignedInt16 unsignedInt166 = null;
        UnsignedInt32 unsignedInt324 = null;
        UnsignedInt32 unsignedInt325 = null;
        UnsignedInt32 unsignedInt326 = null;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        long l7 = 0L;
        long l8 = 0L;
        long l9 = 0L;
        boolean bl5 = true;
        try {
            unsignedInt84 = (UnsignedInt8)rObject.getProperty("PendProcMode");
            if (unsignedInt84 == null || unsignedInt84.equals((Object)new UnsignedInt8(255))) {
                unsignedInt164 = (UnsignedInt16)rObject.getProperty("PendMinProcs");
                unsignedInt165 = (UnsignedInt16)rObject.getProperty("PendAllocProcs");
                unsignedInt166 = (UnsignedInt16)rObject.getProperty("PendMaxProcs");
                if (unsignedInt164 != null) {
                    n4 = unsignedInt164.intValue();
                }
                if (unsignedInt165 != null) {
                    n5 = unsignedInt165.intValue();
                }
                if (unsignedInt166 != null) {
                    n6 = unsignedInt166.intValue();
                }
            } else {
                bl5 = false;
                unsignedInt164 = (UnsignedInt16)rObject.getProperty("PendMinProcs");
                unsignedInt165 = (UnsignedInt16)rObject.getProperty("PendAllocProcs");
                unsignedInt166 = (UnsignedInt16)rObject.getProperty("PendMaxProcs");
                unsignedInt324 = (UnsignedInt32)rObject.getProperty("PendMinProcUnits");
                unsignedInt325 = (UnsignedInt32)rObject.getProperty("PendAllocProcUnits");
                unsignedInt326 = (UnsignedInt32)rObject.getProperty("PendMaxProcUnits");
                if (unsignedInt164 != null) {
                    n4 = unsignedInt164.intValue();
                }
                if (unsignedInt165 != null) {
                    n5 = unsignedInt165.intValue();
                }
                if (unsignedInt166 != null) {
                    n6 = unsignedInt166.intValue();
                }
                if (unsignedInt324 != null) {
                    l7 = unsignedInt324.longValue();
                }
                if (unsignedInt325 != null) {
                    l8 = unsignedInt325.longValue();
                }
                if (unsignedInt326 != null) {
                    l9 = unsignedInt326.longValue();
                }
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        System.out.println("curAllocProcsVal = " + n + " pendAllocProcsVal = " + n5);
        System.out.println("curAllocProcUnitsVal = " + l2 + " pendAllocProcUnitsVal = " + l8);
        boolean bl6 = false;
        if (bl2) {
            if (bl5) {
                if (n < n5) {
                    bl6 = true;
                }
            } else {
                bl6 = true;
            }
        } else if (bl5) {
            bl6 = true;
        } else if (l2 < l8) {
            bl6 = true;
        }
        if (bl6) {
            PIResourcesAllocationUtils.setPendingProc(new UnsignedInt16(omLparMgr.getLparIndex()), fspLparProcessingInfo, omCecMgr);
        }
    }

    public static void syncPendMemToCur(OmCecMgr omCecMgr, OmLparMgr omLparMgr) throws PIHscServerException {
        System.out.println("syncPendMemToCur");
        RObject rObject = null;
        try {
            rObject = omLparMgr.getObject();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (rObject == null) {
            return;
        }
        UnsignedInt32 unsignedInt32 = null;
        UnsignedInt32 unsignedInt322 = null;
        UnsignedInt32 unsignedInt323 = null;
        UnsignedInt32 unsignedInt324 = null;
        UnsignedInt32 unsignedInt325 = null;
        UnsignedInt32 unsignedInt326 = null;
        UnsignedInt32 unsignedInt327 = null;
        UnsignedInt32 unsignedInt328 = null;
        UnsignedInt32 unsignedInt329 = null;
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        long l4 = 0L;
        long l5 = 0L;
        long l6 = 0L;
        long l7 = 0L;
        long l8 = 0L;
        long l9 = 0L;
        try {
            unsignedInt32 = (UnsignedInt32)rObject.getProperty("CurMinMem");
            unsignedInt322 = (UnsignedInt32)rObject.getProperty("CurAllocMem");
            unsignedInt323 = (UnsignedInt32)rObject.getProperty("CurMaxMem");
            boolean bl = false;
            if (unsignedInt322 != null) {
                l2 = unsignedInt322.longValue();
                if (l2 == 0L) {
                    bl = true;
                }
            } else {
                bl = true;
                unsignedInt322 = new UnsignedInt32(0L);
            }
            if (!bl) {
                if (unsignedInt32 != null) {
                    if (unsignedInt32.longValue() > l2) {
                        unsignedInt32 = unsignedInt322;
                        unsignedInt323 = unsignedInt322;
                    }
                    l = unsignedInt32.longValue();
                } else {
                    unsignedInt32 = new UnsignedInt32(0L);
                }
                if (unsignedInt323 != null) {
                    l3 = unsignedInt323.longValue();
                } else {
                    unsignedInt323 = new UnsignedInt32(0L);
                }
            } else {
                unsignedInt32 = new UnsignedInt32(0L);
                unsignedInt323 = new UnsignedInt32(0L);
            }
            unsignedInt324 = (UnsignedInt32)rObject.getProperty("Reserve1CurMinMem");
            unsignedInt325 = (UnsignedInt32)rObject.getProperty("Reserve1CurAllocMem");
            unsignedInt326 = (UnsignedInt32)rObject.getProperty("Reserve1CurMaxMem");
            boolean bl2 = false;
            if (unsignedInt325 != null) {
                l5 = unsignedInt325.longValue();
                if (l5 == 0L) {
                    bl2 = true;
                }
            } else {
                bl2 = true;
                unsignedInt325 = new UnsignedInt32(0L);
            }
            if (!bl2) {
                if (unsignedInt324 != null) {
                    if (unsignedInt324.longValue() > l5) {
                        unsignedInt324 = unsignedInt325;
                        unsignedInt326 = unsignedInt325;
                    }
                    l4 = unsignedInt324.longValue();
                } else {
                    unsignedInt324 = new UnsignedInt32(0L);
                }
                if (unsignedInt326 != null) {
                    l6 = unsignedInt326.longValue();
                } else {
                    unsignedInt326 = new UnsignedInt32(0L);
                }
            } else {
                unsignedInt324 = new UnsignedInt32(0L);
                unsignedInt326 = new UnsignedInt32(0L);
            }
            unsignedInt327 = (UnsignedInt32)rObject.getProperty("Reserve2CurMinMem");
            unsignedInt328 = (UnsignedInt32)rObject.getProperty("Reserve2CurAllocMem");
            unsignedInt329 = (UnsignedInt32)rObject.getProperty("Reserve2CurMaxMem");
            boolean bl3 = false;
            if (unsignedInt328 != null) {
                l8 = unsignedInt328.longValue();
                if (l8 == 0L) {
                    bl3 = true;
                }
            } else {
                bl3 = true;
                unsignedInt328 = new UnsignedInt32(0L);
            }
            if (!bl3) {
                if (unsignedInt327 != null) {
                    if (unsignedInt327.longValue() > l8) {
                        unsignedInt327 = unsignedInt328;
                        unsignedInt329 = unsignedInt328;
                    }
                    l7 = unsignedInt327.longValue();
                } else {
                    unsignedInt327 = new UnsignedInt32(0L);
                }
                if (unsignedInt329 != null) {
                    l9 = unsignedInt329.longValue();
                } else {
                    unsignedInt329 = new UnsignedInt32(0L);
                }
            } else {
                unsignedInt327 = new UnsignedInt32(0L);
                unsignedInt329 = new UnsignedInt32(0L);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        UnsignedInt32 unsignedInt3210 = null;
        UnsignedInt32 unsignedInt3211 = null;
        UnsignedInt32 unsignedInt3212 = null;
        UnsignedInt32 unsignedInt3213 = null;
        UnsignedInt32 unsignedInt3214 = null;
        UnsignedInt32 unsignedInt3215 = null;
        UnsignedInt32 unsignedInt3216 = null;
        UnsignedInt32 unsignedInt3217 = null;
        UnsignedInt32 unsignedInt3218 = null;
        long l10 = 0L;
        long l11 = 0L;
        long l12 = 0L;
        long l13 = 0L;
        long l14 = 0L;
        long l15 = 0L;
        long l16 = 0L;
        long l17 = 0L;
        long l18 = 0L;
        try {
            unsignedInt3210 = (UnsignedInt32)rObject.getProperty("PendMinMem");
            unsignedInt3211 = (UnsignedInt32)rObject.getProperty("PendAllocMem");
            unsignedInt3212 = (UnsignedInt32)rObject.getProperty("PendMaxMem");
            if (unsignedInt3210 != null) {
                l10 = unsignedInt3210.longValue();
            } else {
                unsignedInt3210 = new UnsignedInt32(0L);
            }
            if (unsignedInt3211 != null) {
                l11 = unsignedInt3211.longValue();
            } else {
                unsignedInt3211 = new UnsignedInt32(0L);
            }
            if (unsignedInt3212 != null) {
                l12 = unsignedInt3212.longValue();
            } else {
                unsignedInt3212 = new UnsignedInt32(0L);
            }
            unsignedInt3213 = (UnsignedInt32)rObject.getProperty("Reserve1PendMinMem");
            unsignedInt3214 = (UnsignedInt32)rObject.getProperty("Reserve1PendAllocMem");
            unsignedInt3215 = (UnsignedInt32)rObject.getProperty("Reserve1PendMaxMem");
            if (unsignedInt3213 != null) {
                l13 = unsignedInt3213.longValue();
            } else {
                unsignedInt3213 = new UnsignedInt32(0L);
            }
            if (unsignedInt3214 != null) {
                l14 = unsignedInt3214.longValue();
            } else {
                unsignedInt3214 = new UnsignedInt32(0L);
            }
            if (unsignedInt3215 != null) {
                l15 = unsignedInt3215.longValue();
            } else {
                unsignedInt3215 = new UnsignedInt32(0L);
            }
            unsignedInt3216 = (UnsignedInt32)rObject.getProperty("Reserve2PendMinMem");
            unsignedInt3217 = (UnsignedInt32)rObject.getProperty("Reserve2PendAllocMem");
            unsignedInt3218 = (UnsignedInt32)rObject.getProperty("Reserve2PendMaxMem");
            if (unsignedInt3216 != null) {
                l16 = unsignedInt3216.longValue();
            } else {
                unsignedInt3216 = new UnsignedInt32(0L);
            }
            if (unsignedInt3217 != null) {
                l17 = unsignedInt3217.longValue();
            } else {
                unsignedInt3217 = new UnsignedInt32(0L);
            }
            if (unsignedInt3218 != null) {
                l18 = unsignedInt3218.longValue();
            } else {
                unsignedInt3218 = new UnsignedInt32(0L);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        boolean bl = false;
        if (l2 + l5 + l8 < l11 + l14 + l17) {
            UnsignedInt16 unsignedInt16 = new UnsignedInt16(omLparMgr.getLparIndex());
            UnsignedInt8 unsignedInt8 = new UnsignedInt8(255);
            PIResourcesAllocationUtils.setPendingMemory(unsignedInt16, unsignedInt32, unsignedInt322, unsignedInt323, unsignedInt8, omCecMgr);
            if (!unsignedInt325.equals((Object)new UnsignedInt32(0L)) || !unsignedInt328.equals((Object)new UnsignedInt32(0L))) {
                PIResourcesAllocationUtils.setMMLparPendingMemory(unsignedInt16, unsignedInt324, unsignedInt325, unsignedInt326, unsignedInt327, unsignedInt328, unsignedInt329, omCecMgr);
            }
        }
    }

    public static void syncAllAccessiblePendResToCur(OmCecMgr omCecMgr, OmLparMgr omLparMgr, ProviderCIMOMHandle providerCIMOMHandle, boolean bl) throws PIHscServerException {
        Object object;
        CIMInstance cIMInstance;
        RObject rObject = null;
        CIMObjectPath cIMObjectPath = null;
        try {
            rObject = omCecMgr.getObject();
            cIMObjectPath = rObject.cimGetCIMObjectPath((CIMOMHandle)providerCIMOMHandle);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
        Vector vector = PIHmcAccessUtils.getLparObjWithAuthFromCec(cIMObjectPath, "ActivateLparProfile", providerCIMOMHandle, false);
        Hashtable<UnsignedInt16, Object> hashtable = new Hashtable<UnsignedInt16, Object>();
        UnsignedInt16 unsignedInt16 = new UnsignedInt16(65535);
        UnsignedInt16 unsignedInt162 = null;
        if (vector != null && vector.size() > 0) {
            for (int i = 0; i < vector.size(); ++i) {
                Object object2;
                cIMInstance = (CIMInstance)vector.elementAt(i);
                object = null;
                try {
                    object2 = new CIMObjectPath("IBMHSC_Partition", cIMObjectPath.getNameSpace());
                    object2.setKeys(cIMInstance.getKeyValuePairs());
                    object = PIClusterModifier.getLparClusterInfo((CIMOMHandle)providerCIMOMHandle, (CIMObjectPath)object2);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                unsignedInt162 = object == null || !PIClusterModifier.isUserDefinedCluster((int)object[0]) ? unsignedInt16 : new UnsignedInt16((int)object[0]);
                object2 = new Vector();
                if (hashtable.containsKey(unsignedInt162)) {
                    object2 = (Vector)hashtable.get(unsignedInt162);
                }
                ((Vector)object2).add(cIMInstance);
                hashtable.put(unsignedInt162, object2);
            }
        }
        System.out.println("lparsByGroup = " + hashtable);
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            cIMInstance = (UnsignedInt16)enumeration.nextElement();
            object = (Vector)hashtable.get(cIMInstance);
            if (object == null || ((Vector)object).size() <= 0) continue;
            for (int i = 0; i < ((Vector)object).size(); ++i) {
                CIMInstance cIMInstance2 = (CIMInstance)((Vector)object).elementAt(i);
                String string = (String)cIMInstance2.getProperty("Name").getValue().getValue();
                OmLparMgr omLparMgr2 = null;
                try {
                    omLparMgr2 = omCecMgr.getLparMgr(string);
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                    continue;
                }
                if (bl) {
                    PIResourcesAllocationUtils.syncPendProcToCur(omCecMgr, omLparMgr2);
                    continue;
                }
                PIResourcesAllocationUtils.syncPendMemToCur(omCecMgr, omLparMgr2);
            }
        }
    }

    public static class VirtualIOInfo {
        UnsignedInt16[] virSCSIServerLPARs;
        UnsignedInt16[] virSCSIServerSlotNum;
        UnsignedInt16[] virSCSIAdapters;
        UnsignedInt8[] virSCSIDeviceAttributes;
        UnsignedInt8[] virSCSISupportHMCClients;
        UnsignedInt8[] virSCSIRequired;
        UnsignedInt16[] virSerialServerLPARs;
        UnsignedInt16[] virSerialServerSlotNum;
        UnsignedInt16[] virSerialAdapters;
        UnsignedInt8[] virSerialDeviceAttributes;
        UnsignedInt8[] virSerialSupportHMCClients;
        UnsignedInt8[] virSerialRequired;
        UnsignedInt16[] virtualLanSlotIDs;
        UnsignedInt8[] ieee;
        UnsignedInt8[] trunk;
        UnsignedInt16[] pVLANID;
        UnsignedInt16[] addVlanNum;
        UnsignedInt16[] addVlans;
        UnsignedInt8[] vEthernetRequired;
        UnsignedInt16 maxVIOSlots;
        UnsignedInt16[] virSMCASlotIDs;
        UnsignedInt32[] virSMCAHubDrcIndices;
        UnsignedInt32[] virSMCAIOBusIDs;
        UnsignedInt16[] virSMCARemoteLparIDs;
        UnsignedInt16[] virSMCARemoteSlotIDs;
        UnsignedInt8[] virSMCARequired;

        public String toString() {
            int n;
            String string = "";
            String string2 = "";
            String string3 = "";
            String string4 = "";
            String string5 = "";
            String string6 = "";
            String string7 = "";
            String string8 = "";
            String string9 = "";
            String string10 = "";
            String string11 = "";
            String string12 = "";
            String string13 = "";
            String string14 = "";
            String string15 = "";
            String string16 = "";
            String string17 = "";
            String string18 = "";
            String string19 = "";
            String string20 = "";
            String string21 = "";
            String string22 = "";
            String string23 = "";
            String string24 = "";
            String string25 = "";
            if (this.virSCSIServerLPARs != null) {
                for (n = 0; n < this.virSCSIServerLPARs.length; ++n) {
                    string = string + this.virSCSIServerLPARs[n].toString() + ", ";
                }
            }
            if (this.virSCSIServerSlotNum != null) {
                for (n = 0; n < this.virSCSIServerSlotNum.length; ++n) {
                    string2 = string2 + this.virSCSIServerSlotNum[n].toString() + ", ";
                }
            }
            if (this.virSCSIAdapters != null) {
                for (n = 0; n < this.virSCSIAdapters.length; ++n) {
                    string3 = string3 + this.virSCSIAdapters[n].toString() + ", ";
                }
            }
            if (this.virSCSIDeviceAttributes != null) {
                for (n = 0; n < this.virSCSIDeviceAttributes.length; ++n) {
                    string4 = string4 + this.virSCSIDeviceAttributes[n] + ", ";
                }
            }
            if (this.virSCSISupportHMCClients != null) {
                for (n = 0; n < this.virSCSISupportHMCClients.length; ++n) {
                    string5 = string5 + this.virSCSISupportHMCClients[n] + ", ";
                }
            }
            if (this.virSCSIRequired != null) {
                for (n = 0; n < this.virSCSIRequired.length; ++n) {
                    string6 = string6 + this.virSCSIRequired[n] + ", ";
                }
            }
            if (this.virSerialServerLPARs != null) {
                for (n = 0; n < this.virSerialServerLPARs.length; ++n) {
                    string7 = this.virSerialServerLPARs[n] != null ? string7 + this.virSerialServerLPARs[n].toString() + ", " : string7 + "null";
                }
            }
            if (this.virSerialServerSlotNum != null) {
                for (n = 0; n < this.virSerialServerSlotNum.length; ++n) {
                    string8 = this.virSerialServerSlotNum[n] != null ? string8 + this.virSerialServerSlotNum[n].toString() + ", " : string8 + "null";
                }
            }
            if (this.virSerialAdapters != null) {
                for (n = 0; n < this.virSerialAdapters.length; ++n) {
                    string9 = this.virSerialAdapters[n] != null ? string9 + this.virSerialAdapters[n].toString() + ", " : string9 + "null";
                }
            }
            if (this.virSerialDeviceAttributes != null) {
                for (n = 0; n < this.virSerialDeviceAttributes.length; ++n) {
                    string10 = string10 + this.virSerialDeviceAttributes[n] + ", ";
                }
            }
            if (this.virSerialSupportHMCClients != null) {
                for (n = 0; n < this.virSerialSupportHMCClients.length; ++n) {
                    string11 = string11 + this.virSerialSupportHMCClients[n] + ", ";
                }
            }
            if (this.virSerialRequired != null) {
                for (n = 0; n < this.virSerialRequired.length; ++n) {
                    string12 = string12 + this.virSerialRequired[n] + ", ";
                }
            }
            if (this.virtualLanSlotIDs != null) {
                for (n = 0; n < this.virtualLanSlotIDs.length; ++n) {
                    string13 = string13 + this.virtualLanSlotIDs[n] + ", ";
                }
            }
            if (this.ieee != null) {
                for (n = 0; n < this.ieee.length; ++n) {
                    string14 = string14 + this.ieee[n] + ", ";
                }
            }
            if (this.trunk != null) {
                for (n = 0; n < this.trunk.length; ++n) {
                    string15 = string15 + this.trunk[n] + ", ";
                }
            }
            if (this.pVLANID != null) {
                for (n = 0; n < this.pVLANID.length; ++n) {
                    string16 = string16 + this.pVLANID[n] + ", ";
                }
            }
            if (this.addVlanNum != null) {
                for (n = 0; n < this.addVlanNum.length; ++n) {
                    string17 = string17 + this.addVlanNum[n] + ", ";
                }
            }
            if (this.addVlans != null) {
                for (n = 0; n < this.addVlans.length; ++n) {
                    string18 = string18 + this.addVlans[n] + ", ";
                }
            }
            if (this.vEthernetRequired != null) {
                for (n = 0; n < this.vEthernetRequired.length; ++n) {
                    string19 = string19 + this.vEthernetRequired[n] + ", ";
                }
            }
            if (this.virSMCASlotIDs != null) {
                for (n = 0; n < this.virSMCASlotIDs.length; ++n) {
                    string20 = string20 + this.virSMCASlotIDs[n] + ", ";
                }
            }
            if (this.virSMCAHubDrcIndices != null) {
                for (n = 0; n < this.virSMCAHubDrcIndices.length; ++n) {
                    string21 = string21 + this.virSMCAHubDrcIndices[n] + ", ";
                }
            }
            if (this.virSMCAIOBusIDs != null) {
                for (n = 0; n < this.virSMCAIOBusIDs.length; ++n) {
                    string22 = string22 + this.virSMCAIOBusIDs[n] + ", ";
                }
            }
            if (this.virSMCARemoteLparIDs != null) {
                for (n = 0; n < this.virSMCARemoteLparIDs.length; ++n) {
                    string23 = string23 + this.virSMCARemoteLparIDs[n] + ", ";
                }
            }
            if (this.virSMCARemoteSlotIDs != null) {
                for (n = 0; n < this.virSMCARemoteSlotIDs.length; ++n) {
                    string24 = string24 + this.virSMCARemoteSlotIDs[n] + ", ";
                }
            }
            if (this.virSMCARequired != null) {
                for (n = 0; n < this.virSMCARequired.length; ++n) {
                    string25 = string25 + this.virSMCARequired[n] + ", ";
                }
            }
            String string26 = "";
            string26 = "virSCSIServerLPARs = " + string + " " + "virSCSIServerSlotNum = " + string2 + " " + "virSCSIAdapters = " + string3 + " " + "virSCSIDeviceAttributes = " + string4 + " " + "virSCSISupportHMCClients = " + string5 + " " + "virSCSIRequired = " + string6 + " " + "virSerialServerLPARs = " + string7 + " " + "virSerialServerSlotNum = " + string8 + " " + "virSerialAdapters = " + string9 + " " + "virSerialDeviceAttributes = " + string10 + " " + "virSerialSupportHMCClients = " + string11 + " " + "virSerialRequired = " + string12 + " " + "virtualLanSlotIDs = " + string13 + " " + "ieee = " + string14 + " " + "trunk = " + string15 + " " + "pVLANID = " + string16 + " " + "addVlanNum = " + string17 + " " + "addVlans = " + this.addVlans + " " + "vEthernetRequired = " + this.vEthernetRequired + " " + "virSMCASlotIDs = " + string20 + " " + "virSMCAHubDrcIndices = " + string21 + " " + "virSMCAIOBusIDs = " + string22 + " " + "virSMCARemoteLparIDs = " + string23 + " " + "virSMCARemoteSlotIDs = " + string24 + " " + "virSMCARequired = " + string25 + " ";
            return string26;
        }
    }

    public static class IOInfo {
        Hashtable ioSlotInfoTable = null;
        Vector drcIndices = null;

        public String toString() {
            String string = "ioSlotInfoTable = ";
            String string2 = "drcIndices = ";
            if (null != this.ioSlotInfoTable) {
                string = string + this.ioSlotInfoTable;
            }
            if (null != this.drcIndices) {
                string2 = string2 + this.drcIndices;
            }
            return string + "; " + string2 + "\n";
        }
    }

    public static class SlotInstLparIDPair {
        CIMInstance ioSlotInst;
        UnsignedInt16 ownerLpar;

        public String toString() {
            String string = "ioSlotInst = ";
            String string2 = "ownerLpar = ";
            if (null != this.ioSlotInst) {
                string = string + this.ioSlotInst;
            }
            if (null != this.ownerLpar) {
                string2 = string2 + this.ownerLpar;
            }
            return string + "; " + this.ownerLpar + "\n";
        }
    }

    public static class AllocIOAndLparInfo {
        UnsignedInt32[] allocatedIOs;
        UnsignedInt8[] priorityFlags;
        UnsignedInt16[] allocatedIOPools;
        UnsignedInt16[] lparIDs;
        UnsignedInt32[] freeIOs;

        public String toString() {
            int n;
            String string = "allocatedIOs = ";
            String string2 = "priorityFlags = ";
            String string3 = "allocatedIOPools = ";
            String string4 = "lparIDs = ";
            String string5 = "freeIOs = ";
            if (null != this.allocatedIOs) {
                for (n = 0; n < this.allocatedIOs.length; ++n) {
                    string = string + this.allocatedIOs[n] + ", ";
                }
            }
            if (null != this.priorityFlags) {
                for (n = 0; n < this.priorityFlags.length; ++n) {
                    string2 = string2 + this.priorityFlags[n] + ", ";
                }
            }
            if (null != this.allocatedIOPools) {
                for (n = 0; n < this.allocatedIOPools.length; ++n) {
                    string3 = string3 + this.allocatedIOPools[n] + ", ";
                }
            }
            if (null != this.lparIDs) {
                for (n = 0; n < this.lparIDs.length; ++n) {
                    string4 = string4 + this.lparIDs[n] + ", ";
                }
            }
            if (null != this.freeIOs) {
                for (n = 0; n < this.freeIOs.length; ++n) {
                    string5 = string5 + this.freeIOs[n] + ", ";
                }
            }
            return string + "; " + string2 + "; " + string3 + "; " + string4 + "; " + string5 + "\n";
        }
    }

    public static class MemoryTable {
        public UnsignedInt32 memForNotBootableLpar = null;
        public UnsignedInt16[] notBootableLpars = null;
        public LparMemValuePair[] lparMemValPairs = null;

        public String toString() {
            int n;
            String string = "memForNotBootableLpar = ";
            String string2 = "notBootableLpars = ";
            String string3 = "lparMemValPairs = ";
            if (null != this.memForNotBootableLpar) {
                string = string + this.memForNotBootableLpar;
            }
            if (null != this.notBootableLpars) {
                for (n = 0; n < this.notBootableLpars.length; ++n) {
                    string2 = string2 + this.notBootableLpars[n] + ", ";
                }
            }
            if (null != this.lparMemValPairs) {
                for (n = 0; n < this.lparMemValPairs.length; ++n) {
                    string3 = string3 + this.lparMemValPairs[n] + ", ";
                }
            }
            return string + "; " + string2 + "; " + string3 + "\n";
        }
    }

    public static class LparMemValuePair {
        int lparID = 0;
        long memAmount = 0L;
        long minMemAmount = 0L;

        public String toString() {
            String string = "lparID = ";
            String string2 = "memAmount = ";
            String string3 = "minMemAmount = ";
            return string + this.lparID + "; " + string2 + this.memAmount + string3 + this.minMemAmount + "\n";
        }
    }

    public static class AllocMemAndLparInfo {
        UnsignedInt32 allocatedMem;
        UnsignedInt32 res1AllocatedMem;
        UnsignedInt32 res2AllocatedMem;
        UnsignedInt16[] lparIDs;
        UnsignedInt32[] lparMem;

        public String toString() {
            String string = "allocatedMem = ";
            String string2 = "lparIDs = ";
            if (null != this.allocatedMem) {
                string = string + this.allocatedMem;
            }
            if (null != this.lparIDs) {
                for (int i = 0; i < this.lparIDs.length; ++i) {
                    string2 = string2 + this.lparIDs[i] + ", " + this.lparMem[i] + "; ";
                }
            }
            return string + "; " + string2 + "\n";
        }

        int mergeLparMemInfo(AllocMemAndLparInfo allocMemAndLparInfo) {
            int n;
            int n2;
            long l;
            if (this.allocatedMem != null) {
                if (allocMemAndLparInfo.allocatedMem != null) {
                    l = this.allocatedMem.longValue() + allocMemAndLparInfo.allocatedMem.longValue();
                    this.allocatedMem = new UnsignedInt32(l);
                }
            } else {
                this.allocatedMem = allocMemAndLparInfo.allocatedMem;
            }
            if (this.res1AllocatedMem != null) {
                if (allocMemAndLparInfo.res1AllocatedMem != null) {
                    l = this.res1AllocatedMem.longValue() + allocMemAndLparInfo.res1AllocatedMem.longValue();
                    this.res1AllocatedMem = new UnsignedInt32(l);
                }
            } else {
                this.res1AllocatedMem = allocMemAndLparInfo.res1AllocatedMem;
            }
            if (this.res2AllocatedMem != null) {
                if (allocMemAndLparInfo.res2AllocatedMem != null) {
                    l = this.res2AllocatedMem.longValue() + allocMemAndLparInfo.res2AllocatedMem.longValue();
                    this.res2AllocatedMem = new UnsignedInt32(l);
                }
            } else {
                this.res2AllocatedMem = allocMemAndLparInfo.res2AllocatedMem;
            }
            if (this.lparIDs != null) {
                if (allocMemAndLparInfo.lparIDs != null) {
                    n2 = this.lparIDs.length;
                    n = allocMemAndLparInfo.lparIDs.length;
                    UnsignedInt16[] unsignedInt16Array = new UnsignedInt16[n2 + n];
                    System.arraycopy(this.lparIDs, 0, unsignedInt16Array, 0, n2);
                    System.arraycopy(allocMemAndLparInfo.lparIDs, 0, unsignedInt16Array, n2, n);
                    this.lparIDs = unsignedInt16Array;
                }
            } else {
                this.lparIDs = allocMemAndLparInfo.lparIDs;
            }
            if (this.lparMem != null) {
                if (allocMemAndLparInfo.lparMem != null) {
                    n2 = this.lparMem.length;
                    n = allocMemAndLparInfo.lparMem.length;
                    UnsignedInt32[] unsignedInt32Array = new UnsignedInt32[n2 + n];
                    System.arraycopy(this.lparMem, 0, unsignedInt32Array, 0, n2);
                    System.arraycopy(allocMemAndLparInfo.lparMem, 0, unsignedInt32Array, n2, n);
                    this.lparMem = unsignedInt32Array;
                }
            } else {
                this.lparMem = allocMemAndLparInfo.lparMem;
            }
            return 0;
        }
    }

    public static class LparProcValuePair {
        int lparID = 0;
        long procAmount = 0L;
        long minProcAmount = 0L;
        boolean ignoreVirProc = true;
        int virProcAmount = 0;
        int minVirProcAmount = 0;

        public String toString() {
            String string = "lparID = ";
            String string2 = "procAmount = ";
            String string3 = "ignoreVirProc = ";
            String string4 = "virProcAmount = ";
            String string5 = "minVirProcAmount = ";
            return string + this.lparID + "; " + string2 + this.procAmount + "; " + string3 + this.ignoreVirProc + "; " + string4 + this.virProcAmount + "; " + string5 + this.minVirProcAmount + "\n";
        }
    }

    public static class ProcessorTable {
        public UnsignedInt32 procUnitsForNotBootableLpar = null;
        public UnsignedInt32 uncappedProcUnitsForNotBootableLpar = null;
        public UnsignedInt16 virProcsForNotBootableLpar = null;
        public UnsignedInt16[] notBootableLpars = null;
        public LparProcValuePair[] lparProcValPairs = null;
        public Hashtable lparProcTypes = null;
        UnsignedInt32 unavailI5OSProcUnits = null;
        UnsignedInt32 uncappedUnavailI5OSProcUnits = null;
        UnsignedInt16 unavailI5OSVirProcs = null;
        UnsignedInt32 allocI5OSProcUnits = null;
        UnsignedInt32 uncappedAllocI5OSProcUnits = null;
        UnsignedInt16 allocI5OSVirProcs = null;
        public LparProcValuePair[] uncappedI5OSLparProcValPairsWithNoCluster = null;
        public LparProcValuePair[] uncappedI5OSLparProcValPairsWithSameCluster = null;
        public LparProcValuePair[] i5OSLparProcValPairsWithNoCluster = null;
        public LparProcValuePair[] i5OSLparProcValPairsWithSameCluster = null;

        public String toString() {
            int n;
            String string = "procUnitsForNotBootableLpar = ";
            String string2 = "uncappedProcUnitsForNotBootableLpar = ";
            String string3 = "notBootableLpars = ";
            String string4 = "lparProcValPairs = ";
            String string5 = "unavailI5OSProcUnits = ";
            String string6 = "uncappedUnavailI5OSProcUnits = ";
            String string7 = "unavailI5OSVirProcs = ";
            String string8 = "uncappedI5OSLparProcValPairsWithNoCluster = ";
            String string9 = "uncappedI5OSLparProcValPairsWithSameCluster = ";
            String string10 = "i5OSLparProcValPairsWithNoCluster = ";
            String string11 = "i5OSLparProcValPairsWithSameCluster = ";
            if (null != this.procUnitsForNotBootableLpar) {
                string = string + this.procUnitsForNotBootableLpar;
            }
            if (null != this.uncappedProcUnitsForNotBootableLpar) {
                string2 = string2 + this.uncappedProcUnitsForNotBootableLpar;
            }
            if (null != this.notBootableLpars) {
                for (n = 0; n < this.notBootableLpars.length; ++n) {
                    string3 = string3 + this.notBootableLpars[n] + ", ";
                }
            }
            if (null != this.lparProcValPairs) {
                for (n = 0; n < this.lparProcValPairs.length; ++n) {
                    string4 = string4 + this.lparProcValPairs[n] + ", ";
                }
            }
            if (null != this.unavailI5OSProcUnits) {
                string5 = string5 + this.unavailI5OSProcUnits;
            }
            if (null != this.uncappedUnavailI5OSProcUnits) {
                string6 = string6 + this.uncappedUnavailI5OSProcUnits;
            }
            if (null != this.unavailI5OSVirProcs) {
                string7 = string7 + this.unavailI5OSVirProcs;
            }
            if (null != this.uncappedI5OSLparProcValPairsWithNoCluster) {
                for (n = 0; n < this.uncappedI5OSLparProcValPairsWithNoCluster.length; ++n) {
                    string8 = string8 + this.uncappedI5OSLparProcValPairsWithNoCluster[n] + ", ";
                }
            }
            if (null != this.uncappedI5OSLparProcValPairsWithSameCluster) {
                for (n = 0; n < this.uncappedI5OSLparProcValPairsWithSameCluster.length; ++n) {
                    string9 = string9 + this.uncappedI5OSLparProcValPairsWithSameCluster[n] + ", ";
                }
            }
            if (null != this.i5OSLparProcValPairsWithNoCluster) {
                for (n = 0; n < this.i5OSLparProcValPairsWithNoCluster.length; ++n) {
                    string10 = string10 + this.i5OSLparProcValPairsWithNoCluster[n] + ", ";
                }
            }
            if (null != this.i5OSLparProcValPairsWithSameCluster) {
                for (n = 0; n < this.i5OSLparProcValPairsWithSameCluster.length; ++n) {
                    string11 = string11 + this.i5OSLparProcValPairsWithSameCluster[n] + ", ";
                }
            }
            return string + "; " + string2 + "; " + string3 + "; " + string4 + "; lparProcTypes = " + this.lparProcTypes + "; " + string5 + "; " + string6 + "; " + string7 + "; " + string8 + "; " + string9 + "; " + string10 + "; " + string11 + "\n";
        }
    }

    public static class AllocProcAndLparInfo {
        UnsignedInt16 allocatedProc;
        UnsignedInt32 allocatedProcUnits;
        boolean i5OSCapacityCheckingFailed = false;
        UnsignedInt16[] lparIDs;
        Hashtable lparProcTypes;
        Hashtable lparProcSettings = new Hashtable();
        long updatedDesiredProcUnits = 0L;
        boolean pI5OS = false;

        public String toString() {
            String string = "allocatedProc = ";
            String string2 = "allocatedProcUnits = ";
            String string3 = "lparIDs = ";
            if (null != this.allocatedProc) {
                string = string + this.allocatedProc;
            }
            if (null != this.allocatedProcUnits) {
                string2 = string2 + this.allocatedProcUnits;
            }
            if (null != this.lparIDs) {
                for (int i = 0; i < this.lparIDs.length; ++i) {
                    string3 = string3 + this.lparIDs[i] + ", ";
                }
            }
            return string + "; " + string2 + "; " + string3 + "; lparProcTypes = " + this.lparProcTypes + "; lparProcSettings " + this.lparProcSettings + "; updatedDesiredProcUnits = " + this.updatedDesiredProcUnits + "\n";
        }

        int mergeLparProcInfo(AllocProcAndLparInfo allocProcAndLparInfo) {
            HashSet<Object> hashSet;
            Enumeration enumeration;
            long l;
            if (this.allocatedProcUnits != null) {
                if (allocProcAndLparInfo.allocatedProcUnits != null) {
                    l = this.allocatedProcUnits.longValue() + allocProcAndLparInfo.allocatedProcUnits.longValue();
                    this.allocatedProcUnits = new UnsignedInt32(l);
                }
            } else {
                this.allocatedProcUnits = allocProcAndLparInfo.allocatedProcUnits;
            }
            if (this.allocatedProc != null) {
                if (allocProcAndLparInfo.allocatedProc != null) {
                    l = this.allocatedProc.intValue() + allocProcAndLparInfo.allocatedProc.intValue();
                    this.allocatedProc = new UnsignedInt16((int)l);
                }
            } else {
                this.allocatedProc = allocProcAndLparInfo.allocatedProc;
            }
            if (this.lparIDs != null) {
                if (allocProcAndLparInfo.lparIDs != null) {
                    enumeration = Arrays.asList(this.lparIDs);
                    hashSet = new HashSet<UnsignedInt16>();
                    hashSet.addAll((Collection<Object>)((Object)enumeration));
                    int n = this.lparIDs.length;
                    int n2 = allocProcAndLparInfo.lparIDs.length;
                    for (int i = 0; i < allocProcAndLparInfo.lparIDs.length; ++i) {
                        hashSet.add(allocProcAndLparInfo.lparIDs[i]);
                    }
                    this.lparIDs = hashSet.toArray(new UnsignedInt16[hashSet.size()]);
                }
            } else {
                this.lparIDs = allocProcAndLparInfo.lparIDs;
            }
            if (this.lparProcSettings != null) {
                if (allocProcAndLparInfo.lparProcSettings != null) {
                    enumeration = allocProcAndLparInfo.lparProcSettings.keys();
                    while (enumeration.hasMoreElements()) {
                        hashSet = enumeration.nextElement();
                        this.lparProcSettings.put(hashSet, allocProcAndLparInfo.lparProcSettings.get(hashSet));
                    }
                }
            } else {
                this.lparProcSettings = allocProcAndLparInfo.lparProcSettings;
            }
            if (this.lparProcTypes != null) {
                if (allocProcAndLparInfo.lparProcTypes != null) {
                    enumeration = allocProcAndLparInfo.lparProcTypes.keys();
                    while (enumeration.hasMoreElements()) {
                        hashSet = enumeration.nextElement();
                        this.lparProcTypes.put(hashSet, allocProcAndLparInfo.lparProcTypes.get(hashSet));
                    }
                }
            } else {
                this.lparProcTypes = allocProcAndLparInfo.lparProcTypes;
            }
            return 0;
        }
    }
}

